/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.rest.jira.ws.service.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class RestClient {
    private final HttpClientConnectionManager connMgr;
    private HttpClientContext httpContext;

    public RestClient() {
        this.connMgr = this.createConnectionManager();
    }

    public RestClient(HttpClientConnectionManager connectionManger) {
        this.connMgr = connectionManger;
    }

    public void init(URI targetURI, String userId, String password) {
        this.httpContext = this.createHttpContext(targetURI, userId, password);
    }

    private HttpClientConnectionManager createConnectionManager() {
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setDefaultMaxPerRoute(20);
        connMgr.setMaxTotal(100);
        return connMgr;
    }

    private HttpClientBuilder createHttpClientBuilder(HttpClientConnectionManager connectionManager) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setConnectionManager(connectionManager);
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder.setConnectTimeout(5000);
        requestBuilder.setAuthenticationEnabled(true);
        requestBuilder.setRedirectsEnabled(true);
        builder.setDefaultRequestConfig(requestBuilder.build());
        return builder;
    }

    private HttpClientContext createHttpContext(URI targetURI, String userName, String password) {
        HttpHost targetHost = new HttpHost(targetURI.getHost(), targetURI.getPort(), targetURI.getScheme());
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, password);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost), (Credentials)creds);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    public <T, R> R post(URI requestURI, T requestObject, Class<R> targetClass) throws RuntimeException, IOException {
        CloseableHttpClient httpClient = this.createHttpClientBuilder(this.connMgr).build();
        Gson gson = new Gson();
        String requestString = gson.toJson(requestObject);
        CloseableHttpResponse response = null;
        HttpPost postRequest = null;
        String responseString = null;
        try {
            try {
                InputStream contentStream;
                StringEntity input = new StringEntity(requestString, "UTF-8");
                input.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                input.setContentEncoding("UTF-8");
                postRequest = new HttpPost(requestURI);
                postRequest.setEntity((HttpEntity)input);
                response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)postRequest, (HttpContext)this.httpContext);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200 && statusCode != 201) {
                    HttpEntity entity = response.getEntity();
                    responseString = EntityUtils.toString((HttpEntity)entity);
                    throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode() + " HTTP reason phrase: " + response.getStatusLine().getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                responseString = EntityUtils.toString((HttpEntity)entity);
                if (entity != null && (contentStream = entity.getContent()) != null) {
                    contentStream.close();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (postRequest != null) {
                postRequest.releaseConnection();
            }
            if (response != null) {
                response.close();
            }
        }
        if (responseString != null) {
            return (R)gson.fromJson(responseString, targetClass);
        }
        return null;
    }

    public <T, R> R post2(URI requestURI, String jrequestObject, Class<R> targetClass) throws RuntimeException, IOException {
        CloseableHttpClient httpClient = this.createHttpClientBuilder(this.connMgr).build();
        Gson gson = new Gson();
        String requestString = jrequestObject;
        CloseableHttpResponse response = null;
        HttpPost postRequest = null;
        String responseString = null;
        try {
            try {
                InputStream contentStream;
                StringEntity input = new StringEntity(requestString, "UTF-8");
                input.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                input.setContentEncoding("UTF-8");
                postRequest = new HttpPost(requestURI);
                postRequest.setEntity((HttpEntity)input);
                response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)postRequest, (HttpContext)this.httpContext);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200 && statusCode != 201) {
                    HttpEntity entity = response.getEntity();
                    responseString = EntityUtils.toString((HttpEntity)entity);
                    throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode() + " HTTP reason phrase: " + response.getStatusLine().getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                responseString = EntityUtils.toString((HttpEntity)entity);
                if (entity != null && (contentStream = entity.getContent()) != null) {
                    contentStream.close();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (postRequest != null) {
                postRequest.releaseConnection();
            }
            if (response != null) {
                response.close();
            }
        }
        if (responseString != null) {
            return (R)gson.fromJson(responseString, targetClass);
        }
        return null;
    }

    public void close() {
        if (this.connMgr != null) {
            this.connMgr.closeExpiredConnections();
        }
    }
}

