/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.exporter.ui;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExportOrImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.Configuration;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.ui.JiraLoginPage;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportWizardContribution
implements IExportOrImportWizardContribution {
    private final ModuleSpecification moduleSpecification;
    private final String dataName;
    private final ImageDescriptor dataIcon;

    public ExportWizardContribution(ModuleSpecification moduleSpecification, String dataName, ImageDescriptor dataIcon) {
        this.moduleSpecification = moduleSpecification;
        this.dataName = dataName;
        this.dataIcon = dataIcon;
    }

    public ExportWizardContribution(String moduleID, ModuleSpecification moduleSpecification, ObjectType objectTypeToBeExported) {
        this.moduleSpecification = moduleSpecification;
        this.dataName = new LabelProvider(objectTypeToBeExported.getObjectTypeName()).getLabel(Locale.getDefault());
        this.dataIcon = objectTypeToBeExported.getObjectTypeIcon() != null && objectTypeToBeExported.getObjectTypeIcon().length() > 0 ? new IconResource(moduleID, objectTypeToBeExported.getObjectTypeIcon()).getImageDescriptor() : null;
    }

    public String getName() {
        return String.valueOf(Messages.getString("QCExportWizard.ExportWizardContribution.Name.Pre")) + " " + this.dataName + " " + Messages.getString("QCExportWizard.ExportWizardContribution.Name.Post");
    }

    public String getDescription() {
        return String.valueOf(Messages.getString("QCExportWizard.ExportWizardContribution.Description.Pre")) + " " + this.dataName + " " + Messages.getString("QCExportWizard.ExportWizardContribution.Description.InBetween") + " " + new LabelProvider(this.moduleSpecification.getModuleDataName()).getLabel(Locale.getDefault()) + " " + Messages.getString("QCExportWizard.ExportWizardContribution.Description.Post");
    }

    public ImageDescriptor getImage() {
        return this.dataIcon;
    }

    public List<IWizardPage> getExporterOrImporterSpecificWizardPages(String configuration) {
        return Arrays.asList(new IWizardPage[]{new JiraLoginPage(Configuration.getConfiguration(configuration))});
    }

    public IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }
}

