/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.exporter;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleExportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleExportAdapter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExportOrImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExportableData;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.Configuration;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.ExportCache;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.ui.ExportWizardContribution;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.ui.JiraLoginPage;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.JiraFacade;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.CommitException;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IExportTargetTool;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IProject;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirement;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirementNameChecker;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirementType;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.JiraFacadeException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.CanonicalStringCoDecForData;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IListIteratorRW_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.rest.jira.service.IJiraService;
import com.arcway.lib.rest.jira.ws.json.Issue;
import com.arcway.lib.rest.jira.ws.json.IssueComponent;
import com.arcway.lib.rest.jira.ws.json.IssueResult;
import com.arcway.lib.rest.jira.ws.service.IJiraWsService;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.lib.high.declaration.type.property.RepositoryPropertyTypeID;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JiraExporter
implements IGenericModuleExportAdapter {
    private static final ILogger logger = Logger.getLogger(JiraExporter.class);
    private static final int QCTYPE_OF_FOLDER = 1;
    private static final String QCFIELDID_OF_FOLDER_LABELFIELD = "RQ_REQ_NAME";
    private static final String NAME_OF_ROOTFOLDER = "Arcway Cockpit";
    private static final String REST_API_FOLDER = "rest/api/2/";
    private static final DateFormat QC_CREATIONTIME_FORMAT = new SimpleDateFormat("HH:mm");
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private ISet_<IRepositoryObjectTypeID> objectTypesToBeExported;
    private String dataName;
    private ImageDescriptor dataIcon;
    private IConfigurationRO currentConfiguration;
    private PresentationContext presentationContext;
    private IExportTargetTool currentJiraConnection;
    private IProject currentJiraProject;
    private String commitComment;
    private JiraLoginPage.Parameter loginParameter;
    IRepositoryTypeManagerRO typeManager;

    public void construct(String moduleID_, Collection<String> objectTypeIDs, String dataName_, ImageDescriptor dataIcon_) {
        this.moduleID = moduleID_;
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID_);
        RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(ModuleIdentification.getModuleIDForPlatform((String)moduleID_), "declaration_module_coremodule");
        HashSet_ objectTypesToBeExported_ = new HashSet_(this.moduleSpecification.getModuleDataSpecification().getObjectTypeList().size(), IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        for (String objectTypeID : objectTypeIDs) {
            objectTypesToBeExported_.add((Object)repositoryIDCreator.createObjectTypeIDForRealType(ClientDataFactory_TypesHelper.getDataTypeID((String)moduleID_, (String)objectTypeID)));
        }
        this.objectTypesToBeExported = objectTypesToBeExported_;
        this.dataName = dataName_;
        this.dataIcon = dataIcon_;
    }

    public void startExport(List<?> parameters, String configuration, PresentationContext presentationContext_, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        this.presentationContext = presentationContext_;
        this.currentConfiguration = Configuration.getConfiguration(configuration);
        this.loginParameter = (JiraLoginPage.Parameter)parameters.get(0);
        this.currentJiraConnection = JiraFacade.getJira();
        try {
            this.currentJiraProject = this.currentJiraConnection.connect(this.currentConfiguration.getURL(), this.currentConfiguration.getDomain(), this.currentConfiguration.getProject(), this.loginParameter.username, this.loginParameter.password);
        }
        catch (JiraFacadeException qcfE) {
            throw new ExportOrImportFailedException(2, qcfE.getLocalizedMessage());
        }
    }

    public void export(IExportableData dataToExport, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        if (logger.isInfoEnabled()) {
            logger.info("Export: " + dataToExport);
        }
        assert (dataToExport instanceof GenericModuleExportableData);
        GenericModuleExportableData gmDataToExport = (GenericModuleExportableData)dataToExport;
        IRepositorySnippetRO snippet = gmDataToExport.repositorySnippet;
        this.typeManager = gmDataToExport.typeManager;
        IList_ explicitObjects = snippet.getExplicitObjects();
        for (RepositoryObjectSampleWithParentObjectReference repositoryObjectSampleWithParentObjectReference : explicitObjects) {
            IRepositoryObjectSample objectSample = repositoryObjectSampleWithParentObjectReference.getObjectSample();
            IRepositoryObjectTypeID objectTypeID = objectSample.getObjectTypeID();
            String objectTypeIDAsString = objectTypeID.toCanonicalString();
            if (!"com.arcway.cockpit.module.genericmodule-requirementsmodule3.object.data.moduleData.requirement".equals(objectTypeIDAsString)) continue;
            IRepositoryPropertySetSample propertySetSample = objectSample.getPropertySetSample();
            String id = JiraExporter.getRequirementID(propertySetSample);
            String name = JiraExporter.getRequiremnetName(propertySetSample);
            String description = JiraExporter.getRequiremnetDescription(propertySetSample);
            String uid = JiraExporter.getRequirementUID(propertySetSample);
            if (logger.isInfoEnabled()) {
                logger.info("Export Requirement - ID: " + id + " Requirement Name: " + name + " Description:  " + description + " UID: " + uid);
            }
            this.exportRequirementToJira(id, name, description, uid);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Export ended ");
        }
    }

    private static String getRequirementID(IRepositoryPropertySetSample propertySetSample) {
        IRepositoryPropertyTypeID repositoryPropertyTypeID = new IRepositoryPropertyTypeID(){

            public String toCanonicalString() {
                return "com.arcway.cockpit.module.genericmodule-requirementsmodule3.object.data.moduleData.requirement.property.id";
            }
        };
        IRepositoryPropertySample propertySample = propertySetSample.getPropertySample(repositoryPropertyTypeID);
        IRepositoryData value = propertySample.getValue();
        IRepositoryDataType dataType = value.getDataType();
        if (!IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)dataType.getRepositoryDataTypeID(), (Object)RDTDisplayName.DATA_TYPE_ID)) {
            throw new RuntimeException("Wrong type: " + dataType.getRepositoryDataTypeID().toCanonicalString());
        }
        RDTDisplayName concreteDataType = (RDTDisplayName)dataType;
        String requirementID = concreteDataType.dataToValue(value);
        return requirementID;
    }

    private static String getRequiremnetName(IRepositoryPropertySetSample propertySetSample) {
        IRepositoryPropertyTypeID repositoryPropertyTypeID = new IRepositoryPropertyTypeID(){

            public String toCanonicalString() {
                return "com.arcway.cockpit.module.genericmodule-requirementsmodule3.object.data.moduleData.requirement.property.name";
            }
        };
        IRepositoryPropertySample propertySample = propertySetSample.getPropertySample(repositoryPropertyTypeID);
        IRepositoryData value = propertySample.getValue();
        IRepositoryDataType dataType = value.getDataType();
        if (!IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)dataType.getRepositoryDataTypeID(), (Object)RDTDisplayName.DATA_TYPE_ID)) {
            throw new RuntimeException("Wrong type: " + dataType.getRepositoryDataTypeID().toCanonicalString());
        }
        RDTDisplayName concreteDataType = (RDTDisplayName)dataType;
        String requirementName = concreteDataType.dataToValue(value);
        return requirementName;
    }

    private static String getRequiremnetDescription(IRepositoryPropertySetSample propertySetSample) {
        IRepositoryPropertyTypeID repositoryPropertyTypeID = new IRepositoryPropertyTypeID(){

            public String toCanonicalString() {
                return "com.arcway.cockpit.module.genericmodule-requirementsmodule3.object.data.moduleData.requirement.property.description";
            }
        };
        IRepositoryPropertySample propertySample = propertySetSample.getPropertySample(repositoryPropertyTypeID);
        IRepositoryData value = propertySample.getValue();
        IRepositoryDataType dataType = value.getDataType();
        if (!IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)dataType.getRepositoryDataTypeID(), (Object)RDTFreeText.DATA_TYPE_ID)) {
            throw new RuntimeException("Wrong type: " + dataType.getRepositoryDataTypeID().toCanonicalString());
        }
        RDTFreeText concreteDataType = (RDTFreeText)dataType;
        String requirementDescription = concreteDataType.dataToValue(value);
        return requirementDescription;
    }

    private static String getRequirementUID(IRepositoryPropertySetSample propertySetSample) {
        RepositoryPropertyTypeID repositoryPropertyTypeID = COTIDsCockpitData.PROPERTY_TYPE_ID_UID;
        IRepositoryPropertySample propertySample = propertySetSample.getPropertySample((IRepositoryPropertyTypeID)repositoryPropertyTypeID);
        IRepositoryData value = propertySample.getValue();
        IRepositoryDataType dataType = value.getDataType();
        if (!IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)dataType.getRepositoryDataTypeID(), (Object)RDTUID.DATA_TYPE_ID)) {
            throw new RuntimeException("Wrong type: " + dataType.getRepositoryDataTypeID().toCanonicalString());
        }
        RDTUID concreteDataType = (RDTUID)dataType;
        String requirementUID = concreteDataType.dataToValue(value);
        return requirementUID;
    }

    private void exportRequirementToJira(String id, String name, String description, String uid) {
        try {
            boolean issueExists;
            if (logger.isInfoEnabled()) {
                logger.info("Init JIRA-Service");
            }
            System.setProperty("javax.net.ssl.trustStore", "NONE");
            System.setProperty("javax.net.ssl.trustStoreType", "WINDOWS-ROOT");
            String jiraURL = this.currentConfiguration.getURL();
            String jiraApiUrl = String.valueOf(jiraURL) + REST_API_FOLDER;
            String username = this.loginParameter.username;
            String password = this.loginParameter.password;
            String jiraProjectKey = this.currentConfiguration.getProject();
            String jiraComponentName = this.currentConfiguration.getComponent().trim();
            String customFieldNo_ExternalIssueId = this.currentConfiguration.getQCFieldIDForCockpitTechnicalID();
            String customFieldNo_ExternalIssueLink = this.currentConfiguration.getURLFieldID();
            String issueType = this.currentConfiguration.getIssueTypeName();
            String externalURLPrefix = this.currentConfiguration.getURLPrefix();
            URI targetURI = new URI(jiraApiUrl);
            IJiraService jiraService = (IJiraService)PlatformUI.getWorkbench().getService(IJiraService.class);
            IJiraWsService wsService = jiraService.createJiraWsService(targetURI, username, password);
            Issue issue = new Issue();
            issue.getFields().getProject().setKey(jiraProjectKey);
            if (jiraComponentName.length() > 0) {
                IssueComponent comp = new IssueComponent();
                comp.setName(jiraComponentName);
                issue.getFields().getComponents().add(comp);
            }
            issue.getFields().getIssuetype().setName(issueType);
            issue.getFields().setSummary(name);
            issue.getFields().setDescription(description);
            issue.getFields().getAssignee().setName(username);
            if (customFieldNo_ExternalIssueId.trim().length() > 0) {
                issue.getFields().getCustomFields().put("customfield_" + customFieldNo_ExternalIssueId, id);
                IssueResult issueResult0 = wsService.searchIssues(jiraProjectKey, jiraComponentName, customFieldNo_ExternalIssueId, id, 50);
                issueExists = issueResult0.getTotal() > 0;
            } else {
                issueExists = false;
            }
            if (customFieldNo_ExternalIssueLink.trim().length() > 0) {
                issue.getFields().getCustomFields().put("customfield_" + customFieldNo_ExternalIssueLink, String.valueOf(externalURLPrefix) + uid);
            }
            if (issueExists) {
                if (logger.isInfoEnabled()) {
                    logger.info("Issue " + id + " exists, creation skipped. ");
                }
            } else {
                Issue result = wsService.createIssue(issue);
                if (jiraComponentName.length() == 0) {
                    jiraComponentName = null;
                }
                IssueResult issueResult1 = wsService.searchIssues(jiraProjectKey, jiraComponentName, 100);
                if (logger.isInfoEnabled()) {
                    logger.info("Issue created: " + result.getId() + "-" + result.getKey() + " Total issue result: " + issueResult1.getTotal());
                }
            }
            wsService.close();
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            throw new RuntimeException("error on create or query issue", e);
        }
    }

    public void closeExport(IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        this.currentJiraConnection.disconnect(this.currentJiraProject);
    }

    public ExportOrImportResult.OpenExportConfiguration getOpenExportConfiguration() {
        return null;
    }

    public IExportOrImportWizardContribution getWizardContribution() {
        return new ExportWizardContribution(this.moduleSpecification, this.dataName, this.dataIcon);
    }

    public String getConfigurationKey() {
        return "qualitycenteradapter";
    }

    private IRequirement findOrCreateRootFolderForCockpitExports() throws CommitException {
        return null;
    }

    private static IRequirement findFolder(IRequirement parentFolder, String folderName) {
        return null;
    }

    private IRequirement createFolder(IRequirement parentFolder, String folderName) throws CommitException {
        return null;
    }

    private boolean removeParentsWithoutRelevantChildrenRecursively(IMapRW_<IRepositoryObjectReference, IListRW_<RepositoryObjectSampleWithParentObjectReference>> map_parentID_children, RepositoryObjectSampleWithParentObjectReference parentInQuestion, ISet_<IRepositoryObjectTypeID> objectTypesToBeExported_, IRepositoryTypeManagerRO typeManager) {
        IRepositoryObjectSample parentSample = parentInQuestion.getObjectSample();
        IListRW_ children = (IListRW_)map_parentID_children.getByKey((Object)new RepositoryObjectReference(parentSample.getObjectTypeID(), parentSample.getObjectID(typeManager)));
        if (children != null) {
            IListIteratorRW_ childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                RepositoryObjectSampleWithParentObjectReference child = (RepositoryObjectSampleWithParentObjectReference)childrenIterator.next();
                if (this.removeParentsWithoutRelevantChildrenRecursively(map_parentID_children, child, objectTypesToBeExported_, typeManager)) continue;
                childrenIterator.remove();
            }
        }
        if (children == null || children.isEmpty()) {
            return RepositoryObjectTypes.findMostSpecificSuperObjectType((IRepositoryObjectType)typeManager.findObjectType(parentSample.getObjectTypeID()), objectTypesToBeExported_) != null;
        }
        return true;
    }

    private void checkOutRequirementsRecursively(RepositoryObjectSampleWithParentObjectReference objectInCockpit, IMap_<IRepositoryObjectReference, ? extends IList_<RepositoryObjectSampleWithParentObjectReference>> map_parentID_children, ExportCache cache, IRepositorySnippetRO snippet) throws ExportOrImportFailedException {
        IRepositoryObjectSample sampleOfObjectInCockpit = objectInCockpit.getObjectSample();
        IRepositoryObjectReference referenceOfObjectInCockpit = sampleOfObjectInCockpit.getObjectReference(cache.getTypeManager());
        IList_ children = (IList_)map_parentID_children.getByKey((Object)referenceOfObjectInCockpit);
        if (children != null) {
            for (RepositoryObjectSampleWithParentObjectReference child : children) {
                IRepositoryObjectSample childObjectSample = child.getObjectSample();
                cache.checkOutQCRequirement(childObjectSample);
                this.checkOutRequirementsRecursively(child, map_parentID_children, cache, snippet);
            }
        }
    }

    private void exportObjectsRecursively(RepositoryObjectSampleWithParentObjectReference objectInCockpit, IRequirement objectInQC, IMap_<IRepositoryObjectReference, ? extends IList_<RepositoryObjectSampleWithParentObjectReference>> map_parentID_children, ExportCache cache, IRepositorySnippetRO snippet) throws ExportOrImportFailedException {
        IRepositoryObjectSample sampleOfObjectInCockpit = objectInCockpit.getObjectSample();
        IRepositoryObjectReference referenceOfObjectInCockpit = sampleOfObjectInCockpit.getObjectReference(cache.getTypeManager());
        IList_ children = (IList_)map_parentID_children.getByKey((Object)referenceOfObjectInCockpit);
        if (children != null) {
            for (RepositoryObjectSampleWithParentObjectReference child : children) {
                IRepositoryObjectSample childObjectSample = child.getObjectSample();
                IRepositoryObjectTypeID childObjectTypeID = childObjectSample.getObjectTypeID();
                cache.setObjectTypeID(childObjectTypeID);
                IRequirementType qcRequirementType = cache.getRequirementType();
                IRequirement childInQC = this.exportObject(childObjectSample, objectInQC, qcRequirementType, cache, snippet);
                this.exportObjectsRecursively(child, childInQC, map_parentID_children, cache, snippet);
            }
        }
    }

    private IRequirement exportObject(IRepositoryObjectSample objectSample, IRequirement parent, IRequirementType qcRequirementType, ExportCache cache, IRepositorySnippetRO snippet) throws ExportOrImportFailedException {
        IRepositoryObjectReference referenceOfObjectInCockpit;
        IRepositoryObjectReference cockpitTechnicalID = referenceOfObjectInCockpit = objectSample.getObjectReference(cache.getTypeManager());
        String cockpitTechnicalIDAsString = JiraExporter.getSerialisedCockpitTechnicalID(cockpitTechnicalID, cache);
        try {
            System.err.println(XMLCoDecForData.encodeIntoString((Object)objectSample, (IDataType)DTRepositoryObjectSample.getInstance((IRepositoryTypeManagerRO)this.typeManager, (boolean)true), (String)"cockpitTechnicalIDAsString", null, (String)"UTF-8", (XMLFormatMode)XMLFormatMode.WITH_INDENTION));
        }
        catch (EXXMLEncodingFailed e) {
            throw new Error(e);
        }
        return null;
    }

    private static void fillMandatoryAttributes(IRequirement requirement, String defaultStringValue) {
        requirement.fillMandatoryAttributesWithDefaultValues(defaultStringValue);
    }

    private static void setMetaAttributes(IRequirement requirementToCreate, IProject project, IRepositoryObjectSample requirementToExport, ExportCache cache) {
        String authorName = null;
        Date creationDate = null;
        if (cache.isUsingCockpitMetaAttributes()) {
            String cockpitAuthorName = null;
            if (cache.isUsingCockpitModificationMetaAttributes()) {
                cockpitAuthorName = cache.getDeprecationManager().getLastModifierOfObject(requirementToExport);
                creationDate = cache.getDeprecationManager().getDateOfLastModificationOfObject(requirementToExport);
            } else {
                cockpitAuthorName = cache.getDeprecationManager().getAuthorOfObject(requirementToExport);
                creationDate = cache.getDeprecationManager().getCreationDateOfObject(requirementToExport);
            }
            if (cache.isUsingAuthorMapping()) {
                authorName = (String)cache.getAuthorMapping().getByKey((Object)cockpitAuthorName);
                if (authorName == null) {
                    assert (false);
                    authorName = project.getConnectedUser();
                }
            } else {
                authorName = cockpitAuthorName;
            }
        } else {
            authorName = project.getConnectedUser();
            creationDate = new Date(System.currentTimeMillis());
        }
        requirementToCreate.setFieldValue("RQ_REQ_AUTHOR", authorName);
        requirementToCreate.setFieldValue("RQ_REQ_DATE", null);
        requirementToCreate.setFieldValue("RQ_REQ_TIME", QC_CREATIONTIME_FORMAT.format(creationDate));
    }

    public static String getSerialisedCockpitTechnicalID(IRepositoryObjectReference cockpitTechnicalID, ExportCache cache) {
        String cockpitTechnicalIDAsString = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)cache.getTypeManager()), (Object)cockpitTechnicalID);
        assert (cockpitTechnicalIDAsString.length() <= 255);
        if (cockpitTechnicalIDAsString.length() > 255) {
            cockpitTechnicalIDAsString = cockpitTechnicalIDAsString.substring(0, 255);
        }
        return cockpitTechnicalIDAsString;
    }

    private static boolean compareCustomPropertyFileWithAttachmentFile(File customPropertyFile, File attachmentFile) {
        try {
            return FileHelper.compareFiles((File)customPropertyFile, (File)attachmentFile, (boolean)false);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.warn("Exception comparing a custom property file with an attachment content.", (Throwable)jeriE);
            return false;
        }
    }

    private static class DuplicateRequirementNameHandler
    implements IRequirementNameChecker {
        private final ISetRW_<String> requirementNamesInUse;

        public DuplicateRequirementNameHandler(ISetRW_<String> requirementNamesInUse) {
            this.requirementNamesInUse = requirementNamesInUse;
        }

        @Override
        public String checkRequirementName(String actualRequirementName) {
            int index = 1;
            String replacementName = actualRequirementName;
            while (this.requirementNamesInUse.contains((Object)replacementName)) {
                replacementName = String.valueOf(actualRequirementName) + " (" + Integer.toString(++index) + ")";
            }
            this.requirementNamesInUse.add((Object)replacementName);
            return replacementName;
        }
    }
}

