/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.exporter;

import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.ExportCache;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IField;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IFieldOfRequirementType;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IProject;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirementType;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

public class JiraConfigurationChecker {
    public static Tuple<String, String> checkConfiguration(IConfigurationRO configuration, ExportCache cache, ICollection_<IRepositoryObjectTypeID> objectTypesToExport, IProject qcProject) {
        return new Tuple(null, null);
    }

    public static Tuple<String, String> checkGeneralConfiguration(IField technicalIDField, boolean isUsingCockpitMetaData, boolean isUsingAuthorMapping, IProject qcProject, ISourceAttributeDescription_forEnumValueMapping<String> sourceAttributeForAuthorMapping, EnumValueMapping<String, String> authorMapping, Collection<Tuple<IRequirementType, ITechnicalIDFieldAgainstAttributeMappingChecker>> mappingConfigurations) {
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (isUsingCockpitMetaData) {
            if (isUsingAuthorMapping) {
                for (EnumValue enumValue : sourceAttributeForAuthorMapping.getValueRange()) {
                    if (authorMapping.getByKey((Object)((String)enumValue.getId())) != null) continue;
                    String problemMessage = Messages.getString("ConfigurationPage.MetaAttributes.Author.Error.IncompleteMappings");
                    problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
                    break;
                }
            } else if (qcProject.getRequirementField("RQ_REQ_AUTHOR").isVerifiedListField()) {
                String string = Messages.getString("ConfigurationPage.MetaAttributes.AuthorMapping.Error.AuthorIsVerifiedValue");
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
            }
        }
        if (technicalIDField == null) {
            String string = Messages.getString("ConfigurationPage.TechnicalIDField.Error.NoTechnicalIDFieldSelected");
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)string, null));
        } else {
            for (Tuple tuple : mappingConfigurations) {
                Tuple<String, String> newProblemAndWarningMessage = JiraConfigurationChecker.checkCockpitTechnicalIDField(technicalIDField, (ITechnicalIDFieldAgainstAttributeMappingChecker)tuple.getT2(), (IRequirementType)tuple.getT1());
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, newProblemAndWarningMessage);
            }
            if (technicalIDField.getMaximumLength() < 255) {
                String string = Messages.getString("ConfigurationPage.TechnicalIDField.Warning.LessThan255Characters");
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
            }
        }
        if (!qcProject.hasConnectedUserRightToAddRequirements()) {
            String string = Messages.getString("ConfigurationPage.Permissions.AddRequirement.NoPermissionWarning");
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
        }
        if (!qcProject.hasConnectedUserRightToModifyRequirements()) {
            String string = Messages.getString("ConfigurationPage.Permissions.ModifyRequirement.NoPermissionWarning");
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
        }
        if (technicalIDField != null && !qcProject.hasConnectedUserRightToModifyRequirementField(technicalIDField.getID())) {
            String string = NLS.bind((String)Messages.getString("ConfigurationPage.Permissions.ModifyRequirementField.NoPermissionWarning"), (Object)technicalIDField.getName());
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
        }
        return problemAndWarningMessage;
    }

    public static Tuple<String, String> checkPerTypeConfiguration(IRequirementType requirementType, IAttributeMappingChecker attributeMappingChecker, boolean detailedMessageForAttributeMappings, IField technicalIDField, ITechnicalIDFieldAgainstAttributeMappingChecker technicalIDFieldChecker, IProject qcProject) {
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (requirementType == null) {
            String problemMessage = Messages.getString("QualityCenterExporter.Failure.IncompleteMappings");
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
        } else {
            ThreeTuple<Boolean, String, String> isAttributeMappingComplete = attributeMappingChecker.checkAttributeMapping();
            if (!((Boolean)isAttributeMappingComplete.getComponent1()).booleanValue()) {
                String problemMessage = null;
                problemMessage = detailedMessageForAttributeMappings ? (String)isAttributeMappingComplete.getComponent2() : Messages.getString("QualityCenterExporter.Failure.IncompleteMappings");
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
            } else if (isAttributeMappingComplete.getComponent3() != null) {
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)((String)isAttributeMappingComplete.getComponent3())));
            }
            if (technicalIDField != null) {
                Tuple<String, String> newProblemAndWarningMessage = JiraConfigurationChecker.checkCockpitTechnicalIDField(technicalIDField, technicalIDFieldChecker, requirementType);
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, newProblemAndWarningMessage);
            }
            for (ITargetAttributeDescription targetAttribute : attributeMappingChecker.getMappedTargetAttributes()) {
                String warningMessage;
                if ((Integer)targetAttribute.getDataTypeKey() == 1000) {
                    if (qcProject.hasConnectedUserRightToModifyRequirementAttachments()) continue;
                    warningMessage = Messages.getString("ConfigurationPage.Permissions.ModifyRequirementAttachments.NoPermissionWarning");
                    problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)warningMessage));
                    continue;
                }
                if (qcProject.hasConnectedUserRightToModifyRequirementField((String)targetAttribute.getKey())) continue;
                warningMessage = NLS.bind((String)Messages.getString("ConfigurationPage.Permissions.ModifyRequirementField.NoPermissionWarning"), (Object)targetAttribute.getName());
                problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)warningMessage));
            }
        }
        return problemAndWarningMessage;
    }

    private static Tuple<String, String> checkCockpitTechnicalIDField(IField technicalIDField, ITechnicalIDFieldAgainstAttributeMappingChecker technicalIDFieldChecker, IRequirementType qcRequirementType) {
        IFieldOfRequirementType technicalIDFieldInRequirementType;
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (!technicalIDFieldChecker.checkTechnicalIDFieldAgainstAttributeMapping(technicalIDField)) {
            String problemMessage = Messages.getString("MappingConfigurationPage.TechnicalIDField.Error.FieldIsAlreadyUsedForOtherData");
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
        }
        if ((technicalIDFieldInRequirementType = qcRequirementType.getField(technicalIDField.getID())) == null) {
            String warningMessage = Messages.getString("MappingConfigurationPage.TechnicalIDField.Error.FieldIsNotActiveInQCRequirementType");
            problemAndWarningMessage = JiraConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)warningMessage));
        }
        return problemAndWarningMessage;
    }

    private static Tuple<String, String> mergeProblemAndWarningMessage(Tuple<String, String> currentMessages, Tuple<String, String> newMessages) {
        if (currentMessages.getT1() == null) {
            if (newMessages.getT1() != null || newMessages.getT2() != null && currentMessages.getT2() == null) {
                return newMessages;
            }
            return currentMessages;
        }
        return currentMessages;
    }

    public static interface IAttributeMappingChecker {
        public ThreeTuple<Boolean, String, String> checkAttributeMapping();

        public ICollection_<? extends ITargetAttributeDescription<String, Integer, String>> getMappedTargetAttributes();
    }

    public static interface ITechnicalIDFieldAgainstAttributeMappingChecker {
        public boolean checkTechnicalIDFieldAgainstAttributeMapping(IField var1);
    }
}

