/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.configuration.ui;

import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.RQM2JiraPluginActivator;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.Configuration;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.AbstractConfigurationPage;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.AttributeMappingConfigurationHelper;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.MappingConfigurationPage;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.QCConnectionAdmin;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.GMExportSpecsHelper;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.JiraConfigurationChecker;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IField;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirementType;
import com.arcway.frontend.definition.lib.ui.modificationproblems.RepositoryAccessModificationProblem;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeMappingWidget;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMappingDialogue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GeneralConfigurationPage
extends AbstractConfigurationPage {
    private static final ILogger logger = Logger.getLogger(GeneralConfigurationPage.class);
    private Image icon = null;
    private IFrameProjectAgent projectAgent = null;
    private MappingConfigurationPage[] mappingPages = null;
    private IList_<IRepositoryObjectTypeID> relevantObjectTypes;
    private String oldConfigurationString;
    private Configuration configuration;
    private IArcwayMemento authorMappingMemento;
    private EnumValueMapping<String, String> authorMapping;
    private List<IField> technicalIDFieldAttributeCandidates;
    private ISourceAttributeDescription_forEnumValueMapping<String> sourceAttributeForAuthorMapping;
    private ITargetAttributeDescription_forEnumValueMapping<String> targetAttributeForAuthorMapping;
    private boolean areWidgetsCreated;
    private boolean isInConnectedState;
    private Text textURL;
    private Text textProject;
    private Text textComponent;
    private Text textIssueTypeName;
    private Text textArcwayIdFieldId;
    private Text textArcwayURLFieldId;
    private Text textArcwayURLPrefix;
    private Composite metaAttributesComposite;
    private Composite technicalIDFieldComposite;
    private Button qcMetaDataButton;
    private Button cockpitMetaDataButton;
    private Button cockpitModificationTimeButton;
    private Button cockpitCreationTimeButton;
    private Button userMappingCheckBox;
    private Button userMappingButton;
    private Combo technicalIDFieldCombo;
    private QCConnectionAdmin qcConnectionAdmin;
    private Collection<? extends ILockDeprecated> locks;
    private boolean hasHandledCommitRequestForChild;
    private boolean hasCommittedForChild;
    private boolean hasDiscardedCommitForChild;

    public GeneralConfigurationPage() {
        super(true);
    }

    public String getPropertyName() {
        return Messages.getString("ConfigurationPage.Name");
    }

    public Image getPropertyImage() {
        if (this.icon == null) {
            this.icon = ImageDescriptor.createFromURL((URL)RQM2JiraPluginActivator.getDefault().getBundle().getEntry("/icons/jira.gif")).createImage();
        }
        return this.icon;
    }

    public IPropertiesListEntry[] getPropertyChildren1() {
        if (this.mappingPages == null) {
            this.mappingPages = new MappingConfigurationPage[0];
        }
        return null;
    }

    @Override
    public QCConnectionAdmin init(ICockpitProjectData[] elements) {
        this.projectAgent = (IFrameProjectAgent)elements[0];
        this.qcConnectionAdmin = new QCConnectionAdmin(this);
        this.areWidgetsCreated = false;
        this.isInConnectedState = false;
        this.mappingPages = null;
        this.oldConfigurationString = null;
        this.sourceAttributeForAuthorMapping = null;
        this.targetAttributeForAuthorMapping = null;
        this.hasHandledCommitRequestForChild = false;
        this.hasCommittedForChild = false;
        this.hasDiscardedCommitForChild = false;
        this.relevantObjectTypes = GMExportSpecsHelper.getObjectTypesWhichMayBeExportedToHPQC();
        this.readConfiguration();
        return this.qcConnectionAdmin;
    }

    @Override
    protected String getDialogueTitle() {
        return Messages.getString("ConfigurationPage.Title");
    }

    @Override
    protected String getDialogueMessage() {
        return Messages.getString("ConfigurationPage.Message");
    }

    @Override
    protected String getLoginHintMessage() {
        return Messages.getString("ConfigurationPage.Login.Message");
    }

    @Override
    protected void createQCIndependantConfigurationUI(Composite composite) {
        FontData[] urlExampleFont;
        ((GridLayout)composite.getLayout()).numColumns = 2;
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)composite.getLayout()).horizontalSpacing = 10;
        GeneralConfigurationPage.createLabel(composite, String.valueOf(Messages.getString("ConfigurationPage.ConnectionConfiguration.Label")) + ":", 2, true, false);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.URL.Label")) + ":");
        Composite urlComposite = new Composite(composite, 0);
        GridData layoutData = new GridData(4, 2, true, false);
        urlComposite.setLayoutData((Object)layoutData);
        GridLayout urlLayout = new GridLayout();
        urlLayout.marginWidth = 0;
        urlLayout.marginHeight = 0;
        urlLayout.horizontalSpacing = 0;
        urlLayout.verticalSpacing = 0;
        urlComposite.setLayout((Layout)urlLayout);
        this.textURL = new Text(urlComposite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textURL.setLayoutData((Object)layoutData);
        Label urlExampleLabel = new Label(urlComposite, 0);
        urlExampleLabel.setText("   " + Messages.getString("ConfigurationPage.URL.Example"));
        layoutData = new GridData(4, 1, true, false);
        urlExampleLabel.setLayoutData((Object)layoutData);
        FontData[] fontDataArray = urlExampleFont = urlExampleLabel.getFont().getFontData();
        int n = urlExampleFont.length;
        int n2 = 0;
        while (n2 < n) {
            FontData urlExampleFontData = fontDataArray[n2];
            urlExampleFontData.setHeight((int)((float)urlExampleFontData.getHeight() * 0.85f));
            ++n2;
        }
        urlExampleLabel.setFont(new Font(urlExampleLabel.getFont().getDevice(), urlExampleFont));
        Label projectLabel = new Label(composite, 0);
        projectLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.Project.Label")) + ":");
        this.textProject = new Text(composite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textProject.setLayoutData((Object)layoutData);
        Label componentLabel = new Label(composite, 0);
        componentLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.Component.Label")) + ":");
        this.textComponent = new Text(composite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textComponent.setLayoutData((Object)layoutData);
        Label issueTypeLabel = new Label(composite, 0);
        issueTypeLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.IssueType.Label")) + ":");
        this.textIssueTypeName = new Text(composite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textIssueTypeName.setLayoutData((Object)layoutData);
        Label arcwayIdFieldIdLabel = new Label(composite, 0);
        arcwayIdFieldIdLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.ArcwayIdFieldId.Label")) + ":");
        this.textArcwayIdFieldId = new Text(composite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textArcwayIdFieldId.setLayoutData((Object)layoutData);
        Label arcwayURLFieldIdLabel = new Label(composite, 0);
        arcwayURLFieldIdLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.ArcwayURLFieldId.Label")) + ":");
        this.textArcwayURLFieldId = new Text(composite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textArcwayURLFieldId.setLayoutData((Object)layoutData);
        Label arcwayURLPrefixLabel = new Label(composite, 0);
        arcwayURLPrefixLabel.setText(String.valueOf(Messages.getString("ConfigurationPage.ArcwayURLPrefix.Label")) + ":");
        this.textArcwayURLPrefix = new Text(composite, 2052);
        layoutData = new GridData(4, 2, true, false);
        this.textArcwayURLPrefix.setLayoutData((Object)layoutData);
        this.initialiseQCIndependantConfigurationWidgets();
        this.areWidgetsCreated = true;
    }

    private void initialiseQCIndependantConfigurationWidgets() {
        this.textURL.setText(this.configuration.getURL());
        this.textProject.setText(this.configuration.getProject());
        this.textComponent.setText(this.configuration.getComponent());
        this.textIssueTypeName.setText(this.configuration.getIssueTypeName());
        this.textArcwayIdFieldId.setText(this.configuration.getQCFieldIDForCockpitTechnicalID());
        this.textArcwayURLFieldId.setText(this.configuration.getURLFieldID());
        this.textArcwayURLPrefix.setText(this.configuration.getURLPrefix());
    }

    @Override
    protected void createQCSpecificConfigurationUI_Initial(Composite composite) {
    }

    @Override
    protected void createQCSpecificConfigurationUI_AfterConnection(Composite composite) {
        this.metaAttributesComposite = AbstractConfigurationPage.createPartComposite(composite);
        this.createMetaAttributeHandlingConfigurationWidgets();
        this.technicalIDFieldComposite = AbstractConfigurationPage.createPartComposite(composite);
        AbstractConfigurationPage.createLabel(this.technicalIDFieldComposite, String.valueOf(Messages.getString("ConfigurationPage.TechnicalIDField.Label")) + ":", 1, true, true);
        this.technicalIDFieldCombo = new Combo(this.technicalIDFieldComposite, 12);
        GridData technicalIDFieldComboLayoutData = new GridData(4, 2, true, false);
        this.technicalIDFieldCombo.setLayoutData((Object)technicalIDFieldComboLayoutData);
        this.technicalIDFieldCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationPage.this.updatePageProblemState(true);
                MappingConfigurationPage[] mappingConfigurationPageArray = GeneralConfigurationPage.this.mappingPages;
                int n = mappingConfigurationPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MappingConfigurationPage mappingPage = mappingConfigurationPageArray[n2];
                    mappingPage.updatePageProblemState(true);
                    ++n2;
                }
            }
        });
        this.initialiseQCSpecificConfigurationWidgets();
        this.isInConnectedState = true;
    }

    private void createMetaAttributeHandlingConfigurationWidgets() {
        AbstractConfigurationPage.createLabel(this.metaAttributesComposite, String.valueOf(Messages.getString("ConfigurationPage.MetaAttributes.Label")) + ":", 1, true, true);
        Composite metaAttributesRadioComposite1 = new Composite(this.metaAttributesComposite, 0);
        GridData gridData = new GridData(4, 2, true, false);
        metaAttributesRadioComposite1.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        metaAttributesRadioComposite1.setLayout((Layout)layout);
        this.qcMetaDataButton = new Button(metaAttributesRadioComposite1, 16);
        this.qcMetaDataButton.setText(Messages.getString("ConfigurationPage.MetaAttributes.QC"));
        gridData = new GridData(4, 2, true, false);
        this.qcMetaDataButton.setLayoutData((Object)gridData);
        this.cockpitMetaDataButton = new Button(metaAttributesRadioComposite1, 16);
        this.cockpitMetaDataButton.setText(Messages.getString("ConfigurationPage.MetaAttributes.Cockpit"));
        gridData = new GridData(4, 2, true, false);
        this.cockpitMetaDataButton.setLayoutData((Object)gridData);
        Composite metaAttributesRadioCadioComposite2 = new Composite(this.metaAttributesComposite, 0);
        gridData = new GridData(4, 2, true, false);
        metaAttributesRadioCadioComposite2.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        metaAttributesRadioCadioComposite2.setLayout((Layout)layout);
        this.cockpitModificationTimeButton = new Button(metaAttributesRadioCadioComposite2, 16);
        this.cockpitModificationTimeButton.setText(Messages.getString("ConfigurationPage.MetaAttributes.Cockpit.ModificationTime"));
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalIndent = 30;
        this.cockpitModificationTimeButton.setLayoutData((Object)gridData);
        this.cockpitCreationTimeButton = new Button(metaAttributesRadioCadioComposite2, 16);
        this.cockpitCreationTimeButton.setText(Messages.getString("ConfigurationPage.MetaAttributes.Cockpit.CreationTime"));
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalIndent = 30;
        this.cockpitCreationTimeButton.setLayoutData((Object)gridData);
        Composite userMappingComposite = new Composite(this.metaAttributesComposite, 0);
        gridData = new GridData(1, 2, false, false);
        gridData.horizontalIndent = 30;
        userMappingComposite.setLayoutData((Object)gridData);
        GridLayout userMappingLayout = new GridLayout(3, false);
        userMappingLayout.marginWidth = 0;
        userMappingLayout.marginHeight = 0;
        userMappingComposite.setLayout((Layout)userMappingLayout);
        this.userMappingCheckBox = new Button(userMappingComposite, 32);
        this.userMappingCheckBox.setText(Messages.getString("ConfigurationPage.MetaAttributes.Cockpit.UseUserMapping"));
        Label dummy = new Label(userMappingComposite, 0);
        dummy.setText("   ");
        this.userMappingButton = new Button(userMappingComposite, 8);
        this.userMappingButton.setText(Messages.getString("ConfigurationPage.MetaAttributes.Cockpit.UserMapping"));
        this.qcMetaDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationPage.this.setMetaAttributesFromCockpitConfigurationEnabledState(false);
                GeneralConfigurationPage.this.updatePageProblemState(true);
            }
        });
        this.cockpitMetaDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationPage.this.setMetaAttributesFromCockpitConfigurationEnabledState(true);
                GeneralConfigurationPage.this.updatePageProblemState(true);
            }
        });
        this.userMappingCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationPage.this.setMetaAttributesFromCockpitConfigurationEnabledState(GeneralConfigurationPage.this.cockpitMetaDataButton.getSelection());
                GeneralConfigurationPage.this.updatePageProblemState(true);
            }
        });
        this.userMappingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationPage.this.mapAuthors();
                GeneralConfigurationPage.this.updatePageProblemState(true);
            }
        });
    }

    private void initialiseQCSpecificConfigurationWidgets() {
        this.technicalIDFieldAttributeCandidates = new ArrayList<IField>();
        int initialSelectionIndex = -1;
        for (IField requirementField : this.qcConnectionAdmin.getConnection().getAllRequirementFields()) {
            if (requirementField.getDataType() != 3 || !requirementField.isActive() || !requirementField.isEditable()) continue;
            this.technicalIDFieldAttributeCandidates.add(requirementField);
            this.technicalIDFieldCombo.add(requirementField.getName());
            if (this.configuration.getQCFieldIDForCockpitTechnicalID() == null || !requirementField.getID().equals(this.configuration.getQCFieldIDForCockpitTechnicalID())) continue;
            initialSelectionIndex = this.technicalIDFieldAttributeCandidates.size() - 1;
        }
        if (initialSelectionIndex >= 0) {
            this.technicalIDFieldCombo.select(initialSelectionIndex);
        }
        if (this.configuration.isUsingCockpitMetaData()) {
            this.cockpitMetaDataButton.setSelection(true);
        } else {
            this.qcMetaDataButton.setSelection(true);
        }
        if (this.configuration.isUsingCockpitModificationMetaData()) {
            this.cockpitModificationTimeButton.setSelection(true);
        } else {
            this.cockpitCreationTimeButton.setSelection(true);
        }
        this.userMappingCheckBox.setSelection(this.configuration.isUsingAuthorMapping());
        this.setMetaAttributesFromCockpitConfigurationEnabledState(this.configuration.isUsingCockpitMetaData());
        this.sourceAttributeForAuthorMapping = AttributeMappingConfigurationHelper.getSourceAttributeDescriptionForAuthorMapping(this.projectAgent, this.relevantObjectTypes);
        this.targetAttributeForAuthorMapping = AttributeMappingConfigurationHelper.getTargetAttributeDescriptionForAuthorMapping(this.qcConnectionAdmin.getConnection());
        this.authorMappingMemento = this.configuration.getAuthorMapping();
        this.authorMapping = AttributeMappingWidget.loadEnumValueMapping((IArcwayMemento)this.authorMappingMemento, this.sourceAttributeForAuthorMapping, this.targetAttributeForAuthorMapping, AttributeMappingConfigurationHelper.getSettingsForAuthorMapping(), AttributeMappingConfigurationHelper.getPersistencyHelperForAuthorMapping());
    }

    private void mapAuthors() {
        IAttributeMappingWidgetSettings_forEnumValueMapping<String, String> settingsForAuthorMapping = AttributeMappingConfigurationHelper.getSettingsForAuthorMapping();
        EnumValueMappingDialogue userMappingDialogue = new EnumValueMappingDialogue(this.sourceAttributeForAuthorMapping, this.targetAttributeForAuthorMapping, this.authorMapping, settingsForAuthorMapping, null, this.metaAttributesComposite.getShell());
        if (userMappingDialogue.open() == 0) {
            this.authorMapping = userMappingDialogue.getEnumValueMapping();
            this.updatePageProblemState(true);
        }
    }

    private void setMetaAttributesFromCockpitConfigurationEnabledState(boolean enabled) {
        this.cockpitModificationTimeButton.setEnabled(enabled);
        this.cockpitCreationTimeButton.setEnabled(enabled);
        this.userMappingCheckBox.setEnabled(enabled);
        this.userMappingButton.setEnabled(enabled && this.userMappingCheckBox.getSelection());
    }

    @Override
    protected void disposeQCSpecificConfigurationUI(Composite composite) {
        this.isInConnectedState = false;
        this.metaAttributesComposite.dispose();
        this.authorMapping = null;
        this.technicalIDFieldComposite.dispose();
        this.technicalIDFieldAttributeCandidates = null;
    }

    @Override
    protected void updatePageProblemState(boolean isConnected) {
        Tuple<String, String> problemAndWarningMessages = new Tuple<String, String>(null, null);
        if (this.areWidgetsCreated && isConnected) {
            IField technicalIDField = this.getCurrentlySelectedCockpitTechnicalIDField();
            boolean isUsingCockpitMetaData = this.cockpitMetaDataButton.getSelection();
            ArrayList<Tuple<IRequirementType, JiraConfigurationChecker.ITechnicalIDFieldAgainstAttributeMappingChecker>> mappingConfigurations = new ArrayList<Tuple<IRequirementType, JiraConfigurationChecker.ITechnicalIDFieldAgainstAttributeMappingChecker>>();
            MappingConfigurationPage[] mappingConfigurationPageArray = this.mappingPages;
            int n = this.mappingPages.length;
            int n2 = 0;
            while (n2 < n) {
                MappingConfigurationPage mappingPage = mappingConfigurationPageArray[n2];
                Tuple<IRequirementType, JiraConfigurationChecker.ITechnicalIDFieldAgainstAttributeMappingChecker> currentSettings = mappingPage.getCurrentSettings();
                if (currentSettings != null) {
                    mappingConfigurations.add(currentSettings);
                }
                ++n2;
            }
            boolean isUsingAuthorMapping = this.userMappingButton.getSelection();
            problemAndWarningMessages = JiraConfigurationChecker.checkGeneralConfiguration(technicalIDField, isUsingCockpitMetaData, isUsingAuthorMapping, this.qcConnectionAdmin.getConnection(), this.sourceAttributeForAuthorMapping, this.authorMapping, mappingConfigurations);
        }
        this.setPageProblemState((String)problemAndWarningMessages.getT1(), (String)problemAndWarningMessages.getT2());
    }

    public IField getCurrentlySelectedCockpitTechnicalIDField() {
        if (this.isInConnectedState) {
            if (this.areWidgetsCreated) {
                if (this.technicalIDFieldCombo.getSelectionIndex() >= 0) {
                    return this.technicalIDFieldAttributeCandidates.get(this.technicalIDFieldCombo.getSelectionIndex());
                }
                return null;
            }
            if (this.configuration.getQCFieldIDForCockpitTechnicalID() != null && this.configuration.getQCFieldIDForCockpitTechnicalID().trim().length() > 0) {
                return this.qcConnectionAdmin.getConnection().getRequirementField(this.configuration.getQCFieldIDForCockpitTechnicalID());
            }
            return null;
        }
        return null;
    }

    public boolean hasChanges() {
        this.updateConfiguration();
        return !this.oldConfigurationString.equals(Configuration.getConfigurationString(this.configuration));
    }

    public Collection<IModificationProblem> getModificationProblems() {
        return Collections.emptySet();
    }

    public Collection<? extends IModificationProblem> requestCommit() {
        try {
            this.locks = this.projectAgent.getConfigurationManager().getLockForConfigurationValue("qualitycenteradapter");
            return Collections.emptySet();
        }
        catch (EXLockDenied eLD) {
            MessageSet messageSet = new MessageSet();
            messageSet.add((RepositoryAccessException)eLD);
            return RepositoryAccessModificationProblem.convertIntoModificationProblems((IRepositoryTypeManagerRO)this.projectAgent.getRepositoryInterface().getTypeManager(), (IMessageSet)messageSet, (PresentationContext)PresentationContext.getVirtualMachineUserLocaleForNow(), (String)Messages.getString("ConfigurationPage.LockDenied.Consequence"));
        }
    }

    public void commitPropertyChanges1() {
        block6: {
            try {
                this.updateConfiguration();
                this.projectAgent.getConfigurationManager().setConfigurationValue("qualitycenteradapter", Configuration.getConfigurationString(this.configuration));
                this.releaseLock();
            }
            catch (EXPermissionDenied ePD) {
                logger.warn("Quality center configuration could not be saved due to a missing permission.", (Throwable)ePD);
                assert (false);
            }
            catch (EXLockDenied eLD) {
                logger.warn("Quality center configuration could not be saved due to a missing lock.", (Throwable)eLD);
                assert (false);
            }
            catch (EXTransactionExecution eTE) {
                logger.warn("Quality center configuration could not be saved due to a problem during transaction execution.", (Throwable)eTE);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void rollbackCommitRequest() {
        this.releaseLock();
    }

    public Collection<? extends IModificationProblem> requestCommit_onChild() {
        if (!this.areWidgetsCreated && !this.hasHandledCommitRequestForChild) {
            this.hasCommittedForChild = false;
            this.hasDiscardedCommitForChild = false;
            this.hasHandledCommitRequestForChild = true;
            return this.requestCommit();
        }
        return Collections.emptySet();
    }

    public void commitPropertyChanges_onChild() {
        if (!this.areWidgetsCreated && !this.hasCommittedForChild) {
            this.hasHandledCommitRequestForChild = false;
            this.hasCommittedForChild = true;
            this.commitPropertyChanges1();
        }
    }

    public void rollbackCommitRequest_onChild() {
        if (!this.areWidgetsCreated && !this.hasDiscardedCommitForChild) {
            this.hasHandledCommitRequestForChild = false;
            this.hasDiscardedCommitForChild = true;
            this.rollbackCommitRequest();
        }
    }

    public void cancelPropertyChanges1() {
    }

    private void releaseLock() {
        if (this.locks != null) {
            for (ILockDeprecated iLockDeprecated : this.locks) {
                iLockDeprecated.release();
            }
            this.locks = null;
        }
    }

    private void updateConfiguration() {
        if (this.areWidgetsCreated) {
            this.configuration.setURL(this.textURL.getText());
            this.configuration.setProject(this.textProject.getText());
            this.configuration.setComponent(this.textComponent.getText());
            this.configuration.setIssueTypeName(this.textIssueTypeName.getText());
            this.configuration.setQCFieldIDForCockpitTechnicalID(this.textArcwayIdFieldId.getText());
            this.configuration.setURLFieldID(this.textArcwayURLFieldId.getText());
            this.configuration.setURLPrefix(this.textArcwayURLPrefix.getText());
            if (this.isInConnectedState) {
                this.configuration.setIsUsingCockpitMetaData(this.cockpitMetaDataButton.getSelection());
                this.configuration.setIsUsingCockpitModificationTime(this.cockpitModificationTimeButton.getSelection());
                this.configuration.setIsUsingAuthorMapping(this.userMappingCheckBox.getSelection());
                AttributeMappingWidget.storeEnumValueMappingIntoMemento(this.authorMapping, (IArcwayMemento)this.authorMappingMemento, AttributeMappingConfigurationHelper.getPersistencyHelperForAuthorMapping());
                if (this.technicalIDFieldCombo.getSelectionIndex() >= 0) {
                    IField technicalIDField = this.technicalIDFieldAttributeCandidates.get(this.technicalIDFieldCombo.getSelectionIndex());
                    this.configuration.setQCFieldIDForCockpitTechnicalID(technicalIDField.getID());
                }
            }
        }
        MappingConfigurationPage[] mappingConfigurationPageArray = this.mappingPages;
        int n = this.mappingPages.length;
        int n2 = 0;
        while (n2 < n) {
            MappingConfigurationPage mappingPage = mappingConfigurationPageArray[n2];
            mappingPage.updateConfiguration();
            ++n2;
        }
    }

    public ThreeTuple<String, String, String> getCurrentURLDomainAndProject() {
        if (this.areWidgetsCreated) {
            return new ThreeTuple((Object)this.textURL.getText(), (Object)"", (Object)this.textProject.getText());
        }
        return new ThreeTuple((Object)this.configuration.getURL(), (Object)"", (Object)this.configuration.getProject());
    }

    private void readConfiguration() {
        this.oldConfigurationString = this.projectAgent.getConfigurationManager().getConfigurationValue("qualitycenteradapter");
        this.configuration = Configuration.getConfiguration(this.oldConfigurationString);
        if (this.oldConfigurationString == null) {
            this.oldConfigurationString = Configuration.getConfigurationString(this.configuration);
        }
    }

    public void disposeResources() {
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
        if (this.qcConnectionAdmin.isConnected()) {
            this.qcConnectionAdmin.disconnect();
        }
    }
}

