/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.configuration.ui;

import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.QCConnectionAdmin;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.ui.IModificationProblem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractConfigurationPage
implements IPropertiesListEntry {
    private QCConnectionAdmin qcConnectionAdmin;
    private final boolean hasQCIndependantPart;
    private IPropertiesDialog dialogue = null;
    private String dialogueMessage;
    private boolean areWidgetsCreated;
    private Composite baseComposite;
    private Composite qcIndependantConfigurationComposite;
    private Composite stackComposite;
    private StackLayout qcSpecificConfigurationStackLayout;
    private Composite loginComposite;
    private Composite qcSpecificConfigurationComposite;
    private boolean showLoginComposite = false;

    public AbstractConfigurationPage(boolean hasQCIndependantPart_) {
        this.hasQCIndependantPart = hasQCIndependantPart_;
    }

    public final boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        return elements.length == 1 && elements[0] instanceof IFrameProjectAgent;
    }

    public final int getTypeOfPage() {
        return 60;
    }

    public final IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    public final IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return null;
    }

    public final void setDialog(IPropertiesDialog dialogue_) {
        this.dialogue = dialogue_;
    }

    public final IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog dialogue_, boolean forCreation) {
        this.dialogue = dialogue_;
        this.qcConnectionAdmin = this.init(elements);
        this.areWidgetsCreated = false;
        return null;
    }

    protected abstract QCConnectionAdmin init(ICockpitProjectData[] var1);

    public Composite getPropertyPage(Composite parent) {
        GridData gridData;
        this.dialogue.setTitle(this.getDialogueTitle(), (IPropertiesListEntry)this);
        this.dialogueMessage = this.getDialogueMessage();
        this.baseComposite = new Composite(parent, 0);
        GridData baseData = new GridData(4, 4, true, true);
        this.baseComposite.setLayoutData((Object)baseData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        layout.verticalSpacing = 15;
        this.baseComposite.setLayout((Layout)layout);
        if (this.hasQCIndependantPart) {
            this.qcIndependantConfigurationComposite = new Composite(this.baseComposite, 0);
            gridData = new GridData(4, 4, true, false);
            this.qcIndependantConfigurationComposite.setLayoutData((Object)gridData);
            this.qcIndependantConfigurationComposite.setLayout((Layout)this.getConfigurationLayout());
            this.createQCIndependantConfigurationUI(this.qcIndependantConfigurationComposite);
            LineSeparator line = new LineSeparator(this.baseComposite, 0);
            line.setBackground(parent.getDisplay().getSystemColor(21));
            line.setLayoutData((Object)new GridData(4, 2, true, false));
        }
        this.stackComposite = new Composite(this.baseComposite, 0);
        gridData = new GridData(4, 4, true, true);
        this.stackComposite.setLayoutData((Object)gridData);
        this.qcSpecificConfigurationStackLayout = new StackLayout();
        this.qcSpecificConfigurationStackLayout.marginHeight = 8;
        this.stackComposite.setLayout((Layout)this.qcSpecificConfigurationStackLayout);
        if (this.showLoginComposite) {
            this.loginComposite = AbstractConfigurationPage.createLoginComposite(this.stackComposite, this.qcConnectionAdmin, this.getLoginHintMessage());
        }
        this.qcSpecificConfigurationComposite = new Composite(this.stackComposite, 0);
        this.qcSpecificConfigurationComposite.setLayout((Layout)this.getConfigurationLayout());
        this.createQCSpecificConfigurationUI_Initial(this.qcSpecificConfigurationComposite);
        if (this.qcConnectionAdmin.isConnected()) {
            this.createQCSpecificConfigurationUI_AfterConnection(this.qcSpecificConfigurationComposite);
        }
        this.areWidgetsCreated = true;
        this.updatePageState();
        return this.baseComposite;
    }

    private GridLayout getConfigurationLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 15;
        layout.marginWidth = 0;
        layout.verticalSpacing = 20;
        return layout;
    }

    protected abstract String getDialogueTitle();

    protected abstract String getDialogueMessage();

    protected abstract String getLoginHintMessage();

    protected abstract void createQCIndependantConfigurationUI(Composite var1);

    protected abstract void createQCSpecificConfigurationUI_Initial(Composite var1);

    protected abstract void createQCSpecificConfigurationUI_AfterConnection(Composite var1);

    protected abstract void disposeQCSpecificConfigurationUI(Composite var1);

    public void informAboutSuccessfulQCLogin() {
        if (this.areWidgetsCreated) {
            this.createQCSpecificConfigurationUI_AfterConnection(this.qcSpecificConfigurationComposite);
        }
        this.updatePageState();
    }

    public void informAboutQCLogoff() {
        if (this.areWidgetsCreated) {
            this.disposeQCSpecificConfigurationUI(this.qcIndependantConfigurationComposite);
        }
        this.updatePageState();
    }

    private void updatePageState() {
        if (!this.areWidgetsCreated) {
            return;
        }
        boolean redrawNeeded = false;
        if (this.qcConnectionAdmin.isConnected()) {
            if (this.qcSpecificConfigurationStackLayout.topControl != this.qcSpecificConfigurationComposite) {
                this.qcSpecificConfigurationStackLayout.topControl = this.qcSpecificConfigurationComposite;
                redrawNeeded = true;
            }
        } else if (this.qcSpecificConfigurationStackLayout.topControl != this.loginComposite) {
            this.qcSpecificConfigurationStackLayout.topControl = this.loginComposite;
            redrawNeeded = true;
        }
        this.updatePageProblemState(this.qcConnectionAdmin.isConnected());
        if (redrawNeeded) {
            this.baseComposite.layout(true, true);
            this.baseComposite.redraw();
        }
    }

    protected abstract void updatePageProblemState(boolean var1);

    protected final void setPageProblemState(String localisedProblemMessage, String localisedWarningMessage) {
        if (localisedProblemMessage == null) {
            if (localisedWarningMessage == null) {
                this.dialogue.setMessage(this.dialogueMessage, 0, (IPropertiesListEntry)this);
                this.dialogue.setIsCommitable(true, (IPropertiesListEntry)this);
            } else {
                this.dialogue.setMessage(localisedWarningMessage, 2, (IPropertiesListEntry)this);
                this.dialogue.setIsCommitable(true, (IPropertiesListEntry)this);
            }
        } else {
            this.dialogue.setMessage(localisedProblemMessage, 3, (IPropertiesListEntry)this);
            this.dialogue.setIsCommitable(false, (IPropertiesListEntry)this);
        }
    }

    public static Composite createPartComposite(Composite composite) {
        Composite partComposite = new Composite(composite, 0);
        GridData partGridData = new GridData(4, 2, true, false);
        partComposite.setLayoutData((Object)partGridData);
        GridLayout partLayout = new GridLayout();
        partLayout.marginHeight = 0;
        partLayout.marginWidth = 0;
        partComposite.setLayout((Layout)partLayout);
        return partComposite;
    }

    public static void createLabel(Composite parent, String text, int colspan, boolean wholeWidth, boolean spacing) {
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(4, 4, wholeWidth, false);
        compositeGridData.horizontalSpan = colspan;
        composite.setLayoutData((Object)compositeGridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        StyledText label = new StyledText(composite, 72);
        GridData labelGridData = new GridData(1, 1, wholeWidth, false);
        label.setLayoutData((Object)labelGridData);
        label.setText(text);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = text.length();
        styleRange.fontStyle = 1;
        label.setStyleRange(styleRange);
        label.setBackground(parent.getDisplay().getSystemColor(22));
        if (spacing) {
            Label space = new Label(composite, 0);
            GridData spaceGridData = new GridData(1, 1, wholeWidth, false);
            spaceGridData.heightHint = 4;
            space.setLayoutData((Object)spaceGridData);
        }
    }

    private static Composite createLoginComposite(final Composite parent, final QCConnectionAdmin qcConnectionAdmin, String hintText) {
        Group group = new Group(parent, 0);
        GridData groupLayoutData = new GridData(4, 4, true, false);
        group.setLayoutData((Object)groupLayoutData);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.marginHeight = 5;
        groupLayout.marginWidth = 5;
        groupLayout.horizontalSpacing = 10;
        group.setLayout((Layout)groupLayout);
        group.setText(Messages.getString("MappingConfigurationPage.Login.GroupTitle"));
        Label label = new Label((Composite)group, 64);
        GridData labelLayoutData = new GridData(4, 3, true, false);
        labelLayoutData.horizontalSpan = 2;
        labelLayoutData.verticalIndent = 15;
        label.setLayoutData((Object)labelLayoutData);
        label.setText(hintText);
        Label space = new Label((Composite)group, 0);
        GridData spaceLayoutData = new GridData(4, 3, true, false);
        spaceLayoutData.horizontalSpan = 2;
        spaceLayoutData.heightHint = 10;
        space.setLayoutData((Object)spaceLayoutData);
        Label userNameLabel = new Label((Composite)group, 0);
        userNameLabel.setText(String.valueOf(Messages.getString("MappingConfigurationPage.Username.Label")) + ":");
        final Text textUserName = new Text((Composite)group, 2052);
        GridData textUserNameLayoutData = new GridData(4, 2, true, false);
        textUserName.setLayoutData((Object)textUserNameLayoutData);
        Label passwordLabel = new Label((Composite)group, 0);
        passwordLabel.setText(String.valueOf(Messages.getString("MappingConfigurationPage.Password.Label")) + ":");
        final Text textPassword = new Text((Composite)group, 0x400804);
        GridData passwordLayoutData = new GridData(4, 2, true, false);
        textPassword.setLayoutData((Object)passwordLayoutData);
        new Label((Composite)group, 0);
        Button button = new Button((Composite)group, 0);
        GridData buttonLayoutData = new GridData(3, 2, false, false);
        button.setLayoutData((Object)buttonLayoutData);
        button.setText(Messages.getString("MappingConfigurationPage.LoginButton.Label"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                qcConnectionAdmin.connect(textUserName.getText(), textPassword.getText(), parent.getShell());
            }
        });
        return group;
    }

    public boolean isShowLoginComposite() {
        return this.showLoginComposite;
    }

    public void setShowLoginComposite(boolean showLoginComposite) {
        this.showLoginComposite = showLoginComposite;
    }
}

