if (typeof cockpit === "object" && typeof cockpit.schema === "undefined") {
	
	( function () {
	
		/**
		 * create_ReportPropertyID_RepositoryPropertyTypeID_Map
		 * 
		 * @param map_ReportPropertyID_RepositoryPropertyTypeID the 
		 */
		function create_ReportPropertyID_RepositoryPropertyTypeID_Map(objectType) {
	
			var map_ReportPropertyID_RepositoryPropertyTypeID = new Object();
		
			objectType.propertytypesample.forEach( function(propertyType) {
				var userID = propertyType.userid;
				
				var repositoryPropertyTypeIDString = propertyType.propertytypeid;
				if ( userID !== null ) {
					map_ReportPropertyID_RepositoryPropertyTypeID[userID] = repositoryPropertyTypeIDString;
				} else {
					var lastDotIndex = repositoryPropertyTypeIDString.lastIndexOf('.');
					// FIXME replace/rethink the naming scheme below - which is a hack
					var hack = repositoryPropertyTypeIDString.substring(lastDotIndex+1);
					if( map_ReportPropertyID_RepositoryPropertyTypeID.hasOwnProperty(hack) ) {
						map_ReportPropertyID_RepositoryPropertyTypeID[hack] = "";
					} else {
						map_ReportPropertyID_RepositoryPropertyTypeID[hack] = repositoryPropertyTypeIDString;
					}
				}
						
			} );
			
			return map_ReportPropertyID_RepositoryPropertyTypeID;
		}
		
		
		/**
		 * translateRepositoryObjectTypeID2ReportObjectTypeID
		 * 
		 * @param repositoryObjectTypeID the 
		 */
		function translateRepositoryObjectTypeID2ReportObjectTypeID(repositoryObjectTypeID) {
		
			if( 	   repositoryObjectTypeID === "com.arcway.cockpit.object.data") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.moduleData") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.report_template") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.object.data.reporttemplatecontainer") ) { 
				assert( (	repositoryObjectTypeID === "com.arcway.cockpit.object.data.reporttemplatecontainer" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.object.data.reporttemplatecontainer.Folder"
						||	repositoryObjectTypeID === "com.arcway.cockpit.object.data.reporttemplatecontainer.reportoutputtemplate" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.object.data.reporttemplatecontainer.rootFolder" ),
						function() {return "Missed to define a mapping for repositoryObjectTypeID " + repositoryObjectTypeID + " ?"; } );  
						// no mapping
						return null;
			} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.snapshot") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.workspace") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID === "com.arcway.repository.object.base") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID === "com.arcway.repository.object.snapshot") { 
				// no mapping
				return null;
			} else if( repositoryObjectTypeID === "com.arcway.repository.object.workspace") { 
				// no mapping
				return null;
			}
			
			///////////////////////////////////////////////////////////////////////
			  else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.project") { 
				return [ "project" ]; 
			} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.section") { 
				return [ "folder" ]; 
			} else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.object.data.plan")) { 
				if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.plan") { 
					return [ "plan" ]; 
				} else {
					return null;
				}
			} else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.object.data.modelelement")) { 
				if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.modelelement")  { 
					return [ "uniqueElement", "modelElement" ];  
				} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.modelelement.bpre-information") { 
					return [ "uniqueElement.bpre-information", "modelElement.bpre-information" ];  
				} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.modelelement.bpre-state") { 
					return [ "uniqueElement.bpre-state", "modelElement.bpre-state" ];  
				} else if( repositoryObjectTypeID === "com.arcway.cockpit.object.data.modelelement.bpre-function") { 
					return [ "uniqueElement.bpre-function", "modelElement.bpre-function" ];  
				} else {
					return null;
				}
			} else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.object.data.stakeholder")) { 
				return [ "stakeholder" ]; 
			} else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.object.data.stakeholderrole")) { 
				return [ "stakeholderRole" ]; 
			}
	
			   //////////////////// =v= use case module //////////////////////////////
			   else if( repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.category") { 
				return [ "ucm.useCaseSet" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.useCase") { 
				return [ "ucm.useCase" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.Scenario") { 
				return [ "ucm.scenario" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.ActionStep") { 
				return [ "ucm.actionStep" ]; 
			}  else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.module.usecasemodule.object.data.moduleData")) { 
				assert(	(	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.Actor" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.Extension" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.Goal" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.ucm_subset_actionstep_realstep" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.ucm_subset_actionstep_virtualbeginningstep" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.ucm_subset_actionstep_virtualfinalstep" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.ucm_subset_scenario_extensionscenario"
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.usecasemodule.object.data.moduleData.ucm_subset_scenario_mainscenario" ),
						function() {return "Missed to define a mapping for repositoryObjectTypeID " + repositoryObjectTypeID + " ?";} );
				return null;
			} else
	
				//////////////////// =v= document module //////////////////////////////
			    if( repositoryObjectTypeID === "com.arcway.cockpit.module.DCM.object.data.moduleData.category") { 
				return [ "dcm.documentContainerSet" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.DCM.object.data.moduleData.documentcontainer") { 
				return [ "dcm.documentContainer" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.DCM.object.data.moduleData.abstract_natural_order_super_type_for_dcm_ResourceLocator") { 
				return [ "dcm.resourceLocator" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.DCM.object.data.moduleData.weblink") { 
				return [ "dcm.webLink" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.DCM.object.data.moduleData.filesystemlink") { 
				return [ "dcm.fileSystemLink" ]; 
			}  else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.module.DCM.object.data.moduleData")) { 
				assert(	false, "Missed to define a mapping for repositoryObjectTypeID " + repositoryObjectTypeID + " ?" );  
				return null; 
			}
			
			//////////////////// =v= project planning module //////////////////////
			   else if( repositoryObjectTypeID === "com.arcway.cockpit.module.projectplanningmodule2.object.data.moduleData.projectplan") { 
				return [ "ppm.projectPlan" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.projectplanningmodule2.object.data.moduleData.task") { 
				return [ "ppm.task" ]; 
			}  else if( repositoryObjectTypeID === "com.arcway.cockpit.module.projectplanningmodule2.object.data.moduleData.workitem") { 
				return [ "ppm.workItem" ]; 
			}  else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.module.projectplanningmodule2.object.data.moduleData")) { 
				assert(	(	repositoryObjectTypeID === "com.arcway.cockpit.module.projectplanningmodule2.object.data.moduleData.sourceFile" 
						||	repositoryObjectTypeID === "com.arcway.cockpit.module.projectplanningmodule2.object.data.moduleData.workitemcategory"), 
						function() {return "Missed to define a mapping for repositoryObjectTypeID " + repositoryObjectTypeID + " ?"; } );
				return null;
			}
	
			   // Item type constant: "gm." + [module id] + "." + [object type id] (module id and object type id are taken from the generic module specification)
			   else if( repositoryObjectTypeID.startsWith("com.arcway.cockpit.module.genericmodule-")) { 
				var moduleIDAndObjectID = repositoryObjectTypeID.substring( "com.arcway.cockpit.module.genericmodule-".length ).split( "." );  
				if(moduleIDAndObjectID.length === 5) {
					var reportObjectTypeID = "gm." + moduleIDAndObjectID[0] + "." + moduleIDAndObjectID[4];  
					return [ reportObjectTypeID ];
				} else {
					assert(	false, "Missed to define a mapping for repositoryObjectTypeID " + repositoryObjectTypeID + " ?");  
					return null;
				}
			}
			   
				//////////////////// =v= should never get here //////////////////////////////
			   else {
				assert(	false, "Missed to define a mapping for repositoryObjectTypeID " + repositoryObjectTypeID + " ?");  
				return null;
			}
		}
		
		{
			cockpit.schema = new Object();
			cockpit.schema.objecttypes = new Object();
		
			var repositorySchemaSample = JSON.parse(cockpit.repositorySchemaSampleJSONString);
			repositorySchemaSample.objecttypesample.forEach( function(objectType) {
				
				var map_ReportPropertyID_RepositoryPropertyTypeID = create_ReportPropertyID_RepositoryPropertyTypeID_Map(objectType);
		
				var repositoryObjectTypeIDString = objectType.objecttypeid;
				
				map_ReportPropertyID_RepositoryPropertyTypeID["objectTypeID"] = repositoryObjectTypeIDString;
				
				var reportObjectTypeIDs = translateRepositoryObjectTypeID2ReportObjectTypeID(repositoryObjectTypeIDString);
				if ( reportObjectTypeIDs != null ) {
					reportObjectTypeIDs.forEach( function(reportObjectTypeID) {
						cockpit.schema.objecttypes[reportObjectTypeID] = map_ReportPropertyID_RepositoryPropertyTypeID;
					} );
				}
				
			});
			repositorySchemaSample = null; // ??? bringts was?
		}
		
	} ) ();

}