/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.scripting.ui.handlers;

import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptInterpreter;
import com.arcway.cockpit.scripting.ui.messages.Messages;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.FileSelectionPage;
import com.arcway.lib.java.ObjectWrapper;
import java.io.File;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;

public class CockpitScriptExecutionWizard {
    public static void executeCockpitScript(ExecutionEvent event) throws ExecutionException {
        IWorkbenchSite activeSite = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event);
        Shell shell = activeSite.getShell();
        ScriptCommandContext uiContext = new ScriptCommandContext(null, activeSite.getPage(), null);
        File cockpitScriptFile = CockpitScriptExecutionWizard.getCockpitScriptFileName(shell);
        if (cockpitScriptFile != null) {
            ScriptInterpreter scriptInterpreter = ScriptInterpreter.createScriptInterpreter((File)cockpitScriptFile, null, (ScriptCommandContext)uiContext);
            try {
                scriptInterpreter.executeScript(true);
                MessageDialog.openInformation((Shell)shell, (String)"Successfully executed script!", (String)("Successfully executed script file: " + cockpitScriptFile.toString()));
            }
            catch (ScriptExecutionException e) {
                MessageDialog.openError((Shell)shell, (String)"Script execution failed!", (String)("Script execution failed with error message: " + e.getLocalizedMessage() + " (script file: " + cockpitScriptFile.toString() + ")"));
            }
        }
    }

    public static File getCockpitScriptFileName(Shell shell) {
        final ObjectWrapper fileName = new ObjectWrapper(null);
        final FileSelectionPage fileSelectionPage = new FileSelectionPage(Messages.getString("CockpitScriptExecutionWizard.ScriptFileSelectionPage.Title"), Messages.getString("CockpitScriptExecutionWizard.ScriptFileSelectionPage.Instruction"), Collections.singletonList("xml"), true, false, true);
        Wizard wizard = new Wizard(){

            public void addPages() {
                super.addPages();
                this.setWindowTitle(Messages.getString("CockpitScriptExecutionWizard.ScriptFileSelectionPage.Title"));
                this.addPage((IWizardPage)fileSelectionPage);
            }

            public boolean performFinish() {
                fileName.setWrappedObject((Object)fileSelectionPage.getFileName());
                return true;
            }
        };
        ArcwayWizardDialog wizardDialogue = new ArcwayWizardDialog(shell, (IWizard)wizard);
        wizardDialogue.setPageSize(400, 400);
        int dialogueConfirmed = wizardDialogue.open();
        if (dialogueConfirmed == 0) {
            return new File((String)fileName.getWrappedObject());
        }
        return null;
    }
}

