/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.reqifadapter;

import com.arcway.cockpit.docgen.ExtensionMgr;
import com.arcway.cockpit.docgen.consoleui.util.DummyReportTemplate;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.graphicsandfiles.IRawReportFormatSnippetProviderForFiles;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.IAbstractReportProvider;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationItem;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.reqifadapter.ImportJobFactory;
import com.arcway.cockpit.reqifadapter.UUIDGenerator;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.json.JSONCoDecForData;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.importexport.schema.DTRepositorySchemaSample;
import com.arcway.repository.interFace.importexport.schema.RepositorySchemaSample;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IWorkbenchPage;

public class ScriptContextHelper {
    private ScriptContextHelper() {
    }

    public static HashMap<String, Object> getShemaProviderContextObjects(IRepositoryInterfaceRO repositoryInterface) {
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        RepositorySchemaSample repositorySchemaSample = new RepositorySchemaSample(typeManager, true);
        String repositorySchemaSampleJSONString = JSONCoDecForData.encodeIntoJSONString((IDataType)DTRepositorySchemaSample.getInstance((IRepositoryTypeManagerRO)typeManager), repositorySchemaSample);
        contextObjects.put("repositorySchemaSampleJSONString", repositorySchemaSampleJSONString);
        return contextObjects;
    }

    public static HashMap<String, Object> getImportInterfaceContextObjects(IRepositoryInterfaceRO repositoryInterface, ScriptCommandContext uiContext) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.put("ImportJobFactory", new ImportJobFactory(repositoryInterface, uiContext));
        contextObjects.put("UUIDGenerator", new UUIDGenerator());
        return contextObjects;
    }

    public static HashMap<String, Object> getReportProviderContextObjects(IDocGeneratorProjectAgent projectAgent, Map<String, List<IFilterItemProvider>> filterItems, IWorkbenchPage currentPage) throws IOException, ReportGenerationException {
        ReportInterfaceProvider reportInterfaceProvider = new ReportInterfaceProvider(projectAgent, currentPage);
        return reportInterfaceProvider.getReportProviderContextObjects(filterItems);
    }

    public static HashMap<String, Object> getLogDirContextObjects(File logDir) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.put("logDir", logDir);
        return contextObjects;
    }

    public static HashMap<String, Object> getVarargsContextObjects(Map<String, Object> value) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, value);
        String varargsJSONString = stringWriter.toString();
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.put("varargsJSONString", varargsJSONString);
        return contextObjects;
    }

    public static class ReportInterfaceProvider {
        private static final double PREFERRED_IMAGE_RESOLUTION = 192.0;
        private static final int PREFERRED_IMAGE_SIZE = 2400;
        private final IDocGeneratorProjectAgent projectAgent;
        private final IWorkbenchPage currentPage;

        public ReportInterfaceProvider(IDocGeneratorProjectAgent projectAgent, IWorkbenchPage currentPage) {
            this.projectAgent = projectAgent;
            this.currentPage = currentPage;
        }

        public HashMap<String, Object> getReportProviderContextObjects(Map<String, List<IFilterItemProvider>> filterItems) throws IOException, ReportGenerationException {
            return this.getReportProviderContextObjects(PresentationContext.getVirtualMachineUserLocaleForNow(), new IRawReportFormatSnippetProviderForFiles(){

                public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
                    return "url=\"" + fileName + "\"";
                }
            }, PlanImageSizeHint.getSizeHintInPixel((Dimension)new Dimension(2400.0, 2400.0), (double)192.0), ".svg", filterItems, this.currentPage);
        }

        public HashMap<String, Object> getReportProviderContextObjects(PresentationContext presentationContext, IRawReportFormatSnippetProviderForFiles rawReportFormatSnippetProviderForFiles, PlanImageSizeHint imageSizeHint, String preferredImageType, Map<String, List<IFilterItemProvider>> filterItems, IWorkbenchPage currentPage) throws IOException, ReportGenerationException {
            ReportJob reportJob = new ReportJob(this.projectAgent, presentationContext);
            File dummyTemplateFile = File.createTempFile("dummy", ".rpttpl");
            dummyTemplateFile.deleteOnExit();
            DummyReportTemplate reportTemplate = new DummyReportTemplate(dummyTemplateFile.toString(), this.projectAgent.getProjectUID());
            reportJob.setReportTemplate((IReportTemplate)reportTemplate);
            String DOCBOOK_XML = "DOCBOOK_XML";
            IReportType reportType = this.projectAgent.getReportType("VelocityDOCBOOK_XML");
            reportJob.setReportType(reportType);
            reportJob.setFilterSettings(filterItems);
            Map filters = reportJob.getFilters();
            DocGenConfigurationItem docGeneratorEngineConfiguration = reportJob.getDocGeneratorEngineConfiguration();
            GraphicsAndFilesStore graphicsAndFilesStore = new GraphicsAndFilesStore();
            GraphicsAndFilesHelper graphicsProvider = new GraphicsAndFilesHelper(graphicsAndFilesStore, preferredImageType, imageSizeHint, rawReportFormatSnippetProviderForFiles, null);
            String contextKey = "parameterStore";
            DocGenConfigurationItem reportProviderConfiguration = docGeneratorEngineConfiguration.getChild(contextKey);
            if (reportProviderConfiguration == null) {
                reportProviderConfiguration = new DocGenConfigurationItem(contextKey);
                docGeneratorEngineConfiguration.addChild(reportProviderConfiguration);
            }
            HashMap reportDataProviders = new HashMap();
            reportDataProviders.putAll(ExtensionMgr.createReportRelatedReportDataProviders((Map)filters, (PresentationContext)presentationContext, (GraphicsAndFilesHelper)graphicsProvider, (boolean)false, (IWorkbenchPage)currentPage));
            reportDataProviders.putAll(ExtensionMgr.createReportTemplateRelatedReportDataProviders((DocGenConfigurationItem)reportProviderConfiguration, (Map)filters, (PresentationContext)presentationContext, (GraphicsAndFilesHelper)graphicsProvider, (IWorkbenchPage)currentPage));
            reportDataProviders.putAll(ExtensionMgr.createProjectRelatedReportDataProviders((GraphicsAndFilesHelper)graphicsProvider, (Map)filters, (PresentationContext)presentationContext, (IDocGeneratorProjectAgent)this.projectAgent, (boolean)true, (IWorkbenchPage)currentPage));
            HashMap<String, Object> contextObjects = new HashMap<String, Object>();
            for (Map.Entry entry : reportDataProviders.entrySet()) {
                String contextKey2 = (String)entry.getKey();
                IAbstractReportProvider reportProvider = (IAbstractReportProvider)entry.getValue();
                contextObjects.put(contextKey2, reportProvider);
            }
            File temporaryFileForGraphicOrFileObject = graphicsAndFilesStore.createTemporaryFileForGraphicOrFileObject("js-dummy-pefix", "extension");
            contextObjects.put("tempImageDirectory", temporaryFileForGraphicOrFileObject.getParentFile().getAbsolutePath());
            return contextObjects;
        }
    }
}

