/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.reqifadapter;

import com.arcway.cockpit.docgen.core.AbstractVelocityReportProcessor;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.ReportTemplateHeaders;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.rhino.debugger.RhinoDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;

public class JavaScriptProcessor
extends AbstractVelocityReportProcessor {
    private static final ILogger LOGGER = Logger.getLogger(JavaScriptProcessor.class);
    private static final String TEMPLATE_HEADER_TEMPLATE_ENCODING_DEFAULT_VALUE = "UTF-8";
    private static final String TEMPLATE_HEADER_TARGET_ENCODING_DEFAULT_VALUE = "UTF-8";
    private final File scriptFile;

    public JavaScriptProcessor(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void execute(HashMap<String, Object> contextObjects, String javaScriptDebugParameters) throws IOException, JvmExternalResourceInteractionException {
        if (!ContextFactory.hasExplicitGlobal()) {
            ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

                protected boolean hasFeature(Context cx, int featureIndex) {
                    switch (featureIndex) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            return true;
                        }
                    }
                    return super.hasFeature(cx, featureIndex);
                }
            });
        }
        ContextFactory contextFactory = ContextFactory.getGlobal();
        if (javaScriptDebugParameters != null && javaScriptDebugParameters.length() > 0) {
            try {
                RhinoDebugger debugger = new RhinoDebugger(javaScriptDebugParameters);
                debugger.start();
                contextFactory.addListener((ContextFactory.Listener)debugger);
            }
            catch (Exception e) {
                LOGGER.error("Unable to initialise remote debugger using parameters: " + javaScriptDebugParameters, (Throwable)e);
            }
        }
        Context cx = contextFactory.enterContext();
        cx.setOptimizationLevel(-1);
        cx.setLanguageVersion(150);
        try {
            Global global = Main.getGlobal();
            if (!global.isInitialized()) {
                global.init(cx);
            }
            Cockpit cockpit = new Cockpit();
            for (Map.Entry<String, Object> entry : contextObjects.entrySet()) {
                Object wrappedValue = Context.javaToJS((Object)entry.getValue(), (Scriptable)global);
                cockpit.defineProperty(entry.getKey(), wrappedValue, 2);
            }
            global.defineProperty("cockpit", (Object)cockpit, 2);
            File scriptFileCopy = File.createTempFile("script", ".js");
            DataCopyHelper.copyFile((File)this.scriptFile, (File)scriptFileCopy);
            scriptFileCopy.deleteOnExit();
            Map header = ReportTemplateHeaders.readASCIIHeader((File)scriptFileCopy);
            String templateEncoding = ReportTemplateHeaders.getHeaderParameter((Map)header, (String)"templateEncoding", (String)"UTF-8");
            String targetEncoding = ReportTemplateHeaders.getHeaderParameter((Map)header, (String)"targetEncoding", (String)"UTF-8");
            global.defineProperty("scriptFileParentDir", (Object)this.scriptFile.getParentFile(), 2);
            cx.setErrorReporter((ErrorReporter)new ToolErrorReporter(true));
            Main.processSource((Context)cx, (String)this.scriptFile.toString());
        }
        finally {
            Context.exit();
        }
    }

    public static class Cockpit
    extends ScriptableObject {
        public String getClassName() {
            return "Cockpit";
        }
    }
}

