/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryAttributeSetLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;

public class RepositoryAttributeSetLockSample
extends AbstractRepositoryAttributeSetLockSample {
    private final IRepositoryObjectTypeID objectTypeID;
    private final IRepositoryAttributeSetTypeID attributeSetTypeID;
    private final IRepositoryPropertySetSample objectID;
    private final IRepositoryPropertySetSample snapshotID;

    public RepositoryAttributeSetLockSample(IRepositoryObjectTypeID objectTypeID, IRepositoryAttributeSetTypeID attributeSetTypeID, IRepositoryPropertySetSample objectID, IRepositoryPropertySetSample snapshotID) {
        this.objectTypeID = objectTypeID;
        this.attributeSetTypeID = attributeSetTypeID;
        this.objectID = objectID;
        this.snapshotID = snapshotID;
    }

    private RepositoryAttributeSetLockSample(IRepositoryAttributeSet attributeSetToLock) throws EXNotReproducibleSnapshot {
        assert (attributeSetToLock != null);
        this.attributeSetTypeID = attributeSetToLock.getAttributeSetType().getRepositoryAttributeSetTypeID();
        IRepositoryObject repositoryObject = attributeSetToLock.getObject();
        IRepositoryObjectType objectType = repositoryObject.getObjectType();
        this.objectID = repositoryObject.getAttributeSet(objectType.getIDAttributeSetType()).sample();
        this.objectTypeID = objectType.getRepositoryObjectTypeID();
        this.snapshotID = attributeSetToLock.getSnapshotIDOfLastModification();
        assert (this.attributeSetTypeID != null && this.objectID != null && this.objectTypeID != null);
    }

    public IRepositoryAttributeSetTypeID getAttributeSetTypeID() {
        return this.attributeSetTypeID;
    }

    public IRepositoryPropertySetSample getObjectID() {
        return this.objectID;
    }

    public IRepositoryObjectTypeID getObjectTypeID() {
        return this.objectTypeID;
    }

    public IRepositoryPropertySetSample getBasedSnapshotID() {
        return this.snapshotID;
    }

    public static AbstractRepositoryAttributeSetLockSample createLock(IRepositoryAttributeSet attributeSetToLock) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)attributeSetToLock);
        return new RepositoryAttributeSetLockSample(attributeSetToLock);
    }
}

