/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.data.item.IItemUID;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.DTEmptyValueRangeSample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryValueRangeSample;
import com.arcway.repository.lib.high.declaration.data.item.ItemTypeID;
import com.arcway.repository.lib.high.declaration.type.RepositoryDeclarationItemTypeID;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.DataValidationException;
import java.util.WeakHashMap;

public abstract class AbstractRepositoryDataType
implements IRepositoryDataType {
    public static final ItemTypeID ITEM_TYPE_ID = new RepositoryDeclarationItemTypeID(new KeySegment("datatype"));
    private final WeakHashMap<IRepositoryDataTypeParameters, IDataType> parameters2dataTypesWithoutPortableLoading = new WeakHashMap();
    private final WeakHashMap<IRepositoryDataTypeParameters, IDataType> parameters2dataTypesWithPortableLoading = new WeakHashMap();

    @Override
    public final IItemUID getItemUID() {
        return this.getRepositoryDataTypeID();
    }

    @Override
    public IRepositoryDeclarationItemID getRepositoryDeclarationItemID() {
        return this.getRepositoryDataTypeID();
    }

    @Override
    public IItemTypeID getItemTypeID() {
        return ITEM_TYPE_ID;
    }

    @Override
    public abstract IRepositoryDataTypeID getRepositoryDataTypeID();

    @Override
    public IDataType getDataTypeOfValueRangeSample() {
        return DTEmptyValueRangeSample.getInstance();
    }

    @Override
    public synchronized IDataType getDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        WeakHashMap<IRepositoryDataTypeParameters, IDataType> parameters2dataTypes = withPortableLoading ? this.parameters2dataTypesWithPortableLoading : this.parameters2dataTypesWithoutPortableLoading;
        IDataType dataType = (IDataType)parameters2dataTypes.get(dataTypeParameters);
        if (dataType == null) {
            dataType = this.createDataTypeOfRepositoryData(dataTypeParameters, withPortableLoading);
            parameters2dataTypes.put(dataTypeParameters, dataType);
        }
        return dataType;
    }

    @Override
    public IDataType getDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, IRepositoryValueRangeSample sourceValueRangeSample) {
        return this.getDataTypeOfRepositoryData(dataTypeParameters, true);
    }

    protected abstract IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters var1, boolean var2);

    @Override
    public IRepositoryDataHasher getOccurrenceIDHasher() {
        return null;
    }

    protected abstract class AbstractHashableData
    implements IRepositoryData {
        private String canonicalString;
        private int hashCodeOfCanonicalString;

        protected abstract String createCanonicalString();

        private synchronized void ensureCanonicalStringIsSet() {
            if (this.canonicalString == null) {
                this.canonicalString = this.createCanonicalString();
                this.hashCodeOfCanonicalString = this.canonicalString.hashCode();
            }
        }

        public String getCanonicalString() {
            this.ensureCanonicalStringIsSet();
            return this.canonicalString;
        }

        public int getHashCodeOfCanonicalString() {
            this.ensureCanonicalStringIsSet();
            return this.hashCodeOfCanonicalString;
        }
    }

    protected abstract class AbstractHasher
    implements IRepositoryDataHasher {
        protected AbstractHasher() {
        }

        @Override
        public String getCanonicalStringRepresentation(IRepositoryData data) {
            AbstractHashableData typedData = (AbstractHashableData)data;
            String canonicalString = typedData.getCanonicalString();
            return canonicalString;
        }

        @Override
        public int getHashCode(IRepositoryData data) {
            AbstractHashableData typedData = (AbstractHashableData)data;
            int hashCode = typedData.getHashCodeOfCanonicalString();
            return hashCode;
        }

        @Override
        public boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
            AbstractHashableData typedData1 = (AbstractHashableData)data1;
            AbstractHashableData typedData2 = (AbstractHashableData)data2;
            String canonicalString1 = typedData1.getCanonicalString();
            String canonicalString2 = typedData2.getCanonicalString();
            return canonicalString1.equals(canonicalString2);
        }
    }

    public class EXValueNotSet
    extends DataValidationException {
    }
}

