/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.genericmodifications.implementation.type;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.GenericModificationItemType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.declaration.GenericModificationRelationTypeDeclaration;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationRelationType;

public class GenericModificationRelationType
extends GenericModificationItemType
implements IGenericModificationRelationType {
    private int currentInheritanceLevel = Integer.MAX_VALUE;
    private boolean isCreatableAndDeletableGenerically = false;

    public GenericModificationRelationType(GenericModificationTypeManager genericModificationTypeManager, ICrossLinkRepositoryRelationType repositoryRelationType) {
        super(genericModificationTypeManager, repositoryRelationType);
    }

    @Override
    public ICrossLinkRepositoryRelationType getRepositoryRelationType() {
        return (ICrossLinkRepositoryRelationType)this.getRepositoryItemType();
    }

    public void loadDeclaration(GenericModificationRelationTypeDeclaration relationTypeDeclaration) {
        IRepositoryRelationTypeID relationTypeID = relationTypeDeclaration.getRepositoryRelationTypeID();
        ICrossLinkRepositoryRelationType repositoryRelationType = this.getRepositoryTypeManager().getCrossLinkRelationType(relationTypeID);
        int inheritanceLevel = 0;
        while (repositoryRelationType.getAbstractSuperRelationType() != null && repositoryRelationType.getAbstractSuperRelationType() instanceof ICrossLinkRepositoryRelationType) {
            ++inheritanceLevel;
            repositoryRelationType = (ICrossLinkRepositoryRelationType)repositoryRelationType.getAbstractSuperRelationType();
        }
        this.loadDeclaration(relationTypeDeclaration, inheritanceLevel);
    }

    private void loadDeclaration(GenericModificationRelationTypeDeclaration relationTypeDeclaration, int inheritanceLevel) {
        ICrossLinkRepositoryRelationType repositoryRelationType = this.getRepositoryRelationType();
        if (inheritanceLevel < this.currentInheritanceLevel) {
            this.currentInheritanceLevel = inheritanceLevel;
            this.isCreatableAndDeletableGenerically = relationTypeDeclaration.isCreatableAndDeletableGenerically();
        }
        ICollection_<? extends ICrossLinkRepositoryRelationType> directRepositorySubRelationTypes = repositoryRelationType.getDirectSubRelationTypes();
        for (ICrossLinkRepositoryRelationType directRepositorySubRelationType : directRepositorySubRelationTypes) {
            GenericModificationRelationType directGenericModificationSubRelationType = this.getGenericModificationTypeManagerImplementation().getGenericModificationRelationTypeImplementation(directRepositorySubRelationType);
            directGenericModificationSubRelationType.loadDeclaration(relationTypeDeclaration, inheritanceLevel);
        }
    }

    @Override
    public boolean isCreatableAndDeletableGenerically() {
        return this.isCreatableAndDeletableGenerically;
    }
}

