/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import java.util.WeakHashMap;

public class RepositoryObjectTypes {
    private static WeakHashMap<IRepositoryObjectType, IRepositoryPropertyTypeID> map_objectType_namePropertyType = new WeakHashMap();
    private static IRepositoryPropertyTypeID noNameProperty = new IRepositoryPropertyTypeID(){

        public String toCanonicalString() {
            return "noNameProperty";
        }
    };

    public static IRepositoryObjectType findCommonSuperObjectType(IRepositoryObjectType firstObjectType, IRepositoryObjectType secondObjectType) {
        IRepositoryObjectType consideredObjectType = firstObjectType;
        while (consideredObjectType != null) {
            if (consideredObjectType.isSuperTypeOf(secondObjectType)) {
                return consideredObjectType;
            }
            consideredObjectType = consideredObjectType.getAbstractSuperObjectType();
        }
        return null;
    }

    public static IRepositoryObjectTypeID findMostSpecificSuperObjectType(IRepositoryObjectType objectTypeInQuestion, ISet_<IRepositoryObjectTypeID> availableTypes) {
        IRepositoryObjectTypeID superType = null;
        IRepositoryObjectType consideredObjectType = objectTypeInQuestion;
        while (consideredObjectType != null) {
            IRepositoryObjectTypeID consideredObjectTypeID = consideredObjectType.getRepositoryObjectTypeID();
            if (availableTypes.contains((Object)consideredObjectTypeID)) {
                superType = consideredObjectTypeID;
                break;
            }
            consideredObjectType = consideredObjectType.getAbstractSuperObjectType();
        }
        return superType;
    }

    public static IRepositoryPropertyTypeID findNamePropertyTypeID(IRepositoryObjectType repositoryObjectType) {
        IRepositoryPropertyTypeID propertyTypeID = map_objectType_namePropertyType.get(repositoryObjectType);
        if (propertyTypeID == null) {
            ArrayList_ relevantPropertyTypes = new ArrayList_();
            for (IRepositoryAttributeSetType attributeSetType : repositoryObjectType.getAttributeSetTypes()) {
                for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                    if (!propertyType.getIDType().isName()) continue;
                    relevantPropertyTypes.add((Object)propertyType);
                }
            }
            propertyTypeID = relevantPropertyTypes.size() == 1 ? ((IRepositoryPropertyType)relevantPropertyTypes.iterator().next()).getRepositoryPropertyTypeID() : noNameProperty;
            map_objectType_namePropertyType.put(repositoryObjectType, propertyTypeID);
        }
        return propertyTypeID != noNameProperty ? propertyTypeID : null;
    }

    public static IRepositoryPropertyTypeID findIDPropertyTypeID(IRepositoryObjectType repositoryObjectType) {
        ArrayList_ relevantPropertyTypes = new ArrayList_();
        for (IRepositoryAttributeSetType attributeSetType : repositoryObjectType.getAttributeSetTypes()) {
            for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                if (!propertyType.getIDType().isID()) continue;
                relevantPropertyTypes.add((Object)propertyType);
            }
        }
        IRepositoryPropertyTypeID propertyTypeID = relevantPropertyTypes.size() == 1 ? ((IRepositoryPropertyType)relevantPropertyTypes.iterator().next()).getRepositoryPropertyTypeID() : null;
        return propertyTypeID;
    }

    public static ICollection_<? extends IRepositoryPropertyType> getAllPropertyTypes(IRepositoryObjectType repositoryObjectType) {
        return RepositoryObjectTypes.getAllPropertyTypes(repositoryObjectType, true);
    }

    public static ICollection_<? extends IRepositoryPropertyType> getAllPropertyTypesExceptObjectIDProperties(IRepositoryObjectType repositoryObjectType) {
        return RepositoryObjectTypes.getAllPropertyTypes(repositoryObjectType, false);
    }

    public static IRepositoryPropertyType getPropertyType(IRepositoryObjectType repositoryObjectType, IRepositoryPropertyTypeID propertyTypeID) {
        IRepositoryAttributeSetType attributeSetType = repositoryObjectType.findAttributeSetType(propertyTypeID);
        if (attributeSetType != null) {
            return attributeSetType.getPropertyType(propertyTypeID);
        }
        return null;
    }

    public static ICollection_<? extends ICrossLinkRepositoryRelationContributionType> getAllCrossLinkRelationContributionTypes(IRepositoryObjectType repositoryObjectType) {
        return RepositoryObjectTypes.getAllCrossLinkRelationContributionTypes(repositoryObjectType, false);
    }

    public static ICollection_<? extends ICrossLinkRepositoryRelationContributionType> getAllCrossLinkRelationContributionTypesThatAreAttributes(IRepositoryObjectType repositoryObjectType) {
        return RepositoryObjectTypes.getAllCrossLinkRelationContributionTypes(repositoryObjectType, true);
    }

    private static ICollection_<? extends IRepositoryPropertyType> getAllPropertyTypes(IRepositoryObjectType repositoryObjectType, boolean includingObjectIDProperties) {
        ArrayList_ allPropertyTypes = new ArrayList_();
        IRepositoryAttributeSetTypeID objectIDAttributeSetTypeID = repositoryObjectType.getIDAttributeSetType().getRepositoryAttributeSetTypeID();
        for (IRepositoryAttributeSetType attributeSetType : repositoryObjectType.getAttributeSetTypes()) {
            if (!includingObjectIDProperties && IRepositoryAttributeSetTypeID.IS_EQUAL_ATTRIBUTE_SET_TYPE_ID_HASHER.isEqual((Object)objectIDAttributeSetTypeID, (Object)attributeSetType.getRepositoryAttributeSetTypeID())) continue;
            allPropertyTypes.addAll(attributeSetType.getPropertyTypes());
        }
        return allPropertyTypes;
    }

    private static ICollection_<? extends ICrossLinkRepositoryRelationContributionType> getAllCrossLinkRelationContributionTypes(IRepositoryObjectType repositoryObjectType, boolean attributeRelationsOnly) {
        ArrayList_ allCrossLinkRelationContributionTypes = new ArrayList_();
        for (IRepositoryAttributeSetType attributeSetType : repositoryObjectType.getAttributeSetTypes()) {
            ICollection_<? extends ICrossLinkRepositoryRelationContributionType> crossLinkRelationContributionTypes = attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes();
            if (!attributeRelationsOnly) {
                allCrossLinkRelationContributionTypes.addAll(crossLinkRelationContributionTypes);
                continue;
            }
            for (ICrossLinkRepositoryRelationContributionType crossLinkRelationContributionType : crossLinkRelationContributionTypes) {
                if (crossLinkRelationContributionType.getCardinality().getMaximum() != 1) continue;
                allCrossLinkRelationContributionTypes.add((Object)crossLinkRelationContributionType);
            }
        }
        return allCrossLinkRelationContributionTypes;
    }

    private RepositoryObjectTypes() {
    }
}

