/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.print;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planview.view.PVView;

public class PrintProcessor {
    private Rectangle planRect;
    private Rectangle drawableRect;
    private Rectangle pageRect;
    private Insets printerMargin;
    private Insets margin;
    private TransformationAffiliate unitsToMMTranslateScaleTransformation;
    private TransformationAffiliate scaleTransformation;

    public void print(IPrinter printer, final PVView pvView, PageSetup config, String jobName) throws PrintingFailure {
        assert (jobName != null) : "jobName must not be null";
        this.fillPrinterConfig(printer, pvView, config);
        final int maxX = config.getPageCountX();
        final int maxY = config.getPageCountY();
        if (maxX > 0 && maxY > 0 && config.getZoom() > 0.0) {
            double widthByLeafs = (double)maxX * this.pageRect.w() - this.margin.leftInset - this.margin.rightInset - (double)(maxX - 1) * (this.printerMargin.leftInset + this.printerMargin.rightInset);
            double heightByLeafs = (double)maxY * this.pageRect.h() - this.margin.upperInset - this.margin.lowerInset - (double)(maxY - 1) * (this.printerMargin.upperInset + this.printerMargin.lowerInset);
            Alignment align = config.getAlignment();
            double xPos = 0.0;
            double yPos = 0.0;
            switch (align.h) {
                case 1: {
                    break;
                }
                case 2: {
                    xPos = (widthByLeafs - this.planRect.w()) / 2.0;
                    break;
                }
                case 4: {
                    xPos = widthByLeafs - this.planRect.w();
                }
            }
            switch (align.v) {
                case 8: {
                    break;
                }
                case 16: {
                    yPos = (heightByLeafs - this.planRect.h()) / 2.0;
                    break;
                }
                case 32: {
                    yPos = heightByLeafs - this.planRect.h();
                }
            }
            final GeoVector alignmentVector = new GeoVector(xPos + this.drawableRect.upperLeft.x, yPos + this.drawableRect.upperLeft.y);
            printer.performJob(jobName, new IPrinter.IPrintingJobProcessor(){

                public void processPrintingJob(IPrinter.IPrintingJob printingJob) throws PrintingFailure {
                    int x = 0;
                    while (x < maxX) {
                        int y = 0;
                        while (y < maxY) {
                            TransformationAffiliate unitsToMMTranslateAdjustedScaleTransformation;
                            double offsetX = ((PrintProcessor)PrintProcessor.this).margin.leftInset - ((PrintProcessor)PrintProcessor.this).printerMargin.leftInset;
                            double offsetY = ((PrintProcessor)PrintProcessor.this).margin.upperInset - ((PrintProcessor)PrintProcessor.this).printerMargin.upperInset;
                            if (x >= 1) {
                                offsetX = -(PrintProcessor.this.pageRect.w() - ((PrintProcessor)PrintProcessor.this).margin.leftInset - ((PrintProcessor)PrintProcessor.this).printerMargin.rightInset);
                                offsetX -= (double)(x - 1) * (PrintProcessor.this.pageRect.w() - ((PrintProcessor)PrintProcessor.this).printerMargin.leftInset - ((PrintProcessor)PrintProcessor.this).printerMargin.rightInset);
                            }
                            if (y >= 1) {
                                offsetY = -(PrintProcessor.this.pageRect.h() - ((PrintProcessor)PrintProcessor.this).margin.upperInset - ((PrintProcessor)PrintProcessor.this).printerMargin.lowerInset);
                                offsetY -= (double)(y - 1) * (PrintProcessor.this.pageRect.h() - ((PrintProcessor)PrintProcessor.this).printerMargin.upperInset - ((PrintProcessor)PrintProcessor.this).printerMargin.lowerInset);
                            }
                            GeoVector v = new GeoVector(offsetX, offsetY);
                            TransformationAffiliate unitsToMMTranslateTransformation = PrintProcessor.this.unitsToMMTranslateScaleTransformation.transform(PrintProcessor.this.scaleTransformation.getInverse());
                            TransformationAffiliate unitsToMMTranslateAdjustedTransformation = unitsToMMTranslateTransformation.transform(TransformationAffiliate.newTransformationTranslation((GeoVector)GeoVector.add((GeoVector)v, (GeoVector)alignmentVector)));
                            TransformationAffiliate current = unitsToMMTranslateAdjustedScaleTransformation = unitsToMMTranslateAdjustedTransformation.transform(PrintProcessor.this.scaleTransformation);
                            Rectangle totalDrawingAreaInPlanCoordinates = pvView.getOuterBoundsWithoutChildren();
                            if (totalDrawingAreaInPlanCoordinates == null) {
                                totalDrawingAreaInPlanCoordinates = new Rectangle(Point.ORIGIN, new Dimension(0.0, 0.0));
                            }
                            Rectangle totalDrawingAreaInPrinterCoordinates = totalDrawingAreaInPlanCoordinates.transform((Transformation)current);
                            final TransformationAffiliate currentFinal = current;
                            printingJob.drawPage(totalDrawingAreaInPrinterCoordinates, new IPrinter.IPagePrinter(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void printPage(final Device page) throws PrintingFailure {
                                    Device device = page;
                                    synchronized (device) {
                                        page.subElement(null, null, null, (Transformation)currentFinal, (IDeviceRunnable)new IDeviceRunnable<RuntimeException>(){

                                            public void run() {
                                                pvView.drawFigure(page);
                                            }
                                        });
                                    }
                                }
                            });
                            ++y;
                        }
                        ++x;
                    }
                }
            });
        }
    }

    public void fillPrinterConfig(IPrinter printer, PVView pvView, PageSetup config) {
        this.drawableRect = printer.getDrawingArea();
        this.pageRect = printer.getPageSize();
        this.printerMargin = new Insets(this.drawableRect.upperLeft.y - this.pageRect.upperLeft.y, this.pageRect.lowerRight.y - this.drawableRect.lowerRight.y, this.drawableRect.upperLeft.x - this.pageRect.upperLeft.x, this.pageRect.lowerRight.x - this.drawableRect.lowerRight.x);
        this.margin = config.getMargin();
        if (this.margin == null) {
            this.margin = new Insets(this.printerMargin);
        }
        this.planRect = pvView.calculateBounds();
        if (this.planRect == null) {
            this.planRect = new Rectangle(0.0, 0.0, 0.0, 0.0);
            this.scaleTransformation = TransformationAffiliate.newTransformationNOP();
            this.unitsToMMTranslateScaleTransformation = TransformationAffiliate.newTransformationNOP();
            if (config.getPageCountX() < 1) {
                config.setPageCountX(1);
            }
            if (config.getPageCountY() < 1) {
                config.setPageCountY(1);
            }
            if (config.getZoom() == 0.0) {
                config.setZoom(1.0);
            }
        } else {
            double scaling;
            TransformationAffiliate unitsToMillimeters = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(1.0, 1.0));
            this.planRect = this.planRect.transform((Transformation)unitsToMillimeters);
            int maxX = config.getPageCountX();
            int maxY = config.getPageCountY();
            if (config.isFitHorizontally() || config.isFitVertically()) {
                double drawingWidth = (double)Math.max(1, maxX) * this.drawableRect.w() - (this.margin.leftInset - this.printerMargin.leftInset) - (this.margin.rightInset - this.printerMargin.rightInset);
                double scalingX = drawingWidth / this.planRect.w();
                double drawingHeight = (double)Math.max(1, maxY) * this.drawableRect.h() - (this.margin.upperInset - this.printerMargin.upperInset) - (this.margin.lowerInset - this.printerMargin.lowerInset);
                double scalingY = drawingHeight / this.planRect.h();
                scaling = drawingWidth <= 0.0 || drawingHeight <= 0.0 ? 0.0 : (config.isFitHorizontally() && config.isFitVertically() ? (scalingX > scalingY ? scalingY : scalingX) : (config.isFitHorizontally() ? scalingX : scalingY));
            } else {
                scaling = config.getZoom();
            }
            if (scaling > 0.0) {
                this.scaleTransformation = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(scaling, scaling));
                double offsetX = config.getOffsetXInMM();
                double offsetY = config.getOffsetYInMM();
                GeoVector offset = new GeoVector(offsetX, offsetY);
                GeoVector v = GeoVector.add((GeoVector)new GeoVector(this.planRect.upperLeft), (GeoVector)offset);
                v = v.scale(-1.0);
                TransformationAffiliate translateTransform = TransformationAffiliate.newTransformationTranslation((GeoVector)v);
                this.unitsToMMTranslateScaleTransformation = new TransformationAffiliate();
                this.unitsToMMTranslateScaleTransformation.addLast(unitsToMillimeters);
                this.unitsToMMTranslateScaleTransformation.addLast(translateTransform);
                this.unitsToMMTranslateScaleTransformation.addLast(this.scaleTransformation);
                this.planRect = this.planRect.transform((Transformation)this.unitsToMMTranslateScaleTransformation);
                maxX = maxX > 0 ? maxX : this.getNumberOfNeededPages(this.pageRect.w(), this.printerMargin.leftInset, this.printerMargin.rightInset, this.planRect.w(), this.margin.leftInset, this.margin.rightInset);
                maxY = maxY > 0 ? maxY : this.getNumberOfNeededPages(this.pageRect.h(), this.printerMargin.upperInset, this.printerMargin.lowerInset, this.planRect.h(), this.margin.upperInset, this.margin.lowerInset);
            } else {
                maxX = Math.max(maxX, 1);
                maxY = Math.max(maxY, 1);
            }
            if (config.isFitHorizontally() || config.isFitVertically()) {
                config.setZoom((double)((float)scaling));
                if (config.isFitHorizontally() && config.isFitVertically()) {
                    if (config.getPageCountX() < maxX) {
                        config.setPageCountX(maxX);
                    }
                    if (config.getPageCountY() < maxY) {
                        config.setPageCountY(maxY);
                    }
                } else if (config.isFitHorizontally()) {
                    config.setPageCountY(maxY);
                } else {
                    config.setPageCountX(maxX);
                }
            } else {
                config.setPageCountX(maxX);
                config.setPageCountY(maxY);
            }
        }
    }

    private int getNumberOfNeededPages(double pageSize, double pageMargin1, double pageMargin2, double planSize, double planMargin1, double planMargin2) {
        int neededPages;
        double lengthRemaining = planMargin1 + planSize + planMargin2;
        if (lengthRemaining - 1.0E-10 < pageSize) {
            neededPages = 1;
        } else if ((lengthRemaining -= pageSize - pageMargin2) - 1.0E-10 < pageSize - pageMargin1) {
            neededPages = 2;
        } else {
            double neededMiddlePagesDouble = (lengthRemaining -= pageSize - pageMargin1) / (pageSize - pageMargin1 - pageMargin2);
            neededPages = 2 + (int)Math.ceil(neededMiddlePagesDouble - 1.0E-10);
        }
        return neededPages;
    }
}

