/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.legends;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IImageDataProvider;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.planview.Messages;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import java.text.DateFormat;
import java.util.Locale;

public class PVTextLegend
extends PVPlanViewPart {
    private static final ILogger logger = Logger.getLogger(PVTextLegend.class);
    private String copyrightNotice = "";
    private String creator = "";
    private String creationDate = "";
    private IImageData logo = null;
    private String modificationDate = "";
    private String modifier = "";
    private String planName = "";
    private String projectName = "";
    private String version = "";
    private Locale locale = Locale.getDefault();
    private static final double textHeight = 3.0;
    private static final double bigTextHeight = 3.5;
    private static final TextStyle textStyle = new TextStyle("Arial");
    private static final TextStyle boldText = new TextStyle("Arial", true, false);
    private static final double rowHeight = 3.0;
    private static final int rowsCount = 5;
    private static final double padding = 1.5;
    private static final double thickLineWidth = 0.3;
    private static final double thinLineWidth = 0.1;

    public PVTextLegend(IPlanInfo info) {
        if (info.getTargetLocale() != null) {
            this.locale = info.getTargetLocale();
        }
        DateFormat dateFormat = DateFormat.getDateInstance(1, this.locale);
        if (info.getLogo() != null) {
            this.setLogo(info.getLogo());
        }
        if (info.getCreator() != null) {
            this.setCreator(info.getCreator());
        }
        if (info.getCreationDate() != null) {
            this.setCreationDate(dateFormat.format(info.getCreationDate()));
        }
        if (info.getModifier() != null) {
            this.setModifier(info.getModifier());
        }
        if (info.getModificationDate() != null) {
            this.setModificationDate(dateFormat.format(info.getModificationDate()));
        }
        if (info.getCopyrightNotice() != null) {
            this.setCopyrightNotice(info.getCopyrightNotice());
        }
        if (info.getProjectName() != null) {
            this.setProjectName(info.getProjectName());
        }
        if (info.getPlanName() != null) {
            this.setPlanName(info.getPlanName());
        }
        if (info.getVersion() != null) {
            this.setVersion(info.getVersion());
        }
    }

    @Override
    public void drawFigure(Device device) {
        double wPart2;
        PVPlanViewPart.VirtualDevice vDevice = new PVPlanViewPart.VirtualDevice(this);
        double[] columnWidths = this.logo == null ? new double[5] : new double[6];
        Alignment alignLeft = new Alignment(1, 16);
        Alignment alignCenter = new Alignment();
        double x = 0.0;
        String strCreated = Messages.getString("PVTextLegend.created", this.locale);
        String strModified = Messages.getString("PVTextLegend.modified", this.locale);
        String strVersion = Messages.getString("PVTextLegend.version", this.locale);
        double currentWidth = this.columnWidth(vDevice, new String[]{strCreated, strModified, strVersion}, textStyle, 3.0, 1);
        device.text(new Rectangle(x + 1.5, 3.0, x + currentWidth, 6.0), alignLeft, strCreated, textStyle, 3.0, Color.BLACK, false);
        device.text(new Rectangle(x + 1.5, 6.0, x + currentWidth, 9.0), alignLeft, strModified, textStyle, 3.0, Color.BLACK, false);
        device.text(new Rectangle(x + 1.5, 9.0, x + currentWidth, 12.0), alignLeft, strVersion, textStyle, 3.0, Color.BLACK, false);
        x += currentWidth;
        columnWidths[0] = currentWidth;
        String strDate = Messages.getString("PVTextLegend.date", this.locale);
        currentWidth = this.columnWidth(vDevice, new String[]{strDate, this.creationDate, this.modificationDate}, textStyle, 3.0, 1);
        device.text(new Rectangle(x, 0.0, x + currentWidth, 3.0), alignCenter, strDate, textStyle, 3.0, Color.BLACK, false);
        if (this.creationDate != null) {
            device.text(new Rectangle(x, 3.0, x + currentWidth, 6.0), alignCenter, this.creationDate, textStyle, 3.0, Color.BLACK, false);
        }
        if (this.modificationDate != null) {
            device.text(new Rectangle(x, 6.0, x + currentWidth, 9.0), alignCenter, this.modificationDate, textStyle, 3.0, Color.BLACK, false);
        }
        x += currentWidth;
        columnWidths[1] = currentWidth;
        String strName = Messages.getString("PVTextLegend.name", this.locale);
        currentWidth = this.columnWidth(vDevice, new String[]{strName, this.creator, this.modifier}, textStyle, 3.0, 1);
        if (this.copyrightNotice != null) {
            String[] stringArray = new String[]{this.copyrightNotice};
            double copyrightWidth = this.columnWidth(vDevice, stringArray, textStyle, 3.0, 1);
            if (copyrightWidth > x + currentWidth) {
                currentWidth = copyrightWidth - x;
            }
            device.text(new Rectangle(0.0, 12.0, x + currentWidth, 15.0), alignCenter, this.copyrightNotice, textStyle, 3.0, Color.BLACK, false);
        }
        device.text(new Rectangle(x, 0.0, x + currentWidth, 3.0), alignCenter, strName, textStyle, 3.0, Color.BLACK, false);
        if (this.creator != null) {
            device.text(new Rectangle(x, 3.0, x + currentWidth, 6.0), alignCenter, this.creator, textStyle, 3.0, Color.BLACK, false);
        }
        if (this.modifier != null) {
            device.text(new Rectangle(x, 6.0, x + currentWidth, 9.0), alignCenter, this.modifier, textStyle, 3.0, Color.BLACK, false);
        }
        x += currentWidth;
        columnWidths[2] = currentWidth;
        if (this.version != null) {
            device.text(new Rectangle(columnWidths[0], 9.0, x, 12.0), alignCenter, this.version, textStyle, 3.0, Color.BLACK, false);
        }
        String strProject = Messages.getString("PVTextLegend.project", this.locale);
        String strPlanName = Messages.getString("PVTextLegend.planName", this.locale);
        currentWidth = this.columnWidth(vDevice, new String[]{strProject, strPlanName}, textStyle, 3.0, 1);
        device.text(new Rectangle(x + 1.5, 0.0, x + currentWidth, 3.0), alignLeft, strProject, textStyle, 3.0, Color.BLACK, false);
        device.text(new Rectangle(x + 1.5, 3.0, x + currentWidth, 15.0), alignLeft, strPlanName, textStyle, 3.0, Color.BLACK, true);
        x += currentWidth;
        columnWidths[3] = currentWidth;
        currentWidth = this.columnWidth(vDevice, new String[]{this.projectName}, textStyle, 3.0, 1);
        double nameWidth = this.columnWidth(vDevice, new String[]{this.planName}, boldText, 3.5, 2);
        if (currentWidth < nameWidth) {
            currentWidth = nameWidth;
        }
        if (this.planName != null) {
            device.text(new Rectangle(x, 0.0, x + currentWidth, 3.0), alignCenter, this.projectName, textStyle, 3.0, Color.BLACK, false);
        }
        if (this.planName != null) {
            device.text(new Rectangle(x, 3.0, x + currentWidth, 15.0), alignCenter, this.planName, boldText, 3.5, Color.BLACK, true);
        }
        columnWidths[4] = currentWidth;
        x += currentWidth;
        if (this.logo != null) {
            IOffscreenBitmap arcwayImage;
            if (device.supportsNullImage()) {
                arcwayImage = null;
            } else {
                try {
                    IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
                    arcwayImage = renderer.createOffscreenBitmap(this.logo);
                }
                catch (EXImageTooBig e) {
                    arcwayImage = null;
                }
                catch (EXNoMoreHandles e) {
                    arcwayImage = null;
                }
                catch (EXImageDataTypeNotSupported e) {
                    arcwayImage = null;
                }
            }
            int imageHeightInPixel = this.logo.getHeightInPixels();
            if (imageHeightInPixel > 0 && (arcwayImage != null || device.supportsNullImage())) {
                int imageWidthInPixel = this.logo.getWidthInPixels();
                double imageHeightInMM = 15.0;
                double imageWidthInMM = (double)imageWidthInPixel * imageHeightInMM / (double)imageHeightInPixel;
                device.image(arcwayImage, new Rectangle(x, 0.0, x + imageWidthInMM, 0.0 + imageHeightInMM));
                columnWidths[5] = currentWidth = imageWidthInMM;
                x += currentWidth;
            }
            if (arcwayImage != null) {
                arcwayImage.dispose();
            }
        }
        double wPart1 = columnWidths[0] + columnWidths[1] + columnWidths[2];
        double wFull = wPart2 = columnWidths[0] + columnWidths[1] + columnWidths[2] + columnWidths[3] + columnWidths[4];
        if (this.logo != null) {
            wFull += columnWidths[5];
        }
        Points points = new Points();
        points.add(new Point(0.0, 0.0));
        points.add(new Point(wFull, 0.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(0.0, 3.0));
        points.add(new Point(wPart1, 3.0));
        device.polyline(new Corners(points, 0.0), 0.1, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(wPart1, 3.0));
        points.add(new Point(wPart2, 3.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(0.0, 6.0));
        points.add(new Point(wPart1, 6.0));
        device.polyline(new Corners(points, 0.0), 0.1, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(0.0, 9.0));
        points.add(new Point(wPart1, 9.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(0.0, 12.0));
        points.add(new Point(wPart1, 12.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(0.0, 15.0));
        points.add(new Point(wFull, 15.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        x = 0.0;
        points = new Points();
        points.add(new Point(x, 0.0));
        points.add(new Point(x, 15.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(x += columnWidths[0], 0.0));
        points.add(new Point(x, 12.0));
        device.polyline(new Corners(points, 0.0), 0.1, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(x += columnWidths[1], 0.0));
        points.add(new Point(x, 9.0));
        device.polyline(new Corners(points, 0.0), 0.1, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(x += columnWidths[2], 0.0));
        points.add(new Point(x, 15.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(x += columnWidths[3], 0.0));
        points.add(new Point(x, 15.0));
        device.polyline(new Corners(points, 0.0), 0.1, Color.BLACK, LineStyle.SOLID);
        points = new Points();
        points.add(new Point(x += columnWidths[4], 0.0));
        points.add(new Point(x, 15.0));
        device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        if (this.logo != null) {
            points = new Points();
            points.add(new Point(x += columnWidths[5], 0.0));
            points.add(new Point(x, 15.0));
            device.polyline(new Corners(points, 0.0), 0.3, Color.BLACK, LineStyle.SOLID);
        }
        vDevice.dispose();
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        Rectangle r = this.getOuterBoundsWithoutChildren().expand(tolerance);
        return r.isInside(p);
    }

    public void setCopyrightNotice(String copyrightNotice) {
        assert (copyrightNotice != null);
        this.copyrightNotice = copyrightNotice;
    }

    public void setCreator(String creator) {
        assert (creator != null);
        this.creator = creator;
    }

    public void setLogo(IImageDataProvider logo) {
        try {
            this.logo = logo.getImageData();
        }
        catch (Throwable e) {
            logger.warn("Could not load image.", e);
            this.logo = null;
        }
    }

    public void setModificationDate(String modificationDate) {
        assert (modificationDate != null);
        this.modificationDate = modificationDate;
    }

    public void setModifier(String modifier) {
        assert (modifier != null);
        this.modifier = modifier;
    }

    public void setPlanName(String planName) {
        assert (planName != null);
        this.planName = planName;
    }

    public void setProjectName(String projectName) {
        assert (projectName != null);
        this.projectName = projectName;
    }

    public void setVersion(String version) {
        assert (version != null);
        this.version = version;
    }

    private void setCreationDate(String creationDate) {
        assert (creationDate != null);
        this.creationDate = creationDate;
    }

    private double columnWidth(Device device, String[] rows, TextStyle style, double height, int numberOfLines) {
        double width = 0.0;
        String[] stringArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            double currentWidth = device.getTextLength(element, style, height, numberOfLines);
            if (currentWidth > width) {
                width = currentWidth;
            }
            ++n2;
        }
        return width += 3.0;
    }
}

