/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACCreate1Point;
import com.arcway.planagent.planmodel.actions.ACSetLineForce;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TAAddPoint
extends PredeterminedLengthTransaction {
    private static final int STEPS = 3;
    private final Point newPosition;
    private final IPMPointRW endPoint;
    private IPMLineRW line;

    public TAAddPoint(IPMPointRO endPoint, ActionParameters actionParameters, Point newPosition) {
        super(3, (IPMPlanModelObjectRW)((Object)endPoint), actionParameters);
        assert (newPosition != null);
        this.newPosition = newPosition;
        this.endPoint = (IPMPointRW)((Object)endPoint);
        if (this.endPoint.getLine1stRW() == null) {
            this.line = this.endPoint.getLine2ndRW();
        } else if (this.endPoint.getLine2ndRW() == null) {
            this.line = this.endPoint.getLine1stRW();
        } else assert (false) : "endPoint is not an endpoint!";
    }

    @Override
    public Action createAction(int n, ArrayList<Action> previousActions) {
        Action nextAction = null;
        switch (n) {
            case 0: {
                nextAction = new ACCreate1Point(this.getActionContext(), this.endPoint, this.line);
                break;
            }
            case 1: {
                ACCreate1Point create1PointAction = (ACCreate1Point)previousActions.get(0);
                int lineForce = 1;
                switch (this.line.getForce()) {
                    case 2: {
                        lineForce = 3;
                        break;
                    }
                    case 3: {
                        lineForce = 2;
                    }
                }
                nextAction = new ACSetLineForce(this.getActionContext(), create1PointAction.getCreatedLine(), lineForce);
                break;
            }
            case 2: {
                GeoVector distance = new GeoVector(this.endPoint.getPosition(), this.newPosition);
                nextAction = ActionFactory.createACMovePoint(this.getActionContext(), this.endPoint, distance, true);
            }
        }
        return nextAction;
    }

    public String toString() {
        return "TAAddPoint ()";
    }
}

