/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.IXMLRootElementRO;
import com.arcway.lib.codec.xml.XMLCoDec;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planviewer.IPlanDataProvider;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureDotRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMReferenceGraphicalSupplementToFigureRW;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.GraphicalSupplementFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectFactory;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.ModelChange;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringLineToLine;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToFigure;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToLine;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToPoint;
import com.arcway.planagent.planmodel.implementation.PMContainment;
import com.arcway.planagent.planmodel.implementation.PMFigureDot;
import com.arcway.planagent.planmodel.implementation.PMFigureLineShape;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PMGraphicalSupplement;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanDummy;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PMReferenceGraphicalSupplementToFigure;
import com.arcway.planagent.planmodel.implementation.PlanElementFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.PlanFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectVisitor;
import com.arcway.planagent.planmodel.implementation.SetupTool;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.persistent.PlanFileMgr;
import com.arcway.planagent.planmodel.transactions.TADeletePlanElementStructure;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class PlanModelMgr
implements IPMPlanModelObjectFactoryRW {
    private static final ILogger logger = Logger.getLogger(PlanModelMgr.class);
    private PMPlan plan = null;

    static {
        SetupTool.setup();
    }

    public PMPlan create(String planTypeID) throws EXPlanModelObjectFactoryException, CoreException, PlugInClassExtensionFactoryException {
        PMPlan pmPlan = null;
        pmPlan = planTypeID == null ? new PMPlanDummy(this) : PlanFactoryDispatcher.getInstance().create(this, planTypeID);
        this.setPlan(pmPlan);
        return pmPlan;
    }

    public PMPlan getPlan() {
        return this.plan;
    }

    private void setPlan(PMPlan plan) {
        this.plan = plan;
    }

    public PMPlan load(File planFile) throws EXPlanCreationException {
        return this.load(planFile, null);
    }

    public PMPlan load(IPlanDataProvider planLoader) throws EXPlanCreationException {
        byte[] byteArray;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IXMLRootElementRO planData = planLoader.getPlanData();
            XMLCoDec.encodeIntoOutputStream((OutputStream)byteArrayOutputStream, (String)"UTF-8", (IXMLRootElementRO)planData, (XMLFormatMode)XMLFormatMode.WITHOUT_INDENTION);
            byteArray = byteArrayOutputStream.toByteArray();
        }
        catch (EXXMLEncodingFailed e) {
            throw new EXPlanCreationException(e);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        return this.load(byteArrayInputStream);
    }

    public PMPlan load(InputStream b_in) throws EXPlanCreationException {
        return this.load(null, new InputStreamEOPlanLoader(b_in));
    }

    private PMPlan load(File planFile, IEOPlanLoader planLoader) throws EXPlanCreationException {
        PlanFileMgr planFileMgr = new PlanFileMgr();
        if (planFile != null) {
            planFileMgr.setPlanFile(planFile);
        }
        EOPlan eoPlan = null;
        boolean success = planLoader != null ? (eoPlan = planLoader.read(planFileMgr)) != null : (planFile != null ? (eoPlan = planFileMgr.readFile()) != null : false);
        PMPlan pmPlan = success ? this.load(eoPlan) : null;
        return pmPlan;
    }

    private PMPlan load(EOPlan eoPlan) throws EXPlanCreationException {
        PMPlan pmPlan = this.createAndLinkPlanModelObjects(eoPlan);
        this.setPlan(pmPlan);
        pmPlan.migrateAfterDeserialization();
        return pmPlan;
    }

    public void copy(PMPlan sourcePlan, Collection planElements) throws EXPlanCreationException {
        ArrayList<PMPlanElement> planElementsToRemove;
        PMPlan copyPMPlan = this.load(sourcePlan.getPersistentPlan().getCopy());
        if (planElements == null) {
            planElementsToRemove = new ArrayList<PMPlanElement>(0);
        } else {
            planElementsToRemove = new ArrayList(copyPMPlan.getPlanElementCount() - planElements.size());
            HashSet<String> planElementsUIDs = new HashSet<String>(planElements.size());
            for (PMPlanElement planElement : planElements) {
                planElementsUIDs.add(planElement.getUid());
            }
            int i = 0;
            while (i < copyPMPlan.getPlanElementCount()) {
                PMPlanElement planElement;
                planElement = copyPMPlan.getPlanElement(i);
                if (!planElementsUIDs.contains(planElement.getUid())) {
                    planElementsToRemove.add(planElement);
                }
                ++i;
            }
        }
        if (!planElementsToRemove.isEmpty()) {
            TADeletePlanElementStructure removeTransaction = new TADeletePlanElementStructure(planElementsToRemove, ActionParameters.DUMMY);
            if (removeTransaction.isValid()) {
                removeTransaction.dodo();
            } else {
                throw new EXPlanCreationException("copy plan: cannot remove not needed plan elements");
            }
        }
    }

    private PMPlan createAndLinkPlanModelObjects(EOPlan eoPlan) throws EXPlanCreationException {
        PMPlan pmPlan;
        try {
            LoadPlanModelObjectList objectList = new LoadPlanModelObjectList();
            LoadPlanModelObjectFactory planPMFactory = new LoadPlanModelObjectFactory(objectList);
            LoadPlanModelObjectLinker planPMLinker = new LoadPlanModelObjectLinker(objectList);
            ArrayList<EOPlan> list = new ArrayList<EOPlan>();
            list.add(eoPlan);
            this.createAndLink(planPMFactory, null, list);
            pmPlan = (PMPlan)planPMFactory.getFirstCreatedPM();
            planPMLinker.linkCrossLinks(pmPlan);
        }
        catch (EXPlanModelObjectFactoryException e) {
            throw new EXPlanCreationException(e);
        }
        catch (EXPlanModelObjectCrosslinkException e) {
            throw new EXPlanCreationException(e);
        }
        return pmPlan;
    }

    public boolean save(File planFile) throws IOException {
        return this.save(planFile, null);
    }

    public boolean save(OutputStream b_out) throws IOException {
        return this.save(null, b_out);
    }

    private boolean save(File planFile, OutputStream b_out) throws IOException {
        PlanFileMgr planFileMgr = new PlanFileMgr();
        planFileMgr.setData(this.plan.getPersistentPlan());
        if (planFile != null) {
            planFileMgr.setPlanFile(planFile);
        }
        PlanModelObjectVisitor hasCrosslinksResetter = new PlanModelObjectVisitor(){

            @Override
            protected void visit(PMPlanModelObject pm) {
                pm.getPersistentPlanModelObject().clearHasCrosslinks();
            }
        };
        PlanModelObjectVisitor hasCrosslinksSetter = new PlanModelObjectVisitor(){

            @Override
            protected void visit(PMPlanModelObject pm) {
                List<? extends Object> crosslinked = pm.getCrosslinked();
                for (PMPlanModelObject pMPlanModelObject : crosslinked) {
                    pMPlanModelObject.getPersistentPlanModelObject().setHasCrosslinks();
                }
            }
        };
        hasCrosslinksResetter.visitAllPlanModelObjects(this.plan);
        hasCrosslinksSetter.visitAllPlanModelObjects(this.plan);
        boolean success = b_out != null ? planFileMgr.write(b_out) : (planFile != null ? planFileMgr.writeFile() : false);
        return success;
    }

    private void createAndLink(LoadPlanModelObjectFactory planPMFactory, PMPlanModelObject parent, List children) throws EXPlanModelObjectFactoryException {
        int childIndex = 0;
        while (childIndex < children.size()) {
            EncodableObjectBase childEO = (EncodableObjectBase)children.get(childIndex);
            if (childEO != null) {
                PMPlanModelObject childPM = planPMFactory.create(this, childEO);
                LoadPlanModelObjectLinker.linkParentChild(parent, childPM);
                List grandChildrenEO = planPMFactory.getChildren(childEO);
                this.createAndLink(planPMFactory, childPM, grandChildrenEO);
            }
            ++childIndex;
        }
    }

    @Override
    public IPMPlanRW createPMPlanRW(String planTypeID) throws EXPlanModelObjectFactoryException {
        logger.debug(51, "   PlanModelMgr: creating PMPlanRW (planTypeID " + planTypeID + ")");
        PMPlan planRW = null;
        try {
            planRW = PlanFactoryDispatcher.getInstance().create(this, planTypeID);
        }
        catch (CoreException e) {
            throw new EXPlanModelObjectFactoryException(e);
        }
        catch (PlugInClassExtensionFactoryException e) {
            throw new EXPlanModelObjectFactoryException(e);
        }
        return planRW;
    }

    @Override
    public IPMPlanElementRW createPMPlanElementRW(String planElementTypeID) throws EXPlanModelObjectFactoryException {
        logger.debug(51, "   PlanModelMgr: creating PMPlanElementRW (planElementTypeID " + planElementTypeID + ")");
        PMPlanElement planElement = null;
        try {
            planElement = PlanElementFactoryDispatcher.getInstance().create(this, planElementTypeID);
        }
        catch (CoreException e) {
            throw new EXPlanModelObjectFactoryException(e);
        }
        catch (PlugInClassExtensionFactoryException e) {
            throw new EXPlanModelObjectFactoryException(e);
        }
        return planElement;
    }

    @Override
    public IPMContainmentRW createPMContainmentRW() {
        logger.debug(51, "   PlanModelMgr: creating PMContainmentRW ()");
        return new PMContainment(this);
    }

    @Override
    public IPMFigurePlaneRW createPMFigurePlaneRW() {
        logger.debug(51, "   PlanModelMgr: creating PMFigurePlaneRW ()");
        return new PMFigurePlane(this);
    }

    @Override
    public IPMFigureLineShapeRW createPMFigureLineShapeRW() {
        logger.debug(51, "   PlanModelMgr: creating PMFigureLineShapeRW ()");
        return new PMFigureLineShape(this);
    }

    @Override
    public IPMFigureDotRW createPMFigureDotRW() {
        logger.debug(51, "   PlanModelMgr: creating PMFigureDotRW ()");
        return new PMFigureDot(this);
    }

    @Override
    public IPMGraphicalSupplementRW createPMGraphicalSupplementRW(String graphicalSupplementTypeID) throws EXPlanModelObjectFactoryException {
        logger.debug(51, "   PlanModelMgr: creating PMGraphicalSupplementRW (graphicalSupplementTypeID " + graphicalSupplementTypeID + ")");
        PMGraphicalSupplement graphicalSupplement = null;
        try {
            graphicalSupplement = GraphicalSupplementFactoryDispatcher.getInstance().create(this, graphicalSupplementTypeID);
        }
        catch (CoreException e) {
            throw new EXPlanModelObjectFactoryException(e);
        }
        catch (PlugInClassExtensionFactoryException e) {
            throw new EXPlanModelObjectFactoryException(e);
        }
        return graphicalSupplement;
    }

    @Override
    public IPMReferenceGraphicalSupplementToFigureRW createPMReferenceGraphicalSupplementToFigureRW() {
        logger.debug(51, "   PlanModelMgr: creating PMReferenceGraphicalSupplementToFigureRW ()");
        return new PMReferenceGraphicalSupplementToFigure(this);
    }

    @Override
    public IPMPointListRW createPMPointListRW() {
        logger.debug(51, "   PlanModelMgr: creating PMPointListRW ()");
        return new PMPointList(this);
    }

    @Override
    public IPMPointRW createPMPointRW() {
        logger.debug(51, "   PlanModelMgr: creating PMPointRW ()");
        return new PMPoint(this);
    }

    @Override
    public IPMLineRW createPMLineRW() {
        logger.debug(51, "   PlanModelMgr: creating PMLineRW ()");
        return new PMLine(this);
    }

    @Override
    public IPMAnchorRW createPMAnchorRW() {
        logger.debug(51, "   PlanModelMgr: creating PMAnchorRW ()");
        return new PMAnchor(this);
    }

    @Override
    public IPMAnchoringPointToAnchorRW createPMAnchoringPointToAnchorRW() {
        logger.debug(51, "   PlanModelMgr: creating PMAnchoringPointToAnchorRW ()");
        return new PMAnchoringPointToAnchor(this);
    }

    @Override
    public IPMAnchoringPointToFigureRW createPMAnchoringPointToFigureRW() {
        logger.debug(51, "   PlanModelMgr: creating PMAnchoringPointToFigureRW ()");
        return new PMAnchoringPointToFigure(this);
    }

    @Override
    public IPMAnchoringPointToPointRW createPMAnchoringPointToPointRW() {
        logger.debug(51, "   PlanModelMgr: creating PMAnchoringPointToPointRW ()");
        return new PMAnchoringPointToPoint(this);
    }

    @Override
    public IPMAnchoringPointToLineRW createPMAnchoringPointToLineRW() {
        logger.debug(51, "   PlanModelMgr: creating PMAnchoringPointToLineRW ()");
        return new PMAnchoringPointToLine(this);
    }

    @Override
    public IPMAnchoringLineToLineRW createPMAnchoringLineToLineRW() {
        logger.debug(51, "   PlanModelMgr: creating PMAnchoringLineRW ()");
        return new PMAnchoringLineToLine(this);
    }

    @Override
    public IModelChangeRW createModelChange(IPMPlanModelObjectRW planModelObject, int type) {
        return new ModelChange(planModelObject, type);
    }

    private static interface IEOPlanLoader {
        public EOPlan read(PlanFileMgr var1) throws EXPlanCreationException;
    }

    private class InputStreamEOPlanLoader
    implements IEOPlanLoader {
        private final InputStream is;

        public InputStreamEOPlanLoader(InputStream is) {
            this.is = is;
        }

        @Override
        public EOPlan read(PlanFileMgr planFileMgr) throws EXPlanCreationException {
            return planFileMgr.read(this.is);
        }
    }
}

