/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.appearance;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planmodel.appearance.AppearanceTplApplier;
import com.arcway.planagent.planmodel.appearance.IAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextStyleAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextStyleAppearanceTpl;

public class TextAppearanceTpl
implements ITextAppearanceTpl {
    private int alignmentH;
    private int alignmentV;
    private int alignmentTplHint = 1;
    private Direction direction;
    private int directionTplHint = 1;
    private ITextStyleAppearanceTpl textStyleTpl = new TextStyleAppearanceTpl();
    private Insets insets;
    private int insetsTplHint = 1;
    private double textHeight;
    private int textHeightTplHint = 1;
    private Color textColor;
    private int textColorTplHint = 1;

    @Override
    public void setAlignment(Alignment alignment) {
        assert (alignment != null);
        this.setAlignmentTplHint(0);
        this.alignmentH = alignment.h;
        this.alignmentV = alignment.v;
    }

    @Override
    public void setDirection(Direction direction) {
        assert (direction != null);
        this.setDirectionTplHint(0);
        this.direction = direction;
    }

    @Override
    public void setInsets(Insets insets) {
        assert (insets != null);
        this.setInsetsTplHint(0);
        this.insets = new Insets(insets);
    }

    @Override
    public void setTextStyleTpl(ITextStyleAppearanceTpl textStyle) {
        assert (textStyle != null);
        this.textStyleTpl = textStyle;
    }

    @Override
    public void setTextHeight(double textHeigth) {
        assert (textHeigth > -1.0E-10);
        this.setTextHeightTplHint(0);
        this.textHeight = textHeigth;
    }

    @Override
    public void setTextColor(Color textColor) {
        assert (textColor != null);
        this.setTextColorTplHint(0);
        this.textColor = new Color(textColor);
    }

    @Override
    public Alignment getAlignment() {
        return new Alignment(this.alignmentH, this.alignmentV);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.insets);
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public ITextStyleAppearanceTpl getTextStyleTpl() {
        return this.textStyleTpl;
    }

    @Override
    public double getTextHeight() {
        return this.textHeight;
    }

    @Override
    public Color getTextColor() {
        return new Color(this.textColor);
    }

    public void setAlignmentTplHint(int alignmentTplHint) {
        this.alignmentTplHint = alignmentTplHint;
    }

    public int getAlignmentTplHint() {
        return this.alignmentTplHint;
    }

    public void setInsetsTplHint(int insetsTplHint) {
        this.insetsTplHint = insetsTplHint;
    }

    public int getInsetsTplHint() {
        return this.insetsTplHint;
    }

    public void setDirectionTplHint(int directionTplHint) {
        this.directionTplHint = directionTplHint;
    }

    public int getDirectionTplHint() {
        return this.directionTplHint;
    }

    public void setTextHeightTplHint(int textHeightTplHint) {
        this.textHeightTplHint = textHeightTplHint;
    }

    public int getTextHeightTplHint() {
        return this.textHeightTplHint;
    }

    public void setTextColorTplHint(int textColorTplHint) {
        this.textColorTplHint = textColorTplHint;
    }

    public int getTextColorTplHint() {
        return this.textColorTplHint;
    }

    @Override
    public boolean applyTo(IAppearance object) {
        if (!(object instanceof ITextAppearance)) {
            return false;
        }
        ITextAppearance text = (ITextAppearance)object;
        AppearanceTplApplier.text(this, text);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.alignmentTplHint != 0 && this.insetsTplHint != 0 && this.directionTplHint != 0 && this.textColorTplHint != 0 && this.textHeightTplHint != 0 && this.textStyleTpl.isEmpty();
    }
}

