/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.anchoring;

import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;

public class AnchoringProposal {
    private final IAnchoringDestination destination;
    private double distance;

    public AnchoringProposal(IAnchoringDestination destination, double distance) {
        this.destination = destination;
        this.distance = distance;
    }

    public IAnchoringDestination getDestination() {
        return this.destination;
    }

    public double getDistance() {
        return this.distance;
    }

    public void merge(AnchoringProposal anchoringProposal) {
        assert (anchoringProposal.destination == this.destination) : "anchoring proposals are not equal!";
        this.distance = Math.min(this.distance, anchoringProposal.distance);
    }

    public String toString() {
        String text = "AnchoringProposal[to " + this.destination;
        text = String.valueOf(text) + ", distance = " + this.distance;
        text = String.valueOf(text) + "]";
        return text;
    }
}

