/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.ArrayList;
import java.util.List;

public class ConcatenatingActionIterator
extends ActionIterator {
    private final List<ActionIterator> actionIterators;
    private int cursor = -1;

    public ConcatenatingActionIterator() {
        this(3);
    }

    public ConcatenatingActionIterator(int initialSize) {
        this.actionIterators = new ArrayList<ActionIterator>(initialSize);
    }

    public void addActionIterator(ActionIterator actionIterator) {
        assert (actionIterator != null) : "actionIterator is null";
        assert (this.cursor == -1) : "add action, but actionIterator was read out before";
        if (actionIterator instanceof ConcatenatingActionIterator) {
            ConcatenatingActionIterator concatenationToAdd = (ConcatenatingActionIterator)actionIterator;
            this.actionIterators.addAll(concatenationToAdd.actionIterators);
            concatenationToAdd.cursor = 0;
        } else if (actionIterator != EMPTY_ACTION_ITERATOR) {
            this.actionIterators.add(actionIterator);
        }
    }

    @Override
    public boolean hasNext() {
        this.setCursorToNextAction();
        return this.areActionIteratorsLeft();
    }

    @Override
    public Action next() {
        assert (this.hasNext()) : "no further actionIterator is stored in this concatenated action iterator";
        Action nextAction = null;
        this.setCursorToNextAction();
        if (this.areActionIteratorsLeft()) {
            ActionIterator currentActionIterator = this.actionIterators.get(this.cursor);
            nextAction = currentActionIterator.next();
        }
        return nextAction;
    }

    private void setCursorToNextAction() {
        if (this.cursor < 0) {
            this.cursor = 0;
        }
        boolean finished = false;
        while (!finished) {
            if (this.areActionIteratorsLeft()) {
                ActionIterator currentActionIterator = this.actionIterators.get(this.cursor);
                if (currentActionIterator.hasNext()) {
                    finished = true;
                    continue;
                }
                ++this.cursor;
                continue;
            }
            finished = true;
        }
    }

    private boolean areActionIteratorsLeft() {
        return this.cursor < this.actionIterators.size();
    }
}

