/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionTool;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ACTransferPlanElementStructure
extends Action {
    private final IPMPlanRW sourcePlan;
    private final IPMPlanRW targetPlan;
    private final GeoVector translation;
    private final List planElements = new ArrayList();
    private int startIndexTargetPlan;

    public ACTransferPlanElementStructure(ActionContext actionContext, IPMPlanRW sourcePlan, IPMPlanRW targetPlan, GeoVector translation) {
        super(actionContext);
        assert (sourcePlan != null) : "ref to sourcePlan is null";
        assert (targetPlan != null) : "ref to targetPlan is null";
        assert (translation != null) : "ref to translation is null";
        this.targetPlan = targetPlan;
        this.sourcePlan = sourcePlan;
        this.translation = translation;
    }

    @Override
    protected void initializeState() {
        int i = 0;
        while (i < this.sourcePlan.getPlanElementCount()) {
            IPMPlanElementRW planElement = this.sourcePlan.getPlanElementRW(i);
            this.planElements.add(planElement);
            ++i;
        }
        this.startIndexTargetPlan = this.targetPlan.getPlanElementCount();
    }

    @Override
    protected void setStateToPost() {
        IPMPlanElementRW planElement;
        int i = this.planElements.size() - 1;
        while (i >= 0) {
            this.sourcePlan.removePlanElement(i);
            --i;
        }
        i = 0;
        while (i < this.planElements.size()) {
            planElement = (IPMPlanElementRW)this.planElements.get(i);
            planElement.setPlan(this.targetPlan);
            ++i;
        }
        i = 0;
        while (i < this.planElements.size()) {
            planElement = (IPMPlanElementRW)this.planElements.get(i);
            assert (this.targetPlan.getPlanElementRW(planElement.getUid()) == null) : "Target plan already contains a planelement with the given UID";
            this.targetPlan.addPlanElement(planElement, this.startIndexTargetPlan + i);
            ++i;
        }
        ActionTool.movePlanElements(this.planElements, this.translation);
    }

    @Override
    protected void setStateToPre() {
        IPMPlanElementRW planElement;
        int i = this.startIndexTargetPlan + this.planElements.size() - 1;
        while (i >= this.startIndexTargetPlan) {
            this.targetPlan.removePlanElement(i);
            --i;
        }
        assert (this.startIndexTargetPlan == this.targetPlan.getPlanElementCount()) : "there should be as many planElements as before setStateToPost and setStateToPre";
        i = 0;
        while (i < this.planElements.size()) {
            planElement = (IPMPlanElementRW)this.planElements.get(i);
            planElement.setPlan(this.sourcePlan);
            ++i;
        }
        assert (this.sourcePlan.getPlanElementCount() == 0) : "the plan should have no planElements since all were remove in setStateToPost";
        i = 0;
        while (i < this.planElements.size()) {
            planElement = (IPMPlanElementRW)this.planElements.get(i);
            this.sourcePlan.addPlanElement(planElement, i);
            ++i;
        }
        ActionTool.movePlanElements(this.planElements, this.translation.turn180());
    }

    @Override
    public boolean isDupe(Action a) {
        ACTransferPlanElementStructure dupeA;
        boolean isDupe = false;
        if (a instanceof ACTransferPlanElementStructure && (dupeA = (ACTransferPlanElementStructure)a).getSourcePlan() == this.getSourcePlan() && dupeA.getTargetPlan() == this.getTargetPlan()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        boolean isNop = false;
        if (this.sourcePlan.getPlanElementCount() == 0) {
            isNop = true;
        }
        return isNop;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(this.planElements.size());
        int i = 0;
        while (i < this.planElements.size()) {
            IPMPlanElementRW planElement = (IPMPlanElementRW)this.planElements.get(i);
            changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(planElement, 1));
            ++i;
        }
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        List createdPlanElements = this.getCreatedPlanElements();
        ArrayList<IPMFigureRW> createdFigures = new ArrayList<IPMFigureRW>();
        ArrayList<IPMGraphicalSupplementRW> createdSupplements = new ArrayList<IPMGraphicalSupplementRW>();
        int e = 0;
        while (e < createdPlanElements.size()) {
            IPMPlanElementRW planElement = (IPMPlanElementRW)createdPlanElements.get(e);
            int i = 0;
            while (i < planElement.getFigureCount()) {
                IPMFigureRW figure = planElement.getFigureRW(i);
                createdFigures.add(figure);
                int j = 0;
                while (j < figure.getGraphicalSupplementCount()) {
                    createdSupplements.add(figure.getGraphicalSupplementRW(j));
                    ++j;
                }
                ++i;
            }
            ++e;
        }
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionCreateFigureAgent().getEntryForCompressedList(createdFigures, this.getActionContext()));
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionCreateSupplementAgent().getEntryForCompressedList(createdSupplements, this.getActionContext()));
        return reactions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.targetPlan;
    }

    public IPMPlanRW getSourcePlan() {
        return this.sourcePlan;
    }

    public IPMPlanRW getTargetPlan() {
        return this.targetPlan;
    }

    public List getCreatedPlanElements() {
        return this.planElements;
    }

    public String toString() {
        return "ACCreatePlanElementStructure (source plan " + this.sourcePlan + ", target plan " + this.targetPlan + ")";
    }
}

