/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import java.util.HashSet;
import java.util.Set;

public class ACCreateFigurePlane
extends ACCreateFigure {
    private final IFillAppearanceRO fill;
    private IPMFigurePlaneRW figurePlane;

    public ACCreateFigurePlane(ActionContext context, String role, IPMPlanElementRW planElement, Points points, int[] force, ILineAppearanceRO lineAppearance, IFillAppearanceRO fill, boolean backgroundFigure) {
        super(context, role, planElement, points, force, lineAppearance, backgroundFigure);
        assert (points.size() == force.length) : "it should be a closed line chain";
        assert (fill != null) : "ref to fill is null";
        this.fill = fill;
    }

    @Override
    protected void initializeState() {
        this.figurePlane = this.getIPlanModelObjectFactoryRW().createPMFigurePlaneRW();
        super.initializeState();
        FillAppearance.copy(this.fill, this.figurePlane.getFillAppearanceRW());
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.figurePlane, 1));
        return changes;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateFigurePlane dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateFigurePlane && (dupeA = (ACCreateFigurePlane)a).getFill() == this.getFill() && dupeA.getRole().equals(this.getRole()) && dupeA.getLineAppearance() == this.getLineAppearance() && dupeA.getPlanElement() == this.getPlanElement() && dupeA.getPoints() == this.getPoints() && dupeA.getForce() == this.getForce()) {
            isDupe = true;
        }
        return isDupe;
    }

    public IFillAppearanceRO getFill() {
        return this.fill;
    }

    @Override
    public IPMFigureRW getFigure() {
        return this.figurePlane;
    }

    @Override
    public IPMPlanObjectRW getPlanObject() {
        return this.figurePlane;
    }

    public String toString() {
        return "ACCreateFigurePlane (fill " + this.fill + ")";
    }
}

