/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementDotsCommentRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementDotsRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMPlanElementDotsCommentRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAFixDotsCommentAfterModify
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAFixDotsCommentAfterModify.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RIFixFMCBDDotsCommentAfterModifyAgent createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(2);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementDotsCommentRO)) {
            route &= false;
        }
        if (route && !figure.getRole().equals("outline")) {
            route &= false;
        }
        if (route) {
            IPMFigureRW outLine = figure;
            IPMPlanElementDotsCommentRW planElement = (IPMPlanElementDotsCommentRW)outLine.getPlanElementRW();
            IPMGraphicalSupplementDotsRW dots = planElement.getDotsRW();
            IPMPointListRW figurePointList = figure.getPointListRW();
            IPMPointListRW dotsPointList = dots.getPointListRW();
            if (figurePointList.getPointCount() >= 1 && dotsPointList.getPointCount() >= 1) {
                ACMovePoint movePointAction;
                GeoVector distanceToMove;
                IPMPointRW figure1st = figurePointList.getPointRW(0);
                IPMPointRW figureLast = figurePointList.getPointRW(figurePointList.getPointCount() - 1);
                IPMPointRW dots1st = dotsPointList.getPointRW(0);
                IPMPointRW dotsLast = dotsPointList.getPointRW(dotsPointList.getPointCount() - 1);
                boolean removeSourceAnchorings = false;
                if (!dots1st.getPosition().equalsPoint(figure1st.getPosition())) {
                    distanceToMove = new GeoVector(dots1st.getPosition(), figure1st.getPosition());
                    movePointAction = new ACMovePoint(actionContext, dots1st, distanceToMove, removeSourceAnchorings);
                    actions.addAction((Action)movePointAction);
                }
                if (!dotsLast.getPosition().equalsPoint(figureLast.getPosition())) {
                    distanceToMove = new GeoVector(dotsLast.getPosition(), figureLast.getPosition());
                    movePointAction = new ACMovePoint(actionContext, dotsLast, distanceToMove, removeSourceAnchorings);
                    actions.addAction((Action)movePointAction);
                }
            }
        }
    }
}

