/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.persistent;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.cm.appearance.DotsAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IDotsAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IDotsAppearanceRO;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EADotsAppearance
extends EAEncodableAttributes
implements IDotsAppearance {
    private static final String ATTR_TAG_SIZE = "size";
    private static final String ATTR_TAG_COLOR_RED = "color.red";
    private static final String ATTR_TAG_COLOR_GREEN = "color.green";
    private static final String ATTR_TAG_COLOR_BLUE = "color.blue";
    private static final String ATTR_TAG_COLOR_TRANSPARENT = "color.transparent";
    private static final String ATTR_TAG_DISTANCE = "distance";
    private double size = 1.0;
    private Color color = new Color(0, 0, 0);
    private double distance = 5.0;

    public EADotsAppearance(String attrTagPrefix) {
        super(attrTagPrefix);
    }

    public EADotsAppearance(EAEncodableAttributes ea, String xmlAttrTag) {
        super(ea, xmlAttrTag);
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        assert (writeContext != null) : "outp is NULL.";
        if (Math.abs(this.size - 1.0) >= 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_SIZE, this.size);
        }
        if (this.color.transparent) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_TRANSPARENT, this.color.transparent);
        }
        if (!(this.color.r == 0 && this.color.g == 0 && this.color.b == 0 || this.color.transparent)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_RED, this.color.r);
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_GREEN, this.color.g);
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_BLUE, this.color.b);
        }
        if (Math.abs(this.distance - 5.0) >= 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_DISTANCE, this.distance);
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (ATTR_TAG_SIZE.equals(name)) {
            this.size = this.toDouble(value);
        } else if (ATTR_TAG_COLOR_RED.equals(name)) {
            this.color.r = this.toInt(value);
        } else if (ATTR_TAG_COLOR_GREEN.equals(name)) {
            this.color.g = this.toInt(value);
        } else if (ATTR_TAG_COLOR_BLUE.equals(name)) {
            this.color.b = this.toInt(value);
        } else if (ATTR_TAG_COLOR_TRANSPARENT.equals(name)) {
            this.color.transparent = this.toBoolean(value);
        } else if (ATTR_TAG_DISTANCE.equals(name)) {
            this.distance = this.toDouble(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    @Override
    public void setSize(double size) {
        assert (size >= 0.0) : "size is smaller than 0";
        this.size = size;
    }

    @Override
    public void setColor(Color color) {
        assert (color != null) : "color is NULL.";
        this.color = new Color(color);
    }

    @Override
    public void setDistance(double distance) {
        assert (distance >= 0.0) : "distance is less than 0";
        this.distance = distance;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public Color getColor() {
        return new Color(this.color);
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IDotsAppearanceRO)) {
            return;
        }
        IDotsAppearanceRO dots = (IDotsAppearanceRO)appearance;
        this.setColor(dots.getColor());
        this.setDistance(dots.getDistance());
        this.setSize(dots.getSize());
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new DotsAppearance(this);
    }
}

