/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.appearance;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.cm.appearance.CMAppearanceCopier;
import com.arcway.planagent.planmodel.cm.appearance.IDotsAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IDotsAppearanceRO;

public class DotsAppearance
implements IDotsAppearance {
    private static final ILogger logger = Logger.getLogger(DotsAppearance.class);
    private double size = 1.0;
    private Color color = new Color(0, 0, 0);
    private double distance = 5.0;

    public DotsAppearance() {
        if (logger.isDebugEnabled()) {
            logger.trace("DotsAppearance() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("DotsAppearance() - end");
        }
    }

    public DotsAppearance(IDotsAppearanceRO source) {
        if (logger.isDebugEnabled()) {
            logger.trace("DotsAppearance(IDotsAppearance source = " + source + ") - start");
        }
        assert (source != null) : "source object is NULL.";
        CMAppearanceCopier.dots(source, this);
        if (logger.isDebugEnabled()) {
            logger.trace("DotsAppearance(IDotsAppearance) - end");
        }
    }

    @Override
    public void setSize(double size) {
        if (logger.isDebugEnabled()) {
            logger.trace("setSize(double size = " + size + ") - start");
        }
        assert (size >= 0.0) : "size is less than 0";
        this.size = size;
        if (logger.isDebugEnabled()) {
            logger.trace("setSize(double) - end");
        }
    }

    @Override
    public void setColor(Color color) {
        if (logger.isDebugEnabled()) {
            logger.trace("setColor(Color color = " + color + ") - start");
        }
        assert (color != null) : "color is NULL.";
        this.color = new Color(color);
        if (logger.isDebugEnabled()) {
            logger.trace("setColor(Color) - end");
        }
    }

    @Override
    public void setDistance(double distance) {
        if (logger.isDebugEnabled()) {
            logger.trace("setDistance(double distance = " + distance + ") - start");
        }
        assert (distance >= 0.0) : "distance is less than 0";
        this.distance = distance;
        if (logger.isDebugEnabled()) {
            logger.trace("setDistance(double) - end");
        }
    }

    @Override
    public double getSize() {
        if (logger.isDebugEnabled()) {
            logger.trace("getSize() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("getSize() - end - return value = " + this.size);
        }
        return this.size;
    }

    @Override
    public Color getColor() {
        if (logger.isDebugEnabled()) {
            logger.trace("getColor() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("getColor() - end - return value = " + this.color);
        }
        return new Color(this.color);
    }

    @Override
    public double getDistance() {
        if (logger.isDebugEnabled()) {
            logger.trace("getDistance() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("getDistance() - end - return value = " + this.distance);
        }
        return this.distance;
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IDotsAppearanceRO)) {
            return;
        }
        IDotsAppearanceRO dots = (IDotsAppearanceRO)appearance;
        this.setColor(dots.getColor());
        this.setDistance(dots.getDistance());
        this.setSize(dots.getSize());
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new DotsAppearance(this);
    }
}

