/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithCommentSupplementRO;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithCommentSupplementRW;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateTextComment
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private ITextAppearanceRO textAppearance;
    private Points textPoints;
    private int[] textForce;
    private final IPMFigureRW commentFigure;
    private final String commentRole;
    private String text;

    public TACreateTextComment(IPMPlanElementWithCommentSupplementRO planElement, ActionParameters actionParameters, ITextAppearanceRO textAppearance, Points textPoints, String text) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanElementWithCommentSupplementRW)((Object)planElement)), actionParameters);
        this.commentFigure = ((IPMPlanElementWithCommentSupplementRW)((Object)planElement)).getFigureToCommentRW();
        this.commentRole = ((IPMPlanElementWithCommentSupplementRW)((Object)planElement)).getCommentTextRole();
        try {
            if (planElement instanceof IPMPlanElementWithCommentSupplementRO.ICommentAlignmentProvider) {
                TextAppearance modifiedAppearance = new TextAppearance(textAppearance);
                Alignment newAlignment = ((IPMPlanElementWithCommentSupplementRO.ICommentAlignmentProvider)((Object)planElement)).getDefaultCommentAlignment();
                assert (newAlignment != null) : "newAlignment is null";
                modifiedAppearance.setAlignment(newAlignment);
                this.textAppearance = modifiedAppearance;
            } else {
                this.textAppearance = textAppearance;
            }
            this.textPoints = textPoints;
            this.textForce = LineHelper.createAlternatingLineForcesClosed(textPoints);
            this.text = text;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                ACCreateGraphicalSupplementText action = new ACCreateGraphicalSupplementText(this.getActionContext(), this.textPoints, this.textForce, this.commentFigure, this.commentRole, this.textAppearance);
                return action;
            }
            case 1: {
                IPMGraphicalSupplementTextRW textFigure = (IPMGraphicalSupplementTextRW)((ACCreateGraphicalSupplementText)previousActions.get(n - 1)).getGraphicalSupplement();
                return new ACSetTextGraphicalSupplementText(this.getActionContext(), textFigure, this.text);
            }
        }
        return null;
    }
}

