/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCLogicalOperatorRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateBPREEPCLogicalOperatorXOR
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private final double MINIMAL_CORNER_RADIUS = 3.0;
    private Points logicalOperatorPoints;
    private int[] logicalOperatorForce;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fillAppearance;
    private IPMPlanElementBPREEPCLogicalOperatorRO createdLogicalOperator;

    public TACreateBPREEPCLogicalOperatorXOR(IPMPlanRO plan, ActionParameters actionParameters, Points logicalOperatorPoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "ILineAppearance is null";
        this.transactionAssertion(logicalOperatorPoints.size() >= 4, "not enough points describing logical operator figure");
        this.transactionAssertion(lineAppearance.getCornerRadius() >= 3.0, "the opearator's corner radius is too small");
        try {
            this.logicalOperatorPoints = logicalOperatorPoints;
            this.logicalOperatorForce = LineHelper.createAlternatingLineForcesClosed((Points)logicalOperatorPoints);
            this.lineAppearance = lineAppearance;
            this.fillAppearance = fillAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createLogicalOperatorAction();
            }
            case 1: {
                this.createdLogicalOperator = (IPMPlanElementBPREEPCLogicalOperatorRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return null;
    }

    private Action createLogicalOperatorAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "bpre.epc.xor");
    }

    private Action createOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "outline", previousAction.getCreatedPlanElement(), this.logicalOperatorPoints, this.logicalOperatorForce, this.lineAppearance, this.fillAppearance, false);
    }

    public IPMPlanElementBPREEPCLogicalOperatorRO getCreatedLogicalOperator() {
        return this.createdLogicalOperator;
    }

    public String toString() {
        return "TACreateBPREEPCLogicalOperatorXOR (Points " + this.logicalOperatorPoints + ")";
    }
}

