/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.RQDelete;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.InputEvent;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPDelete
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPDelete.class);
    private Request request;
    private final SelectionManager selectionManager;

    public IPDelete(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        this.selectionManager = selectionManager;
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (event instanceof IEKeyDown) {
            IEKeyDown keyEvent = (IEKeyDown)event;
            if (keyEvent.getPressedKey().keyCode == 127) {
                this.handleDelete();
                return 1;
            }
        }
        return 0;
    }

    private void handleDelete() {
        List selectedItems;
        if (logger.isDebugEnabled()) {
            logger.debug(61, "handleDelete() - start");
        }
        if ((selectedItems = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer())).size() > 0) {
            this.request = new RQDelete(selectedItems);
            EditPart item = (EditPart)selectedItems.get(0);
            assert (item instanceof PEPlanEditPart) : "item is not instance of PEPlanEditPart";
            EditPart target = this.getTargetAscending(item);
            if (target != null && target.understandsRequest(this.getRequest())) {
                Command command = target.getCommand(this.getRequest());
                this.executeCommand(command);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(61, "handleDelete() - end");
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }
}

