/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.palette;

import com.arcway.planagent.controllinginterface.planeditor.IPaletteSection;
import com.arcway.planagent.controllinginterface.planeditor.PlanEditorPaletteExtension;
import com.arcway.planagent.controllinginterface.planeditor.plugin.PlanEditorExtensionMgr;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.pagebooks.IPageBookContentProvider;
import com.arcway.planagent.planeditor.pagebooks.palette.PaletteItem;
import com.arcway.planagent.planeditor.pagebooks.palette.PaletteSection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;

public abstract class Palette
implements IPageBookContentProvider {
    private final List<PaletteSection> extendedPaletteSections = new ArrayList<PaletteSection>();
    private final PaletteSection globalElementsList = new PaletteSection(Messages.getString("Palette.global_element"));
    private final PaletteSection connectorsList = new PaletteSection(Messages.getString("Palette.connector"));
    private final PaletteSection zooList = new PaletteSection(Messages.getString("Palette.zoo"));
    private final PaletteSection commentsList = new PaletteSection(Messages.getString("Palette.comment"));
    private boolean isDisposed = false;

    public Palette(String planTypeID) {
        for (PlanEditorPaletteExtension paletteExtension : PlanEditorExtensionMgr.getDefault().getPaletteExtensions(planTypeID)) {
            PaletteSection paletteSection = new PaletteSection(paletteExtension.getSectionTitle());
            paletteExtension.createPaletteItems((IPaletteSection)paletteSection);
            this.extendedPaletteSections.add(paletteSection);
        }
        this.createItems(this.globalElementsList, this.connectorsList, this.zooList, this.commentsList);
    }

    @Override
    public Control createControl(Composite parent) {
        final ScrolledComposite scrollingComposite = new ScrolledComposite(parent, 512);
        scrollingComposite.setBackground(parent.getDisplay().getSystemColor(1));
        scrollingComposite.setLayout((Layout)new FillLayout());
        final ExpandBar bar = new ExpandBar((Composite)scrollingComposite, 0);
        bar.setSpacing(1);
        bar.setBackground(parent.getDisplay().getSystemColor(16));
        for (PaletteSection extendedPaletteSection : this.extendedPaletteSections) {
            Palette.addPaletteSection(bar, extendedPaletteSection);
        }
        Palette.addPaletteSection(bar, this.globalElementsList);
        Palette.addPaletteSection(bar, this.connectorsList);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == 2 && calendar.get(5) == 12 && calendar.get(1) > 2008) {
            Palette.addPaletteSection(bar, this.zooList);
        }
        Palette.addPaletteSection(bar, this.commentsList);
        ControlAdapter controlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrollingComposite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!bar.isDisposed() && !scrollingComposite.isDisposed()) {
                            bar.setSize(bar.computeSize(scrollingComposite.getClientArea().width, -1));
                            ExpandItem[] expandItemArray = bar.getItems();
                            int n = expandItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ExpandItem item = expandItemArray[n2];
                                Composite paletteComposite = (Composite)item.getControl();
                                int height = 0;
                                Control[] controlArray = paletteComposite.getChildren();
                                int n3 = controlArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Control composite = controlArray[n4];
                                    Rectangle bounds = composite.getBounds();
                                    int newHeight = bounds.y + bounds.height;
                                    if (height < newHeight) {
                                        height = newHeight;
                                    }
                                    ++n4;
                                }
                                item.setHeight(height + item.getControl().getBorderWidth() * 2 + 5);
                                ++n2;
                            }
                        }
                    }
                });
            }
        };
        scrollingComposite.addControlListener((ControlListener)controlListener);
        bar.addExpandListener(new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                this.adjustHeight();
            }

            public void itemCollapsed(ExpandEvent e) {
                this.adjustHeight();
            }

            private void adjustHeight() {
                scrollingComposite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        bar.setSize(bar.computeSize(scrollingComposite.getClientArea().width, -1));
                    }
                });
            }
        });
        scrollingComposite.setContent((Control)bar);
        controlListener.controlResized(null);
        return scrollingComposite;
    }

    private static void addPaletteSection(ExpandBar bar, PaletteSection section) {
        List<PaletteItem> elements = section.getItems();
        if (!elements.isEmpty()) {
            String title = section.getTitle();
            Composite barContentComposite = new Composite((Composite)bar, 0);
            barContentComposite.setBackground(bar.getDisplay().getSystemColor(1));
            RowLayout layout = new RowLayout(256);
            layout.marginLeft = 2;
            layout.marginTop = 2;
            layout.marginRight = 2;
            layout.marginBottom = 2;
            layout.spacing = 1;
            barContentComposite.setLayout((Layout)layout);
            for (PaletteItem paletteItem : elements) {
                Control itemControl = paletteItem.createControl(barContentComposite);
                itemControl.setLayoutData((Object)new RowData(78, 64));
            }
            ExpandItem item = new ExpandItem(bar, 0);
            item.setExpanded(true);
            item.setText(title);
            item.setHeight(barContentComposite.computeSize((int)bar.getParent().getParent().getClientArea().width, (int)-1).y);
            item.setControl((Control)barContentComposite);
        }
    }

    protected abstract void createItems(PaletteSection var1, PaletteSection var2, PaletteSection var3, PaletteSection var4);

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

