/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Dimension;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialogSettings;

public class SaveAsPNGDialogSettings
extends AbstractSaveAsDialogSettings {
    public static final int MODE_RESOLUTION = 0;
    public static final int MODE_HEIGHT = 1;
    public static final int MODE_WIDTH = 2;
    public static final int MODE_BOTH_DIMENSIONS = 3;
    private double horizontalDPI;
    private double verticalDPI;
    private int widthPxl;
    private int heightPxl;
    private int mode;
    private boolean transparentBackground;

    public SaveAsPNGDialogSettings(SaveAsPNGDialogSettings copyFrom) {
        this.copyFrom(copyFrom);
    }

    public SaveAsPNGDialogSettings() {
        this.setMode(0);
        this.setHorizontalDPI(169.33333333333334);
        this.setVerticalDPI(169.33333333333334);
        this.setHeightPxl(300);
        this.setWidthPxl(300);
        this.setBackgroundTransparent(false);
    }

    public void copyFrom(SaveAsPNGDialogSettings copyFrom) {
        super.copyFrom(copyFrom);
        this.heightPxl = copyFrom.heightPxl;
        this.widthPxl = copyFrom.widthPxl;
        this.horizontalDPI = copyFrom.horizontalDPI;
        this.verticalDPI = copyFrom.verticalDPI;
        this.mode = copyFrom.mode;
        this.transparentBackground = copyFrom.transparentBackground;
    }

    public void setDimensionsForResolution(Dimension planDimension) {
        this.heightPxl = (int)(planDimension.height * this.verticalDPI / 25.4);
        this.widthPxl = (int)(planDimension.width * this.horizontalDPI / 25.4);
    }

    public void setWidthForHeight(Dimension planDimension) {
        this.widthPxl = (int)Math.ceil(planDimension.width * (double)this.heightPxl / planDimension.height);
    }

    public void setHeightForWidth(Dimension planDimension) {
        this.heightPxl = (int)Math.ceil(planDimension.height * (double)this.widthPxl / planDimension.width);
    }

    public void setResolutionForDimensions(Dimension planDimension) {
        double dpi;
        double maxHorizontalDPI = 25.4 * (double)this.widthPxl / planDimension.width;
        double maxVerticalDPI = 25.4 * (double)this.heightPxl / planDimension.height;
        this.verticalDPI = dpi = Math.min(maxHorizontalDPI, maxVerticalDPI);
        this.horizontalDPI = dpi;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getHeightPxl() {
        return this.heightPxl;
    }

    public double getHorizontalDPI() {
        return this.horizontalDPI;
    }

    public double getVerticalDPI() {
        return this.verticalDPI;
    }

    public int getWidthPxl() {
        return this.widthPxl;
    }

    public void setHeightPxl(int i) {
        this.heightPxl = i;
    }

    public void setHorizontalDPI(double d) {
        this.horizontalDPI = d;
    }

    public void setVerticalDPI(double d) {
        this.verticalDPI = d;
    }

    public void setWidthPxl(int i) {
        this.widthPxl = i;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isBackgroundTransparent() {
        return this.transparentBackground;
    }

    public void setBackgroundTransparent(boolean transparent) {
        this.transparentBackground = transparent;
    }
}

