/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayTitleAreaDialog;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Insets;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.PrintPlotterHelpCanvas;
import de.plans.lib.util.LocalisationUtils;
import java.text.ParseException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PlotterHelpDialog
extends ArcwayTitleAreaDialog {
    private static final String UNIT = Messages.getString("PlotterHelpDialog.mm");
    private static double formWidthPreference = Geo.DIN_A0_IN_MM.height;
    private final IPlanBoundsCalculator planBoundsCalculator;
    private final Insets margins;
    private final String[] sizes;
    private Button buttonCustomWidth;
    private Button buttonCustomHeight;
    private Combo comboCustomWidth;
    private Combo comboCustomHeight;
    private Composite previewContainer;
    private PrintPlotterHelpCanvas preview;
    private double givenFormWidth = formWidthPreference;
    private boolean givenRotation;
    private double calculatedFormLength;
    private boolean calculatedIsLandscape;

    protected PlotterHelpDialog(Shell parentShell, IPlanBoundsCalculator planBoundsCalculator, Insets margins, Dimension paperSizeHint) {
        super(parentShell, false);
        this.sizes = new String[]{String.valueOf(LocalisationUtils.roundLocalized((double)Geo.DIN_A0_IN_MM.width, (int)0, (boolean)false)) + " (DIN A0)", String.valueOf(LocalisationUtils.roundLocalized((double)1066.8, (int)0, (boolean)false)) + " (42\")", String.valueOf(LocalisationUtils.roundLocalized((double)Geo.DIN_A0_IN_MM.height, (int)0, (boolean)false)) + " (DIN A1)", String.valueOf(LocalisationUtils.roundLocalized((double)(Geo.DIN_A0_IN_MM.width / 2.0), (int)0, (boolean)false)) + " (DIN A2)", String.valueOf(LocalisationUtils.roundLocalized((double)(Geo.DIN_A0_IN_MM.height / 2.0), (int)0, (boolean)false)) + " (DIN A3)", String.valueOf(LocalisationUtils.roundLocalized((double)(Geo.DIN_A0_IN_MM.width / 4.0), (int)0, (boolean)false)) + " (DIN A4)", String.valueOf(LocalisationUtils.roundLocalized((double)(Geo.DIN_A0_IN_MM.height / 4.0), (int)0, (boolean)false)) + " (DIN A5)", String.valueOf(LocalisationUtils.roundLocalized((double)paperSizeHint.width, (int)0, (boolean)false)) + Messages.getString("PlotterHelpDialog.printerWidth"), String.valueOf(LocalisationUtils.roundLocalized((double)paperSizeHint.height, (int)0, (boolean)false)) + Messages.getString("PlotterHelpDialog.printerHeight")};
        this.planBoundsCalculator = planBoundsCalculator;
        this.margins = margins;
        this.givenRotation = true;
        this.setFormWidth(Geo.DIN_A0_IN_MM.height);
        double areaWithSwappedRotation = this.givenFormWidth * this.calculatedFormLength;
        this.givenRotation = !this.givenRotation;
        this.setFormWidth(Geo.DIN_A0_IN_MM.height);
        double areaWithGivenRotation = this.givenFormWidth * this.calculatedFormLength;
        if (areaWithSwappedRotation > areaWithGivenRotation + 1.0E-10) {
            this.givenRotation = !this.givenRotation;
            this.setFormWidth(Geo.DIN_A0_IN_MM.height);
        }
        this.setBlockOnOpen(true);
    }

    protected void dispose() {
    }

    private void setFormWidth(double newFormWidth) {
        this.givenFormWidth = newFormWidth = Math.min(1000000.0, Math.max(newFormWidth, 50.0));
        this.updateFormSize();
        this.updateWidgetsRotationOrLandscape();
    }

    private void setRotation(boolean newRotation) {
        if (newRotation != this.givenRotation) {
            this.givenRotation = newRotation;
            this.updateFormSize();
            this.updateWidgetsRotation();
            this.updateWidgetsRotationOrLandscape();
        }
    }

    private void updateFormSize() {
        if (!this.givenRotation) {
            double pageHeight;
            double pageWidth = this.givenFormWidth;
            this.calculatedFormLength = pageHeight = this.calculatePageHeight(pageWidth);
            this.calculatedIsLandscape = pageWidth > pageHeight + 1.0E-10;
        } else {
            double pageWidth;
            double pageHeight = this.givenFormWidth;
            this.calculatedFormLength = pageWidth = this.calculatePageWidth(pageHeight);
            this.calculatedIsLandscape = pageWidth > pageHeight + 1.0E-10;
        }
    }

    private double calculatePageWidth(double pageHeight) {
        double planHeight = pageHeight - this.margins.upperInset - this.margins.lowerInset;
        double planWidth = this.planBoundsCalculator.calculatePlanWidth(planHeight);
        double pageWidth = planWidth + this.margins.leftInset + this.margins.rightInset;
        return pageWidth;
    }

    private double calculatePageHeight(double pageWidth) {
        double planWidth = pageWidth - this.margins.leftInset - this.margins.rightInset;
        double planHeight = this.planBoundsCalculator.calculatePlanHeight(planWidth);
        double pageHeight = planHeight + this.margins.upperInset + this.margins.lowerInset;
        return pageHeight;
    }

    private void updateWidgetsRotation() {
        if (this.buttonCustomWidth != null) {
            this.buttonCustomWidth.setSelection(!this.givenRotation);
        }
        if (this.buttonCustomHeight != null) {
            this.buttonCustomHeight.setSelection(this.givenRotation);
        }
    }

    private void updateWidgetsRotationOrLandscape() {
        if (this.preview != null) {
            this.preview.setNewValues(this.createPreviewImage(), this.givenRotation, !this.calculatedIsLandscape);
        }
    }

    private Image createPreviewImage() {
        Dimension paperSize = !this.givenRotation ? new Dimension(this.givenFormWidth, this.calculatedFormLength) : new Dimension(this.calculatedFormLength, this.givenFormWidth);
        com.arcway.lib.graphics.image.Image previewImage = this.planBoundsCalculator.createPreviewImage(paperSize, PrintPlotterHelpCanvas.PREVIEW_SIZE);
        return ((SWTOffscreenBitmap)previewImage.getOffscreenBitmap()).getWrappedSWTImage();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = id == 0 ? super.createButton(parent, id, Messages.getString("PlotterHelpDialog.copyAndOk"), defaultButton) : (id == 1 ? super.createButton(parent, id, Messages.getString("PlotterHelpDialog.close"), defaultButton) : super.createButton(parent, id, label, defaultButton));
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("PlotterHelpDialog.title"));
        this.setTitle(Messages.getString("PlotterHelpDialog.secondtitle"));
        Composite globalArea = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        globalArea.setLayoutData((Object)gridData);
        globalArea.setLayout((Layout)gridLayout);
        Composite widthGroup = new Composite(globalArea, 0);
        gridData = new GridData(4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        widthGroup.setLayoutData((Object)gridData);
        widthGroup.setLayout((Layout)gridLayout);
        this.buttonCustomHeight = new Button(widthGroup, 16);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.buttonCustomHeight.setLayoutData((Object)gridData);
        this.updateWidgetsRotation();
        this.comboCustomHeight = new Combo(widthGroup, 4);
        this.comboCustomHeight.setItems(this.sizes);
        this.comboCustomHeight.setText(this.createFormWidthText(this.givenFormWidth));
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.comboCustomHeight.setLayoutData((Object)gridData);
        Label labelCustomWidth = new Label(widthGroup, 16);
        labelCustomWidth.setText(UNIT);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        labelCustomWidth.setLayoutData((Object)gridData);
        this.previewContainer = new Composite(globalArea, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 1;
        this.previewContainer.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.previewContainer.setLayout((Layout)gridLayout);
        this.preview = new PrintPlotterHelpCanvas(this.previewContainer, this.createPreviewImage(), 0, this.givenRotation, !this.calculatedIsLandscape);
        this.preview.setBackground(Display.getCurrent().getSystemColor(16));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 1;
        this.preview.setLayoutData(gridData);
        this.updateWidgetsRotationOrLandscape();
        Label dummy = new Label(globalArea, 16);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        dummy.setLayoutData((Object)gridData);
        Composite heightGroup = new Composite(globalArea, 0);
        gridData = new GridData(64);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        heightGroup.setLayoutData((Object)gridData);
        heightGroup.setLayout((Layout)gridLayout);
        this.buttonCustomWidth = new Button(heightGroup, 16);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.buttonCustomWidth.setLayoutData((Object)gridData);
        this.updateWidgetsRotation();
        this.comboCustomWidth = new Combo(heightGroup, 4);
        this.comboCustomWidth.setItems(this.sizes);
        this.comboCustomWidth.setText(this.createFormWidthText(this.givenFormWidth));
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.comboCustomWidth.setLayoutData((Object)gridData);
        Label labelCustomHeight = new Label(heightGroup, 16);
        labelCustomHeight.setText(UNIT);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        labelCustomHeight.setLayoutData((Object)gridData);
        this.refresh();
        this.buttonCustomWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PlotterHelpDialog.this.buttonCustomWidth.getSelection() && PlotterHelpDialog.this.buttonCustomHeight.getSelection()) {
                    PlotterHelpDialog.this.swap();
                    PlotterHelpDialog.this.buttonCustomHeight.setSelection(false);
                }
                PlotterHelpDialog.this.refresh();
            }
        });
        this.comboCustomWidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PlotterHelpDialog.this.comboCustomWidth.isEnabled()) {
                    PlotterHelpDialog.this.refresh();
                }
            }
        });
        this.buttonCustomHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PlotterHelpDialog.this.buttonCustomWidth.getSelection() && PlotterHelpDialog.this.buttonCustomHeight.getSelection()) {
                    PlotterHelpDialog.this.swap();
                    PlotterHelpDialog.this.buttonCustomWidth.setSelection(false);
                }
                PlotterHelpDialog.this.refresh();
            }
        });
        this.comboCustomHeight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PlotterHelpDialog.this.comboCustomHeight.isEnabled()) {
                    PlotterHelpDialog.this.refresh();
                }
            }
        });
        return globalArea;
    }

    private String createFormWidthText(double formWidth) {
        double comparableFormWidth = this.parseFormWidthText(LocalisationUtils.roundLocalized((double)formWidth, (int)0, (boolean)false));
        if (formWidth > 1.0E-10) {
            String[] stringArray = this.sizes;
            int n = this.sizes.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                double currentFormWidth = this.parseFormWidthText(element);
                if (Geo.equals((double)currentFormWidth, (double)comparableFormWidth)) {
                    return element;
                }
                ++n2;
            }
        }
        return LocalisationUtils.roundLocalized((double)formWidth, (int)0, (boolean)false);
    }

    private double parseFormWidthText(String formWidthText) {
        try {
            return LocalisationUtils.parseDoubleLocalized((String)formWidthText);
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    private void swap() {
        this.comboCustomWidth.setEnabled(false);
        this.comboCustomHeight.setEnabled(false);
        String tmp = this.comboCustomHeight.getText();
        this.comboCustomHeight.setText(this.comboCustomWidth.getText());
        this.comboCustomWidth.setText(tmp);
    }

    private void refresh() {
        this.readWidgetValues();
        this.updateSettings();
        this.writeWidgetValues();
    }

    private void readWidgetValues() {
        boolean newRotation = this.buttonCustomHeight.getSelection();
        if (newRotation != this.givenRotation) {
            this.setRotation(newRotation);
        }
    }

    private void updateSettings() {
        double newFormWidth = !this.givenRotation ? this.parseFormWidthText(this.comboCustomWidth.getText()) : this.parseFormWidthText(this.comboCustomHeight.getText());
        if (!Geo.equals((double)newFormWidth, (double)this.givenFormWidth)) {
            this.setFormWidth(newFormWidth);
        }
        formWidthPreference = this.givenFormWidth;
    }

    private void writeWidgetValues() {
        String rotation;
        this.comboCustomWidth.setEnabled(!this.givenRotation);
        this.comboCustomHeight.setEnabled(this.givenRotation);
        String width = String.valueOf(this.createFormWidthText(this.givenFormWidth)) + " " + UNIT;
        String height = String.valueOf(this.createFormWidthText(this.calculatedFormLength)) + " " + UNIT;
        if (!this.givenRotation) {
            this.comboCustomHeight.setText(LocalisationUtils.roundLocalized((double)this.calculatedFormLength, (int)0, (boolean)false));
            rotation = Messages.getString("PlotterHelpDialog.rotation0");
        } else {
            this.comboCustomWidth.setText(LocalisationUtils.roundLocalized((double)this.calculatedFormLength, (int)0, (boolean)false));
            rotation = Messages.getString("PlotterHelpDialog.rotation90");
        }
        String message = String.valueOf(Messages.getString("PlotterHelpDialog.info")) + width + " x " + height + " (" + rotation + ")";
        this.setMessage(message, 1);
    }

    protected void okPressed() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        Object[] data = new Object[]{LocalisationUtils.roundLocalizedWithoutGrouping((double)this.calculatedFormLength, (int)0, (boolean)false)};
        Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(data, dataTypes);
        clipboard.dispose();
        super.okPressed();
    }

    public static interface IPlanBoundsCalculator {
        public com.arcway.lib.graphics.image.Image createPreviewImage(Dimension var1, int var2);

        public double calculatePlanWidth(double var1);

        public double calculatePlanHeight(double var1);
    }
}

