/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.planagent.planeditor.commands.AbstractCommand;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class TransactionCommand
extends AbstractCommand {
    private Transaction transaction = null;

    protected TransactionCommand(ICommandContext commandContext) {
        super(commandContext);
    }

    protected void construct(String label, Transaction transactionToExecute) {
        super.construct(label);
        this.transaction = null;
        if (transactionToExecute != null && transactionToExecute.isValid()) {
            this.transaction = transactionToExecute;
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    protected ActionParameters getActionParameters() {
        return this.getCommandContext().getActionParameters();
    }

    @Override
    public boolean canExecuteInGeneral() {
        return this.transaction != null;
    }

    @Override
    protected boolean makesPlanRelatedChanges() {
        return true;
    }

    @Override
    public void executeNow() {
        this.transaction.dodo();
    }

    @Override
    protected boolean canUndoNow() {
        return true;
    }

    @Override
    public void undoNow() {
        this.transaction.undo();
    }

    protected void addContainedPlanElements(Collection<IPMPlanElementRO> pmPlanElements) {
        if (!pmPlanElements.isEmpty()) {
            IPMPlanRO plan = pmPlanElements.iterator().next().getPlanRO();
            Set pmPlanElementsWithContained = plan.getAllContained(pmPlanElements);
            pmPlanElements.clear();
            pmPlanElements.addAll(pmPlanElementsWithContained);
        }
    }

    protected void addContainedFigures(Collection<IPMFigureRO> pmFigures) {
        Set<IPMPlanElementRO> planElementsWithoutContained = TransactionCommand.getRelatedPlanElements(pmFigures);
        TransactionCommand.filterSingleFigureElements(planElementsWithoutContained);
        ArrayList<IPMPlanElementRO> planElementsWithContained = new ArrayList<IPMPlanElementRO>(planElementsWithoutContained);
        this.addContainedPlanElements(planElementsWithContained);
        HashSet<IPMPlanElementRO> containedPlanElements = new HashSet<IPMPlanElementRO>(planElementsWithContained);
        containedPlanElements.removeAll(planElementsWithoutContained);
        TransactionCommand.addFigures(pmFigures, containedPlanElements);
    }

    private static void filterSingleFigureElements(Collection<IPMPlanElementRO> elements) {
        Iterator<IPMPlanElementRO> i = elements.iterator();
        while (i.hasNext()) {
            IPMPlanElementRO planElement = i.next();
            if (planElement.getEditIPMFiguresRO().size() <= 1) continue;
            i.remove();
        }
    }

    private static Set<IPMPlanElementRO> getRelatedPlanElements(Collection<IPMFigureRO> pmFigures) {
        HashSet<IPMPlanElementRO> planElements = new HashSet<IPMPlanElementRO>(pmFigures.size());
        for (IPMFigureRO figure : pmFigures) {
            planElements.add(figure.getPlanElementRO());
        }
        return planElements;
    }

    private static void addFigures(Collection<IPMFigureRO> pmFigures, Collection<IPMPlanElementRO> pmPlanElements) {
        for (IPMPlanElementRO planElement : pmPlanElements) {
            int figureCount = planElement.getFigureCount();
            int figureIdx = 0;
            while (figureIdx < figureCount) {
                IPMFigureRO figure = planElement.getFigureRO(figureIdx);
                pmFigures.add(figure);
                ++figureIdx;
            }
        }
    }
}

