/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.commands.Command;

public abstract class AbstractCommand
extends Command
implements IPlanEditorCommand {
    private final ICommandContext commandContext;
    private IPlanEditorControllerCommand editorMgrCommand = null;
    public static final int TYPE_NONE = 1;
    public static final int TYPE_COMMON = 2;
    public static final int TYPE_DRAW = 3;
    public static final int TYPE_MOVE_ENTITIY = 4;
    public static final int TYPE_MOVE = 5;
    public static final int TYPE_MOVE_IN_PROGRESS = 6;
    public static final int TYPE_MOVE_HORIZONTAL = 7;
    public static final int TYPE_MOVE_VERTICAL = 8;
    public static final int TYPE_MOVE_DIAGONAL_UL2LR = 9;
    public static final int TYPE_MOVE_DIAGONAL_LL2UR = 10;
    public static final int TYPE_MODE_COPY = Integer.MIN_VALUE;

    protected AbstractCommand(ICommandContext commandContext) {
        assert (commandContext != null) : "commandContext is null";
        this.commandContext = commandContext;
    }

    protected void construct(String label) {
        this.setLabel(label);
    }

    protected ICommandContext getCommandContext() {
        return this.commandContext;
    }

    protected IPlanEditorControllerExtension getEditorController() {
        return this.getCommandContext().getEditorController();
    }

    public void setMgrCommand(IPlanEditorControllerCommand editorMgrCommand) {
        this.editorMgrCommand = editorMgrCommand;
    }

    public final boolean canExecute() {
        boolean canExecute = this.canExecuteInGeneral();
        if (canExecute && this.editorMgrCommand != null) {
            canExecute &= this.editorMgrCommand.canExecuteInGeneral();
        }
        return canExecute;
    }

    public boolean executeOnCommandStack() {
        boolean executeOnCommandStack = this.makesPlanRelatedChanges();
        if (!executeOnCommandStack && this.editorMgrCommand != null) {
            executeOnCommandStack |= this.editorMgrCommand.makesPlanRelatedChanges();
        }
        return executeOnCommandStack;
    }

    public final void execute() {
        this.executeNow();
        if (this.editorMgrCommand != null) {
            try {
                this.editorMgrCommand.execute();
            }
            catch (Throwable e) {
                this.undoNow();
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public final boolean canUndo() {
        boolean canUndo = this.canUndoNow();
        if (canUndo && this.editorMgrCommand != null) {
            canUndo &= this.editorMgrCommand.canUndoNow();
        }
        return canUndo;
    }

    public final void undo() {
        this.undoNow();
        if (this.editorMgrCommand != null) {
            this.editorMgrCommand.undo();
        }
    }

    public final void redo() {
        this.redoNow();
        if (this.editorMgrCommand != null) {
            this.editorMgrCommand.redo();
        }
    }

    protected abstract boolean canExecuteInGeneral();

    public boolean canExecuteNow() {
        boolean canExecute = this.canExecute();
        if (canExecute && this.editorMgrCommand != null) {
            canExecute &= this.editorMgrCommand.canExecuteNow();
        }
        return canExecute;
    }

    protected abstract boolean makesPlanRelatedChanges();

    public abstract void executeNow();

    protected abstract boolean canUndoNow();

    public abstract void undoNow();

    public void redoNow() {
        this.executeNow();
    }

    protected List getFilteredPMItems(List rawItems, Class expectedPMType) {
        ArrayList<Object> filteredItems = new ArrayList<Object>(rawItems.size());
        for (Object currentItem : rawItems) {
            assert (currentItem instanceof PEPlanEditPart) : "item is not an instance of PEPlanEditPart";
            Object model = ((PEPlanEditPart)currentItem).getModel();
            if (expectedPMType.isInstance(model)) {
                filteredItems.add(model);
                continue;
            }
            filteredItems.clear();
            break;
        }
        return filteredItems;
    }

    protected List getRelatedPMPlanElements(List rawItems, Class expectedPMType) {
        HashSet<PEPlanEditPart> pEPlanElements = new HashSet<PEPlanEditPart>(rawItems.size());
        for (Object currentItem : rawItems) {
            PEFigure pEFigure;
            PEPlanElement planElement;
            assert (currentItem instanceof PEPlanEditPart) : "item is not an instance of PEPlanEditPart";
            PEPlanEditPart planEditPart = (PEPlanEditPart)currentItem;
            if (planEditPart instanceof PEPlanElement) {
                pEPlanElements.add(planEditPart);
                continue;
            }
            if (!(planEditPart instanceof PEFigure) || (planElement = (pEFigure = (PEFigure)planEditPart).getPEPlanElement()).getEditFigure() != pEFigure) continue;
            pEPlanElements.add(planElement);
        }
        ArrayList<Object> pMPlanElements = new ArrayList<Object>(pEPlanElements.size());
        for (PEPlanEditPart planEditPart : rawItems) {
            Object modelObject = planEditPart.getModel();
            boolean toAdd = true;
            if (expectedPMType != null) {
                toAdd &= expectedPMType.isInstance(modelObject);
            }
            if (!toAdd) continue;
            pMPlanElements.add(modelObject);
        }
        return pMPlanElements;
    }
}

