/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.gui.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.gui.Messages;
import com.arcway.planagent.planeditor.gui.actions.UIAbstractGUICheckBoxAction;
import com.arcway.planagent.planeditor.gui.commands.CMCreateCheckBoxActiveSupplement;
import com.arcway.planagent.planmodel.gui.access.readonly.IPMPlanElementGUICheckBoxRO;
import com.arcway.planagent.planmodel.gui.access.readwrite.IPMPlanElementGUICheckBoxRW;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class UICreateGUICheckBoxActiveSupplementAction
extends UIAbstractGUICheckBoxAction {
    private static final ILogger logger = Logger.getLogger(UICreateGUICheckBoxActiveSupplementAction.class);
    private static final String ID = "de.plans.fmca.planagent.planeditor.gui.actions.uicreatecheckboxactivesupplement";

    public UICreateGUICheckBoxActiveSupplementAction(ContextMenuContext context) {
        super(context);
        if (logger.isTraceEnabled()) {
            logger.trace("UICreateCheckBoxActiveSupplementAction(ContextMenuContext context = " + context + ") - start");
        }
        this.setText(Messages.getString("UICreateCheckBoxActiveSupplementAction.Create_ActiveSupplement"));
        this.setToolTipText(Messages.getString("UICreateCheckBoxActiveSupplementAction.Creates_ActiveSupplement"));
        this.setId(ID);
        if (logger.isTraceEnabled()) {
            logger.trace("UICreateCheckBoxActiveSupplementAction(ContextMenuContext) - end");
        }
    }

    protected boolean calculateEnabled() {
        boolean toReturn = false;
        IPMPlanElementGUICheckBoxRO planElement = this.getSelectedCheckBox();
        if (planElement != null && planElement.getCheckBoxActiveSupplementRO() == null) {
            toReturn = true;
        }
        return toReturn;
    }

    protected Command getCommand(List<PEPlanElement> items) {
        IPMPlanElementGUICheckBoxRO planElement;
        assert (items != null) : "items is null";
        if (this.calculateEnabled() && !items.isEmpty() && (planElement = this.getSelectedCheckBox(items)) != null) {
            return new CMCreateCheckBoxActiveSupplement((IPMPlanElementGUICheckBoxRW)planElement, super.getCommandContext());
        }
        return null;
    }

    protected boolean isVisibleIfDisabled() {
        return false;
    }

    protected boolean isVisibleInProjectionMode() {
        return false;
    }
}

