/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import com.arcway.planagent.planeditor.cm.actions.TextFontDecoration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class CITextFont
extends MenuContributionItem {
    public static final String initFont = "Arial";
    private static ArrayList<String> sortedFontList = new ArrayList();
    private static final IAppearanceButtonDecoration buttonType;

    static {
        FontData[] fontData = Display.getDefault().getFontList(null, true);
        HashSet<String> fontSet = new HashSet<String>();
        int i = 0;
        while (i < fontData.length) {
            if (!("".equals(fontData[i].getName()) || fontData[i].getName().startsWith("@") || fontData[i].getName().startsWith("Comic"))) {
                fontSet.add(fontData[i].getName());
            }
            ++i;
        }
        ArrayList fontList = new ArrayList(fontSet);
        Collections.sort(fontList);
        sortedFontList = fontList;
        buttonType = TextFontDecoration.getInstance();
    }

    public CITextFont() {
    }

    public CITextFont(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected IAppearanceButtonDecoration getButtonType() {
        return buttonType;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, initFont);
        ArrayList selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> fontItems = new ArrayList<IContributionItem>();
        ArrayList<String> fontListWithDummy = new ArrayList<String>(sortedFontList);
        fontListWithDummy.add("dummy");
        String[] previousParts = new String[]{};
        String previousName = "";
        MenuManager currentSubMenu = null;
        boolean firsttime = true;
        for (String currentFontName : fontListWithDummy) {
            int j;
            String[] fontNameParts = currentFontName.split(" ");
            if (fontNameParts[0].length() <= 2) {
                String[] newFontNameParts = new String[fontNameParts.length - 1];
                newFontNameParts[0] = String.valueOf(fontNameParts[0]) + " " + fontNameParts[1];
                j = 1;
                while (j < newFontNameParts.length) {
                    newFontNameParts[j] = fontNameParts[j + 1];
                    ++j;
                }
                fontNameParts = newFontNameParts;
            }
            int countMatch = 0;
            j = 0;
            while (j < previousParts.length && j < fontNameParts.length) {
                if (previousParts[j].equals(fontNameParts[j])) {
                    ++countMatch;
                }
                ++j;
            }
            if (!firsttime) {
                if (countMatch == 0) {
                    ActionContributionItem item;
                    boolean checked;
                    ImageDescriptor imageDescriptor;
                    UIChangeAppearanceAction action;
                    if (currentSubMenu != null) {
                        action = new UIChangeAppearanceAction(workbenchPage, previousName, previousName, (Object)previousName, buttonType);
                        imageDescriptor = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryImage((Object)previousName);
                        action.setImageDescriptor(imageDescriptor);
                        action.setEnabled(enabled);
                        checked = this.isActionChecked(previousName, selectedStates);
                        action.setChecked(checked);
                        item = new ActionContributionItem((IAction)action);
                        currentSubMenu.add((IContributionItem)item);
                        fontItems.add((IContributionItem)currentSubMenu);
                    } else {
                        action = new UIChangeAppearanceAction(workbenchPage, previousName, previousName, (Object)previousName, buttonType);
                        imageDescriptor = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryImage((Object)previousName);
                        action.setImageDescriptor(imageDescriptor);
                        action.setEnabled(enabled);
                        checked = false;
                        if (enabled) {
                            checked = this.isActionChecked(previousName, selectedStates);
                        }
                        action.setChecked(checked);
                        item = new ActionContributionItem((IAction)action);
                        fontItems.add((IContributionItem)item);
                    }
                    currentSubMenu = null;
                } else {
                    StringBuilder matchingParts = new StringBuilder();
                    int j2 = 0;
                    while (j2 < countMatch) {
                        matchingParts.append(previousParts[j2]);
                        matchingParts.append(" ");
                        ++j2;
                    }
                    if (currentSubMenu == null) {
                        currentSubMenu = new MenuManager(matchingParts.toString());
                    }
                    UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, previousName, previousName, (Object)previousName, buttonType);
                    ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryImage((Object)previousName);
                    action.setImageDescriptor(imageDescriptor);
                    action.setEnabled(enabled);
                    boolean checked = this.isActionChecked(previousName, selectedStates);
                    action.setChecked(checked);
                    ActionContributionItem item = new ActionContributionItem((IAction)action);
                    currentSubMenu.add((IContributionItem)item);
                }
            }
            previousName = currentFontName;
            previousParts = fontNameParts;
            firsttime = false;
        }
        return fontItems;
    }

    private boolean isActionChecked(String font, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            String selectedFont;
            if (state instanceof String && (checked = font.equals(selectedFont = (String)state))) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> fontItems = this.constructContributionItem();
        IContributionItem[] items = fontItems.toArray(new IContributionItem[fontItems.size()]);
        return items;
    }
}

