/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.base.edit;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithCommentSupplementRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;

public class CommentTools {
    private static final double DEFAULT_COMMENT_WIDTH = 20.0;

    public static Points calculateCommentAreaSuggestion(IPMPlanElementWithCommentSupplementRO element, IPMFigureLineShapeRO figure) {
        return CommentTools.calculateCommentAreaSuggestion(element.getCommentRO(), figure);
    }

    public static Points calculateEndCardinalityAreaSuggestion(IPMPlanElementWithCommentSupplementRO element, IPMFigureLineShapeRO figure) {
        return CommentTools.calculateEndCardinalityAreaSuggestion(element.getCommentRO(), figure);
    }

    public static Points calculateStartCardinalityAreaSuggestion(IPMPlanElementWithCommentSupplementRO element, IPMFigureLineShapeRO figure) {
        return CommentTools.calculateStartCardinalityAreaSuggestion(element.getCommentRO(), figure);
    }

    public static Points calculateCommentAreaSuggestion(IPMGraphicalSupplementTextRO comment, IPMFigureLineShapeRO figure) {
        boolean horizontal;
        double width = 20.0;
        double height = -20.0;
        if (comment != null) {
            IPMPointListRO commentPoints = comment.getPointListRO();
            double miny = Double.POSITIVE_INFINITY;
            double maxy = Double.NEGATIVE_INFINITY;
            double minx = Double.POSITIVE_INFINITY;
            double maxx = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < commentPoints.getPointCount()) {
                if (commentPoints.getPointRO((int)i).getPosition().y < miny) {
                    miny = commentPoints.getPointRO((int)i).getPosition().y;
                }
                if (commentPoints.getPointRO((int)i).getPosition().y > maxy) {
                    maxy = commentPoints.getPointRO((int)i).getPosition().y;
                }
                if (commentPoints.getPointRO((int)i).getPosition().x < minx) {
                    minx = commentPoints.getPointRO((int)i).getPosition().x;
                }
                if (commentPoints.getPointRO((int)i).getPosition().x > maxx) {
                    maxx = commentPoints.getPointRO((int)i).getPosition().x;
                }
                ++i;
            }
            height = maxy - miny;
            width = maxx - minx;
        }
        Points points = new Points(4);
        IPMFigureLineShapeRO line = figure;
        IPMPointRO upperPoint = line.getPointListRO().getPointRO(0);
        IPMPointRO lowerPoint = line.getPointListRO().getPointRO(1);
        if (upperPoint.getPosition().y > lowerPoint.getPosition().y) {
            IPMPointRO t = upperPoint;
            upperPoint = lowerPoint;
            lowerPoint = t;
        }
        if ((horizontal = Geo.equals((double)upperPoint.getPosition().y, (double)lowerPoint.getPosition().y)) && upperPoint.getPosition().x > lowerPoint.getPosition().x) {
            IPMPointRO t = upperPoint;
            upperPoint = lowerPoint;
            lowerPoint = t;
        }
        if (horizontal) {
            width = lowerPoint.getPosition().x - upperPoint.getPosition().x;
        } else {
            height = lowerPoint.getPosition().y - upperPoint.getPosition().y;
        }
        points.add(new Point(upperPoint.getPosition().x, upperPoint.getPosition().y));
        points.add(new Point(upperPoint.getPosition().x + width, upperPoint.getPosition().y));
        points.add(new Point(upperPoint.getPosition().x + width, upperPoint.getPosition().y + height));
        points.add(new Point(upperPoint.getPosition().x, upperPoint.getPosition().y + height));
        return points;
    }

    public static Points calculateEndCardinalityAreaSuggestion(IPMGraphicalSupplementTextRO comment, IPMFigureLineShapeRO figure) {
        boolean horizontal;
        double width = -10.0;
        double height = -10.0;
        Points points = new Points(4);
        IPMFigureLineShapeRO line = figure;
        int pointCount = line.getPointListRO().getPointCount();
        IPMPointRO upperPoint = line.getPointListRO().getPointRO(pointCount - 2);
        IPMPointRO lowerPoint = line.getPointListRO().getPointRO(pointCount - 1);
        if (upperPoint.getPosition().y > lowerPoint.getPosition().y) {
            height *= -1.0;
        }
        if ((horizontal = Geo.equals((double)upperPoint.getPosition().y, (double)lowerPoint.getPosition().y)) && upperPoint.getPosition().x > lowerPoint.getPosition().x) {
            width *= -1.0;
        }
        points.add(new Point(lowerPoint.getPosition().x, lowerPoint.getPosition().y));
        points.add(new Point(lowerPoint.getPosition().x + width, lowerPoint.getPosition().y));
        points.add(new Point(lowerPoint.getPosition().x + width, lowerPoint.getPosition().y + height));
        points.add(new Point(lowerPoint.getPosition().x, lowerPoint.getPosition().y + height));
        return points;
    }

    public static Points calculateStartCardinalityAreaSuggestion(IPMGraphicalSupplementTextRO comment, IPMFigureLineShapeRO figure) {
        boolean horizontal;
        double width = -10.0;
        double height = -10.0;
        Points points = new Points(4);
        IPMFigureLineShapeRO line = figure;
        IPMPointRO upperPoint = line.getPointListRO().getPointRO(1);
        IPMPointRO lowerPoint = line.getPointListRO().getPointRO(0);
        if (upperPoint.getPosition().y > lowerPoint.getPosition().y) {
            height *= -1.0;
        }
        if ((horizontal = Geo.equals((double)upperPoint.getPosition().y, (double)lowerPoint.getPosition().y)) && upperPoint.getPosition().x > lowerPoint.getPosition().x) {
            width *= -1.0;
        }
        points.add(new Point(lowerPoint.getPosition().x, lowerPoint.getPosition().y));
        points.add(new Point(lowerPoint.getPosition().x + width, lowerPoint.getPosition().y));
        points.add(new Point(lowerPoint.getPosition().x + width, lowerPoint.getPosition().y + height));
        points.add(new Point(lowerPoint.getPosition().x, lowerPoint.getPosition().y + height));
        return points;
    }
}

