/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.bpmn.bpd.edit;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.base.edit.IPEPlanElementWithCommentSupplement;
import com.arcway.planagent.planeditor.base.edit.PEPlanElementWithOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planeditor.base.inputinterpreter.EPEditNameOnPlanElement;
import com.arcway.planagent.planeditor.bpmn.bpd.edit.PEGraphicalSupplementDataListSymbol;
import com.arcway.planagent.planeditor.bpmn.bpd.edit.PEGraphicalSupplementInputOutputSymbol;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPDeleteCommentTextOnSupplement;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPEditCommentTextOnSupplement;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDDataObjectNewRO;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.EditPolicy;

public class PEPlanElementBPMNBPDDataObjectNew
extends PEPlanElementWithOutlineAndNameAndDescriptionSupplement
implements IPEPlanElementWithCommentSupplement {
    private static final double DEFAULT_COMMENT_WIDTH = 30.0;

    protected void createEditPolicies() {
        super.createEditPolicies();
        switch (this.getPEPlan().getMode()) {
            case 1: {
                this.installEditPolicy("planelement_edit_role", (EditPolicy)new EPEditNameOnPlanElement());
                this.installEditPolicy("commentsupplement_edit_role", (EditPolicy)new EPEditCommentTextOnSupplement());
                this.installEditPolicy("DELETE_COMMENT_ROLE", (EditPolicy)new EPDeleteCommentTextOnSupplement());
                break;
            }
            case 3: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public PEFigure getEditFigure() {
        return this.getOutlineFigure();
    }

    public Points getDefaultCommentArea() {
        Rectangle bounds = this.getPMPlanElementFMCWithOutline().getOutlineFigureRO().getPointListRO().getPoints().getBounds();
        Point lowerRight = bounds.lowerRight;
        Point upperLeft = bounds.upperLeft;
        Point base = new Point(lowerRight.x + 15.0, upperLeft.y);
        Points geometry = new Points();
        geometry.add(new Point(base.x - 15.0, base.y));
        geometry.add(new Point(base.x + 15.0, base.y));
        geometry.add(new Point(base.x + 15.0, base.y + bounds.h()));
        geometry.add(new Point(base.x - 15.0, base.y + bounds.h()));
        return geometry;
    }

    public boolean isFigureSelectable(PEFigure figureToCheck) {
        boolean isDataObjectFigure = ((IPMFigureRO)figureToCheck.getModel()).getRole().equals("dataobject");
        boolean isEdgeFigure = ((IPMFigureRO)figureToCheck.getModel()).getRole().equals("edge");
        return !isDataObjectFigure && !isEdgeFigure && super.isFigureSelectable(figureToCheck);
    }

    public Collection<TemplateApplicationTuple> getTemplateApplicationTuples() {
        Collection superTuples = super.getTemplateApplicationTuples();
        ArrayList<TemplateApplicationTuple> newTuples = new ArrayList<TemplateApplicationTuple>(superTuples.size() + 1);
        IPMPlanElementBPMNBPDDataObjectNewRO planElement = (IPMPlanElementBPMNBPDDataObjectNewRO)this.getPMPlanElement();
        IPMFigurePlaneRO outline = planElement.getOutlineFigurePlaneRO();
        for (TemplateApplicationTuple singleTuple : superTuples) {
            if (singleTuple.getPlanObject() == outline) continue;
            newTuples.add(singleTuple);
        }
        IPMFigurePlaneRO dataObjectFigure = planElement.getDataObjectFigureRO();
        TemplateApplicationTuple tuple = new TemplateApplicationTuple((IPMPlanObjectRO)dataObjectFigure, (IAppearanceRO)dataObjectFigure.getLineAppearanceRO());
        newTuples.add(tuple);
        tuple = new TemplateApplicationTuple((IPMPlanObjectRO)dataObjectFigure, (IAppearanceRO)dataObjectFigure.getFillAppearanceRO());
        newTuples.add(tuple);
        IPMFigureLineShapeRO edgeFigure = planElement.getEdgeFigureRO();
        tuple = new TemplateApplicationTuple((IPMPlanObjectRO)edgeFigure, (IAppearanceRO)edgeFigure.getLineAppearanceRO());
        newTuples.add(tuple);
        return newTuples;
    }

    protected boolean isGraphicalSupplementSelectable(PEGraphicalSupplement graphicalSupplement) {
        if (graphicalSupplement instanceof PEGraphicalSupplementDataListSymbol || graphicalSupplement instanceof PEGraphicalSupplementInputOutputSymbol) {
            return false;
        }
        return super.isGraphicalSupplementSelectable(graphicalSupplement);
    }
}

