/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.signature;

import com.arcway.lib.java.tuples.Tuple;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class DocumentSigner {
    public static Tuple<String, byte[]> signDocument(InputStream documentStream, File privateKeyFile) {
        byte[] keyBytes = null;
        try {
            FileInputStream keyStream = new FileInputStream(privateKeyFile);
            keyBytes = new byte[keyStream.available()];
            keyStream.read(keyBytes);
            keyStream.close();
        }
        catch (FileNotFoundException e1) {
            return new Tuple<String, Object>("Could not open file: " + privateKeyFile.getAbsolutePath(), null);
        }
        catch (IOException e) {
            return new Tuple<String, Object>("Could not read from file: " + privateKeyFile.getAbsolutePath(), null);
        }
        PKCS8EncodedKeySpec prvKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("DSA", "SUN");
        }
        catch (NoSuchAlgorithmException e9) {
            return new Tuple<String, Object>("Invalid key generation algorithm: DSA", null);
        }
        catch (NoSuchProviderException e9) {
            return new Tuple<String, Object>("Invalid algorithm provider: SUN", null);
        }
        PrivateKey privateKey = null;
        try {
            privateKey = keyFactory.generatePrivate(prvKeySpec);
        }
        catch (InvalidKeySpecException e2) {
            return new Tuple<String, Object>("Key data read from file \"" + privateKeyFile + "\" is invalid.", null);
        }
        Signature dsa = null;
        try {
            dsa = Signature.getInstance("SHA1withDSA", "SUN");
        }
        catch (NoSuchAlgorithmException e10) {
            return new Tuple<String, Object>("Invalid key generation algorithm: SHA1withDSA", null);
        }
        catch (NoSuchProviderException e10) {
            return new Tuple<String, Object>("Invalid algorithm provider: SUN", null);
        }
        try {
            dsa.initSign(privateKey);
        }
        catch (InvalidKeyException e3) {
            return new Tuple<String, Object>("Could not use the specified key to sign the file.", null);
        }
        byte[] signature = null;
        try {
            BufferedInputStream input = new BufferedInputStream(documentStream);
            byte[] chunk = new byte[1024];
            while (input.available() != 0) {
                int chunkLength = input.read(chunk);
                dsa.update(chunk, 0, chunkLength);
            }
            signature = dsa.sign();
        }
        catch (IOException e) {
            return new Tuple<String, Object>("Could not read from stream", null);
        }
        catch (SignatureException e) {
            return new Tuple<String, Object>("Failure while signing the data.", null);
        }
        return new Tuple<Object, byte[]>(null, signature);
    }
}

