/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.io;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.JvmExternalResourceInteractionExceptionFactory;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.operating.SafeRunner;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;

public class DataCopyHelper {
    private static final ILogger logger = Logger.getLogger(DataCopyHelper.class);
    public static final int bufferCapacity = 65536;

    public static void copyCharactersLeavingDestinationOpen(Reader source, Writer destination) throws JvmExternalResourceInteractionException {
        char[] buf = new char[65536];
        try {
            int read = source.read(buf);
            while (read >= 0) {
                if (read > 0) {
                    destination.write(buf, 0, read);
                }
                read = source.read(buf);
            }
            source.close();
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
    }

    public static void copyFile(final File source, final File destination) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while copying source file {0} to target file {1} ", source.getPath(), destination.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Throwable {
                block25: {
                    Throwable primaryEx = null;
                    Throwable foutCloseEx = null;
                    Throwable finCloseEx = null;
                    FileInputStream fin = null;
                    try {
                        fin = new FileInputStream(source);
                        FileOutputStream fout = null;
                        try {
                            try {
                                fout = new FileOutputStream(destination);
                                DataCopyHelper.streamCopy(fin, fout);
                            }
                            catch (Throwable th) {
                                primaryEx = th;
                                if (fout != null) {
                                    try {
                                        fout.close();
                                    }
                                    catch (Throwable th2) {
                                        foutCloseEx = th2;
                                    }
                                }
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (Throwable th) {
                                    foutCloseEx = th;
                                }
                            }
                            throw throwable;
                        }
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (Throwable th) {
                                foutCloseEx = th;
                            }
                        }
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable th) {
                                finCloseEx = th;
                            }
                        }
                        if (primaryEx != null) {
                            throw primaryEx;
                        }
                        if (foutCloseEx != null) {
                            throw foutCloseEx;
                        }
                        if (finCloseEx != null) {
                            throw finCloseEx;
                        }
                    }
                }
                destination.setLastModified(source.lastModified());
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void copyFile(final InputStream source, final File destination) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while copying Data Stream to target file {0} ", destination.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Throwable {
                Throwable primaryEx = null;
                Throwable foutCloseEx = null;
                Throwable sourceCloseEx = null;
                try {
                    FileOutputStream fout = null;
                    try {
                        try {
                            fout = new FileOutputStream(destination);
                            DataCopyHelper.streamCopy(source, fout);
                        }
                        catch (Throwable th) {
                            primaryEx = th;
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (Throwable th2) {
                                    foutCloseEx = th2;
                                }
                            }
                            try {
                                if (primaryEx != null && destination.isFile()) {
                                    FileHelper.deleteFileOrDirectory(destination);
                                }
                            }
                            catch (Throwable th3) {
                                logger.error("Deletion of garbled destination file failed: " + destination.toString(), th3);
                            }
                        }
                    }
                    finally {
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (Throwable th) {
                                foutCloseEx = th;
                            }
                        }
                        try {
                            if (primaryEx != null && destination.isFile()) {
                                FileHelper.deleteFileOrDirectory(destination);
                            }
                        }
                        catch (Throwable th) {
                            logger.error("Deletion of garbled destination file failed: " + destination.toString(), th);
                        }
                    }
                }
                finally {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable th) {
                            sourceCloseEx = th;
                        }
                    }
                    if (primaryEx != null) {
                        throw primaryEx;
                    }
                    if (foutCloseEx != null) {
                        throw foutCloseEx;
                    }
                    if (sourceCloseEx != null) {
                        throw sourceCloseEx;
                    }
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void copyFile(final InputStream source, final OutputStream destination) throws JvmExternalResourceInteractionException {
        String defaultmessage = "Error while copying Data Stream to Data Stream ";
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory("Error while copying Data Stream to Data Stream ");
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Throwable {
                block23: {
                    Throwable primaryEx = null;
                    Throwable foutCloseEx = null;
                    Throwable sourceCloseEx = null;
                    try {
                        OutputStream fout = null;
                        try {
                            try {
                                fout = destination;
                                DataCopyHelper.streamCopy(source, fout);
                            }
                            catch (Throwable th) {
                                primaryEx = th;
                                if (fout == null) break block23;
                                try {
                                    fout.close();
                                }
                                catch (Throwable th2) {
                                    foutCloseEx = th2;
                                }
                            }
                        }
                        finally {
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (Throwable th) {
                                    foutCloseEx = th;
                                }
                            }
                        }
                    }
                    finally {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable th) {
                                sourceCloseEx = th;
                            }
                        }
                        if (primaryEx != null) {
                            throw primaryEx;
                        }
                        if (foutCloseEx != null) {
                            throw foutCloseEx;
                        }
                        if (sourceCloseEx != null) {
                            throw sourceCloseEx;
                        }
                    }
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void copyFile(final IStreamResource source, final File destination) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while copying IResource''s Data Stream {0} to target file {1} ", source.getName(), destination.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Throwable {
                DataCopyHelper.copyFile(source.toInputStream(), destination);
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void copyFile(final File source, final OutputStream destination, final boolean closeDestinationStream) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while copying Content of File {0} to a OutputStream.", source.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Throwable {
                Throwable primaryEx = null;
                Throwable destinationCloseEx = null;
                Throwable finCloseEx = null;
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(source);
                    try {
                        try {
                            DataCopyHelper.streamCopy(fin, destination);
                        }
                        catch (Throwable th) {
                            primaryEx = th;
                            try {
                                if (closeDestinationStream) {
                                    destination.close();
                                }
                            }
                            catch (Throwable th2) {
                                destinationCloseEx = th2;
                            }
                        }
                    }
                    finally {
                        try {
                            if (closeDestinationStream) {
                                destination.close();
                            }
                        }
                        catch (Throwable th) {
                            destinationCloseEx = th;
                        }
                    }
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable th) {
                            finCloseEx = th;
                        }
                    }
                    if (primaryEx != null) {
                        throw primaryEx;
                    }
                    if (destinationCloseEx != null) {
                        throw destinationCloseEx;
                    }
                    if (finCloseEx != null) {
                        throw finCloseEx;
                    }
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void extractResourceToFile(Class classFromPackageContainingResource, String packageRelativeResourceName, File destinationFile) throws ResourceNotFoundException, JvmExternalResourceInteractionException {
        String packageName = classFromPackageContainingResource.getPackage().getName();
        String resourcePathName = String.valueOf(packageName.replace('.', '/')) + "/" + packageRelativeResourceName;
        InputStream is = classFromPackageContainingResource.getClassLoader().getResourceAsStream(resourcePathName);
        if (is == null) {
            throw new ResourceNotFoundException(MessageFormat.format("Classloader of Class {0} could not find Resource with the name {1} (Resolved resourcename={2}).", classFromPackageContainingResource.getName(), packageRelativeResourceName, resourcePathName));
        }
        DataCopyHelper.copyFile(is, destinationFile);
    }

    public static void extractResourceToStream(Class classFromPackageContainingResource, String packageRelativeResourceName, OutputStream destinationStream) throws ResourceNotFoundException, JvmExternalResourceInteractionException {
        String packageName = classFromPackageContainingResource.getPackage().getName();
        String resourcePathName = String.valueOf(packageName.replace('.', '/')) + "/" + packageRelativeResourceName;
        InputStream is = classFromPackageContainingResource.getClassLoader().getResourceAsStream(resourcePathName);
        if (is == null) {
            throw new ResourceNotFoundException(MessageFormat.format("Classloader of Class {0} could not find Resource with the name {1} (Resolved resourcename={2}).", classFromPackageContainingResource.getName(), packageRelativeResourceName, resourcePathName));
        }
        DataCopyHelper.copyFile(is, destinationStream);
    }

    private static void streamCopy(InputStream source, OutputStream destination) throws IOException, JvmExternalResourceInteractionException {
        FileChannel sourceChannel = source instanceof FileInputStream ? ((FileInputStream)source).getChannel() : null;
        FileChannel destinationChannel = destination instanceof FileOutputStream ? ((FileOutputStream)destination).getChannel() : null;
        if (sourceChannel != null) {
            if (destinationChannel != null) {
                DataCopyHelper.byteCopy((ByteChannel)sourceChannel, (ByteChannel)destinationChannel);
            } else {
                DataCopyHelper.byteCopy((ByteChannel)sourceChannel, destination);
            }
        } else if (destinationChannel != null) {
            DataCopyHelper.byteCopy(source, (ByteChannel)destinationChannel);
        } else {
            DataCopyHelper.byteCopy(source, destination);
        }
        destination.flush();
    }

    private static void byteCopy(InputStream source, OutputStream destination) throws IOException {
        int bytesRead;
        byte[] bufferArray = new byte[65536];
        while ((bytesRead = source.read(bufferArray)) > 0) {
            destination.write(bufferArray, 0, bytesRead);
        }
    }

    private static void byteCopy(InputStream source, ByteChannel destination) throws IOException, JvmExternalResourceInteractionException {
        block1: {
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            do {
                buffer.clear();
                int r = source.read(buffer.array());
                if (r == -1) break block1;
                buffer.position(r);
                buffer.flip();
                destination.write(buffer);
            } while (buffer.remaining() == 0);
            throw new JvmExternalResourceInteractionException("I/O Buffer still contained Data after trying to transfer the Buffer content to an I/O Channel.");
        }
    }

    private static void byteCopy(ByteChannel source, OutputStream destination) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (true) {
            buffer.clear();
            int r = source.read(buffer);
            if (r == -1) break;
            buffer.flip();
            destination.write(buffer.array(), buffer.position(), buffer.remaining());
        }
    }

    private static void byteCopy(ByteChannel source, ByteChannel destination) throws IOException, JvmExternalResourceInteractionException {
        block1: {
            ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
            do {
                buffer.clear();
                int r = source.read(buffer);
                if (r == -1) break block1;
                buffer.flip();
                destination.write(buffer);
            } while (buffer.remaining() == 0);
            throw new JvmExternalResourceInteractionException("I/O Buffer still contained Data after trying to transfer the Buffer content to an I/O Channel.");
        }
    }

    public static class ResourceNotFoundException
    extends Exception {
        public ResourceNotFoundException(String message) {
            super(message);
        }
    }
}

