/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.serverexceptions;

import de.plans.lib.util.StacktraceConverter;
import de.plans.psc.shared.message.EOException;

public class EXServerException
extends Exception {
    private final String group;
    private final String id;
    private String serverStacktrace;

    public EXServerException(String group, String id, String description) {
        super(description);
        this.group = group;
        this.id = id;
    }

    public EXServerException(String group, String id, String description, Exception cause) {
        super(description, cause);
        this.group = group;
        this.id = id;
    }

    public EXServerException(EOException eoException) {
        super(eoException.getDescription());
        this.group = eoException.getGroup();
        this.id = eoException.getId();
        this.serverStacktrace = eoException.getStackTrace();
        if (this.serverStacktrace == null) {
            this.serverStacktrace = "<server stacktrace not available>";
        }
        Exception serverExceptionSubstitute = new Exception(this.serverStacktrace);
        StackTraceElement[] stackTrace = serverExceptionSubstitute.getStackTrace();
        StackTraceElement[] reducedStackTrace = new StackTraceElement[]{stackTrace[0]};
        serverExceptionSubstitute.setStackTrace(new StackTraceElement[0]);
        this.setStackTrace(reducedStackTrace);
        this.initCause(serverExceptionSubstitute);
    }

    public EOException convertToEOException() {
        return new EOException(this.group, this.id, this.getMessage(), this.getServerStackTrace());
    }

    public String getServerStackTrace() {
        if (this.serverStacktrace == null) {
            return "ServerException: " + StacktraceConverter.stacktraceToString((Throwable)this);
        }
        return this.serverStacktrace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getId() {
        return this.id;
    }
}

