/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.message.Messages;

public class EOUser
extends EOEncodableObject
implements IPermissionOwner {
    public static final String USER_NAME_ADMIN = "Administrator";
    public static final String XML_NAME = "User";
    private static final String ATTR_TAG_USER_NAME = "userName";
    private static final String ATTR_TAG_DISPLAY_NAME = "displayName";
    private static final String ATTR_TAG_EMAIL = "email";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private String userName;
    private String displayName;
    private String email;
    private String description;
    private static EOUser UNKNOWN_USER;

    public static final EOUser getUnknownUser() {
        if (UNKNOWN_USER == null) {
            UNKNOWN_USER = new EOUser();
            UNKNOWN_USER.setDescription(Messages.getString("EOUser.unknown_user"));
            UNKNOWN_USER.setDisplayName(Messages.getString("EOUser.unknown_user"));
            UNKNOWN_USER.setUserName("unknown_user");
        }
        return UNKNOWN_USER;
    }

    public EOUser() {
        super(XML_NAME);
    }

    public EOUser(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOUser(EOUser user) {
        super(XML_NAME);
        this.description = user.getDescription();
        this.displayName = user.getDisplayName();
        this.email = user.getEmail();
        this.userName = user.getUserName();
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_USER_NAME, this.getUserName());
        this.appendAttrToXML(writeContext, ATTR_TAG_DISPLAY_NAME, this.getDisplayName());
        this.appendAttrToXML(writeContext, ATTR_TAG_EMAIL, this.getEmail());
        this.appendAttrToXML(writeContext, ATTR_TAG_DESCRIPTION, this.getDescription());
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_USER_NAME)) {
            this.setUserName(value);
        } else if (name.equals(ATTR_TAG_DISPLAY_NAME)) {
            this.setDisplayName(value);
        } else if (name.equals(ATTR_TAG_EMAIL)) {
            this.setEmail(value);
        } else if (name.equals(ATTR_TAG_DESCRIPTION)) {
            this.setDescription(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getUserName() {
        if (this.userName == null) {
            return "";
        }
        return this.userName;
    }

    @Override
    public String getPermissionOwnerID() {
        return this.getUserName();
    }

    @Override
    public int getPermissionOwnerType() {
        return 0;
    }

    @Override
    public String getPermissionOwnerName() {
        return String.valueOf(this.getDisplayName()) + "   (" + this.getUserName() + ")";
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return "";
        }
        return this.displayName;
    }

    public String getEmail() {
        if (this.email == null) {
            return "";
        }
        return this.email;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setUserName(String uname) {
        this.userName = uname;
    }

    public void setDisplayName(String dname) {
        this.displayName = dname;
    }

    public void setEmail(String mail) {
        this.email = mail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EOUser copy() {
        EOUser copy = new EOUser();
        copy.setDescription(this.description);
        copy.setUserName(this.userName);
        copy.setDisplayName(this.displayName);
        copy.setEmail(this.email);
        return copy;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof EOUser) {
                EOUser user = (EOUser)obj;
                return this.getUserName().equals(user.getUserName());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getUserName().hashCode();
    }
}

