/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompressionType {
    private static final char SEPARATOR_CHAR = 'p';
    private static final HashMap<String, CompressionType> compressionTypes = new HashMap();
    public static final CompressionType NO_COMPRESSION = new CompressionType("NoCompression", ".xml");
    public static final CompressionType ZIP_COMPRESSION = new CompressionType("ZipCompression", ".zip");
    private final String name;
    private final String traceLogFileExtension;

    public static CompressionType getCompressionTypeByName(String compressionTypeName) {
        return compressionTypes.get(compressionTypeName);
    }

    public static Set<String> encodePreferredCompressionTypeListAsHttpHeaderValues(CompressionType[] preferredCompressionTypes) {
        HashSet<String> result = new HashSet<String>();
        int t = 0;
        while (t < preferredCompressionTypes.length) {
            result.add(String.valueOf(Integer.toString(t)) + 'p' + preferredCompressionTypes[t].getName());
            ++t;
        }
        return result;
    }

    public static List<CompressionType> decodeCompressionTypeHttpHeaderValuesAsList(Enumeration<String> compressionTypeHttpHeaderValues) throws CompressionTypeHttpHeaderDecodingException {
        HashMap<Integer, String> preferredCompressionTypesRaw = new HashMap<Integer, String>();
        ArrayList<Integer> preferenceLevels = new ArrayList<Integer>();
        while (compressionTypeHttpHeaderValues.hasMoreElements()) {
            String preferredCompressionTypeHttpHeaderMultiValue = compressionTypeHttpHeaderValues.nextElement();
            ArrayList<String> compressionTypeHttpHeaderSingleValues = new ArrayList<String>();
            if (preferredCompressionTypeHttpHeaderMultiValue != null && preferredCompressionTypeHttpHeaderMultiValue.trim().length() > 0) {
                String[] stringArray = preferredCompressionTypeHttpHeaderMultiValue.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String candidateValue = stringArray[n2];
                    String trimmedCandidateValue = candidateValue.trim();
                    if (trimmedCandidateValue.length() > 0) {
                        compressionTypeHttpHeaderSingleValues.add(trimmedCandidateValue);
                    }
                    ++n2;
                }
            }
            for (String preferredCompressionTypeHttpHeaderValue : compressionTypeHttpHeaderSingleValues) {
                int indexOfSeparator = preferredCompressionTypeHttpHeaderValue.indexOf(112);
                if (indexOfSeparator < 0) {
                    throw new CompressionTypeHttpHeaderDecodingException("CompressionType Http Header value without separator received \"" + preferredCompressionTypeHttpHeaderValue + "\".");
                }
                try {
                    Integer preferenceLevel = Integer.valueOf(preferredCompressionTypeHttpHeaderValue.substring(0, indexOfSeparator));
                    String compressionTypeName = preferredCompressionTypeHttpHeaderValue.substring(indexOfSeparator + 1);
                    preferredCompressionTypesRaw.put(preferenceLevel, compressionTypeName);
                    preferenceLevels.add(preferenceLevel);
                }
                catch (NumberFormatException e) {
                    throw new CompressionTypeHttpHeaderDecodingException("Unparseable CompressionType pereference number in Http Header value detected: \"" + preferredCompressionTypeHttpHeaderValue + "\".", e);
                }
            }
        }
        Collections.sort(preferenceLevels);
        ArrayList<CompressionType> result = new ArrayList<CompressionType>();
        int i = 0;
        while (i < preferenceLevels.size()) {
            Integer level = (Integer)preferenceLevels.get(i);
            if (level != i) {
                throw new CompressionTypeHttpHeaderDecodingException("Incomplete Set of CompressionType HttpHeaders received (missing: " + i + ", next:" + level + ")");
            }
            CompressionType compressionType = CompressionType.getCompressionTypeByName((String)preferredCompressionTypesRaw.get(level));
            if (compressionType != null) {
                result.add(compressionType);
            }
            ++i;
        }
        return result;
    }

    private CompressionType(String name, String traceLogFileExtension) {
        this.name = name;
        this.traceLogFileExtension = traceLogFileExtension;
        compressionTypes.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public String getTraceLogFileExtension() {
        return this.traceLogFileExtension;
    }

    public String toString() {
        return this.name;
    }

    public static class CompressionTypeHttpHeaderDecodingException
    extends Exception {
        public CompressionTypeHttpHeaderDecodingException(String message, Throwable cause) {
            super(message, cause);
        }

        public CompressionTypeHttpHeaderDecodingException(String message) {
            super(message);
        }

        public CompressionTypeHttpHeaderDecodingException(Throwable cause) {
            super(cause);
        }
    }
}

