/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.logging.LoggingInitializer;
import de.plans.lib.util.LogFileAppender;
import de.plans.lib.util.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.parameter.EOParameterSet;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import java.io.File;

public class PSCClientLogMgr
implements IEncodableObjectFactory {
    protected LoggingParameterSet parameterSet = new LoggingParameterSet();

    public PSCClientLogMgr() {
        LoggingInitializer.setupLog4j();
        Logger.getLogger((String)"PSCClient").debug((Object)"Created PSC Client");
    }

    public void constructWithDefaults(PSCApplicationIdentifier applicationIdentifier) {
        this.parameterSet.setLogFilePath(String.valueOf(EclipsePlugin.getWorkspace().getRoot().getLocation().toString()) + File.separator + "Cockpit.log");
        this.parameterSet.setMaxFileLength(0x100000L);
        this.setup();
    }

    public void setup() {
        File logFile = new File(this.parameterSet.getLogFilePath());
        if (logFile.getParentFile() != null && !logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        long maxFileSize = 0L;
        if (this.parameterSet.getMaxFileLength() > 0L) {
            maxFileSize = this.parameterSet.getMaxFileLength();
        }
        LogFileAppender.setLogFileAttributes((String)logFile.getAbsolutePath(), (long)maxFileSize);
        Logger.getLogger((String)"PSCClient").debug((Object)"Configured Log Mgr");
    }

    public void registerParameterSets(XMLConfigParameterMgr parameterMgr) {
        parameterMgr.registerEncodableObjectFactory(this.parameterSet.getTag(), (IEncodableObjectFactory)this);
        parameterMgr.addSubtreeRootElement((EOParameterSet)this.parameterSet);
    }

    public EncodableObjectBase createEncodableObject(String elementName, XMLContext context) throws EXDecoderException {
        if (this.parameterSet.getTag().equals(elementName)) {
            return this.parameterSet;
        }
        return null;
    }

    public boolean configurationIsLoadedFromFile() {
        return this.parameterSet.hasBeenReadFromXMLFile();
    }

    public LoggingParameterSet getParameterSet() {
        return this.parameterSet;
    }

    public static class LoggingParameterSet
    extends EOParameterSet {
        public static String XML_NAME = "LogFile";
        private String logFilePath = "logfile.log";
        private long maxFileLength = 32768L;
        private static final String ATTR_TAG_LOGFILE_PATH = "logFilePath";
        private static final String ATTR_TAG_MAX_FILE_LENTGH = "maxFileLength";
        private boolean isReadFromFile = false;

        public LoggingParameterSet(XMLContext xmlContext) {
            super(XML_NAME, xmlContext);
        }

        public LoggingParameterSet() {
            super(XML_NAME);
        }

        protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
            this.appendAttrToXML(writeContext, ATTR_TAG_LOGFILE_PATH, this.logFilePath);
            this.appendAttrToXML(writeContext, ATTR_TAG_MAX_FILE_LENTGH, this.maxFileLength);
        }

        protected boolean setAttributeFromXML(String name, String value) {
            boolean knownAttribute = true;
            this.isReadFromFile = true;
            if (name.equals(ATTR_TAG_LOGFILE_PATH)) {
                this.logFilePath = value;
            } else if (name.equals(ATTR_TAG_MAX_FILE_LENTGH)) {
                this.maxFileLength = Long.parseLong(value);
            } else {
                knownAttribute = false;
            }
            return knownAttribute;
        }

        protected boolean hasChildren() {
            return false;
        }

        protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        }

        protected boolean addChildFromXML(EncodableObjectBase newChild) {
            return false;
        }

        public String getLogFilePath() {
            return this.logFilePath;
        }

        public long getMaxFileLength() {
            return this.maxFileLength;
        }

        public void setLogFilePath(String path) {
            this.logFilePath = path;
        }

        public void setMaxFileLength(long length) {
            this.maxFileLength = length;
        }

        public boolean hasBeenReadFromXMLFile() {
            return this.isReadFromFile;
        }

        public void reset() {
        }
    }
}

