/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.psc.eclipse.client.configlogging;

import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.network.HostNameRetriever;
import com.arcway.lib.network.UserNameRetriever;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.WorkspaceUIDAccessAgent;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.ui.internal.ConfigurationInfo;

public class ClientSoftwareConfigLogger {
    private static final ILogger LOGGER = Logger.getLogger(ClientSoftwareConfigLogger.class);
    private static final String ZIP_EXTENSION = ".zip";

    public static void sendClientSoftwareConfigInfoToServer(RequestForwarder requestForwarder, String serverID) throws Exception {
        String systemSummary = ConfigurationInfo.getSystemSummary();
        String hostname = "unknown-host";
        try {
            hostname = HostNameRetriever.getHostname();
        }
        catch (HostNameRetriever.UnableToRetrieveHostnameException e1) {
            LOGGER.debug("Unable to retrieve hostname", (Throwable)e1);
        }
        String username = "unknown-user";
        try {
            username = UserNameRetriever.getUsername();
        }
        catch (UserNameRetriever.UnableToRetrieveUsernameException e1) {
            LOGGER.debug("Unable to retrieve username", (Throwable)e1);
        }
        String workspaceUID = WorkspaceUIDAccessAgent.getWorkspaceUID(PSCClientServiceFacade.getFacade().getRootDirectory());
        if (workspaceUID == null) {
            workspaceUID = "unknown-workspaceUID";
        }
        File configInfoFile = SessionTempDirectoryManager.createSessionTempFile((String)"clientinfo", (String)ZIP_EXTENSION);
        try {
            FileOutputStream configInfoFileOS = new FileOutputStream(configInfoFile);
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(configInfoFileOS));
                ZipEntry e = new ZipEntry("SystemSummary.txt");
                zipOutputStream.putNextEntry(e);
                zipOutputStream.write(systemSummary.getBytes());
                zipOutputStream.close();
            }
            finally {
                try {
                    configInfoFileOS.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Unable to close outputStream for temporary file " + configInfoFile, (Throwable)e);
                }
            }
            EOClientRequest transferIDReq = new EOClientRequest("softwareconfiguration.client", "softwareconfiguration.GetConfigInfoUploadTransferID", null);
            EOServerResponse serverResponse = requestForwarder.sendRequest(serverID, transferIDReq);
            String transferID = ((EOValue)serverResponse.getResponseData()).getValue();
            ArrayList<String> transferIDs = new ArrayList<String>();
            transferIDs.add(transferID);
            ArrayList<File> files = new ArrayList<File>();
            files.add(configInfoFile);
            requestForwarder.uploadFiles(serverID, transferIDs, files);
            EOList requestParameter = new EOList();
            requestParameter.add((EncodableObjectBase)new EOValue(transferID));
            requestParameter.add((EncodableObjectBase)new EOValue(ZIP_EXTENSION));
            requestParameter.add((EncodableObjectBase)new EOValue(hostname));
            requestParameter.add((EncodableObjectBase)new EOValue(username));
            requestParameter.add((EncodableObjectBase)new EOValue(workspaceUID));
            EOClientRequest archiveReq = new EOClientRequest("softwareconfiguration.client", "softwareconfiguration.ArchiveConfigInfo", (EncodableObjectBase)requestParameter);
            requestForwarder.sendRequest(serverID, archiveReq);
        }
        finally {
            try {
                FileHelper.deleteFileOrDirectory((File)configInfoFile);
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.debug("Problem while trying to delete obsolete file: " + configInfoFile, (Throwable)e);
            }
        }
    }
}

