/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;

public class EOTuple
extends EOEncodableObject {
    public static final String XML_NAME = "Tuple";
    private String[] values;
    private ArrayList constructionList;
    private ArrayList indexList;

    public EOTuple(int n) {
        super(XML_NAME);
        this.values = new String[n];
    }

    public EOTuple(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    public void endElement() throws EXDecoderException {
        if (this.values.length != this.constructionList.size()) {
            throw new EXDecoderException("EOTuple: more elements than expected!");
        }
        int i = this.constructionList.size() - 1;
        while (i >= 0) {
            int pos = (Integer)this.indexList.remove(0);
            this.values[pos] = (String)this.constructionList.remove(0);
            --i;
        }
        this.constructionList = null;
        this.indexList = null;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, "dim", this.getDimension());
        int i = 0;
        while (i < this.values.length) {
            this.appendAttrToXML(writeContext, "v" + i, this.values[i]);
            ++i;
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        if (this.constructionList == null) {
            this.constructionList = new ArrayList();
            this.indexList = new ArrayList();
        }
        if (name.equals("dim")) {
            this.values = new String[Integer.parseInt(value)];
        } else {
            this.indexList.add(new Integer(name.substring(1)));
            this.constructionList.add(value);
        }
        return true;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public void addValue(int index, String value) {
        this.values[index] = value;
    }

    public void addValue(int index, int value) {
        this.values[index] = Integer.toString(value);
    }

    public void addValue(int index, float value) {
        this.values[index] = Float.toString(value);
    }

    public void addValue(int index, double value) {
        this.values[index] = Double.toString(value);
    }

    public void addValue(int index, boolean value) {
        this.values[index] = Boolean.toString(value);
    }

    public String[] getValues() {
        return this.values;
    }

    public int getDimension() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public long getNumberOfBytes() {
        if (this.values == null) {
            return 0L;
        }
        long toReturn = 0L;
        String[] stringArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element != null) {
                toReturn += (long)element.length();
            }
            ++n2;
        }
        return toReturn;
    }
}

