/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.codec.Base64;
import com.arcway.lib.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PasswordEncoder2 {
    private static String passwordMarker = "##";

    public static String encodePassword(String password) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            Logger.getLogger(PasswordEncoder2.class).warn("Could not encode password. SHA algorithm not sipported by the employed Java version.", (Throwable)e);
            return password;
        }
        try {
            md.update(password.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(PasswordEncoder2.class).warn("Problem while encoding password: UTF-8 not sipported by the employed Java version. Using default encoding instead.", (Throwable)e);
            md.update(password.getBytes());
        }
        byte[] raw = md.digest();
        String hash = new String(Base64.encodeBytes((byte[])raw, (boolean)false));
        return String.valueOf(passwordMarker) + hash;
    }

    public static boolean isEncoded(String password) {
        if (password == null) {
            return false;
        }
        return password.startsWith(passwordMarker);
    }

    public static boolean passwordsMatch(String enteredPassword, String passwordInDB) {
        if (enteredPassword == null && passwordInDB == null) {
            return true;
        }
        if (enteredPassword == null || passwordInDB == null) {
            return false;
        }
        if (!PasswordEncoder2.isEncoded(enteredPassword)) {
            enteredPassword = PasswordEncoder2.encodePassword(enteredPassword);
        }
        if (!PasswordEncoder2.isEncoded(passwordInDB)) {
            passwordInDB = PasswordEncoder2.encodePassword(passwordInDB);
        }
        return enteredPassword.equals(passwordInDB);
    }
}

