/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.lic;

import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class BufferingPaddingHelper {
    private byte[] bytesToBeEncrypted;
    private static final byte paddingPattern = 97;
    private static final byte paddingReturn = 13;
    private static final byte paddingNewline = 10;

    public void writeEncrypted(OutputStream output, byte[] contentBytes, boolean lastChunk, Cipher encryptCipher) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, IOException {
        byte[] oldBytes = this.bytesToBeEncrypted == null ? new byte[]{} : this.bytesToBeEncrypted;
        this.bytesToBeEncrypted = new byte[oldBytes.length + contentBytes.length];
        System.arraycopy(oldBytes, 0, this.bytesToBeEncrypted, 0, oldBytes.length);
        System.arraycopy(contentBytes, 0, this.bytesToBeEncrypted, oldBytes.length, contentBytes.length);
        if (lastChunk) {
            int paddingBytesNeeded = 0;
            int blocksize = encryptCipher.getBlockSize();
            paddingBytesNeeded = blocksize == 0 ? 0 : (blocksize - (this.bytesToBeEncrypted.length + 2) % blocksize) % blocksize;
            oldBytes = this.bytesToBeEncrypted;
            this.bytesToBeEncrypted = new byte[oldBytes.length + paddingBytesNeeded + 2];
            System.arraycopy(oldBytes, 0, this.bytesToBeEncrypted, 0, oldBytes.length);
            int i = 0;
            while (i < paddingBytesNeeded) {
                this.bytesToBeEncrypted[oldBytes.length + i] = 97;
                ++i;
            }
            this.bytesToBeEncrypted[this.bytesToBeEncrypted.length - 2] = 13;
            this.bytesToBeEncrypted[this.bytesToBeEncrypted.length - 1] = 10;
            byte[] encryptedBytes = encryptCipher.doFinal(this.bytesToBeEncrypted);
            output.write(encryptedBytes);
            this.bytesToBeEncrypted = null;
        }
    }
}

