/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import de.plans.lib.xml.EOFloatWithKey;
import de.plans.lib.xml.ISaveListener;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOBoolean;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class EOArcwayMemento
extends EOEncodableObject
implements IArcwayMemento {
    private static final ILogger logger = Logger.getLogger(EOArcwayMemento.class);
    public static final String XML_NAME = "com.arcway.cockpit.frame.client.project.localsettings.EOLocalSetting";
    private static final String TYPE_TAG = "type";
    private static final String TEXTNODE_TAG = "textnode";
    private static final String REQUESTER_ID_TAG = "requesterID";
    private static final String FLOATS_TAG = "floats";
    private static final String INTEGERS_TAG = "integers";
    private static final String STRINGS_TAG = "strings";
    private static final String BOOLEANS_TAG = "booleans";
    private static final String CHILDREN_TAG = "childMementos";
    private static final Comparator<EOEncodableObjectWithRole> ROLE_COMPARATOR = new Comparator<EOEncodableObjectWithRole>(){

        @Override
        public int compare(EOEncodableObjectWithRole o1, EOEncodableObjectWithRole o2) {
            return o1.getRole().compareTo(o2.getRole());
        }
    };
    private static final Comparator<EOArcwayMemento> MEMENTO_COMPARATOR = new Comparator<EOArcwayMemento>(){

        @Override
        public int compare(EOArcwayMemento o1, EOArcwayMemento o2) {
            int result = o1.type.compareTo(o2.type);
            if (result == 0) {
                String id1 = o1.getID() != null ? o1.getID() : "";
                String id2 = o2.getID() != null ? o2.getID() : "";
                result = id1.compareTo(id2);
            }
            return result;
        }
    };
    private final EOList<EOArcwayMemento> children = new EOList("childMementos");
    private final ISaveListener saveListener;
    private String requesterID;
    private EOList<EOEncodableObjectWithRole> floats = new EOList("floats");
    private EOList<EOEncodableObjectWithRole> integers = new EOList("integers");
    private EOList<EOEncodableObjectWithRole> strings = new EOList("strings");
    private EOList<EOEncodableObjectWithRole> booleans = new EOList("booleans");
    private String textNode;
    private String type;

    private EOArcwayMemento(String type, ISaveListener saveListener) {
        super(XML_NAME);
        this.type = type;
        this.saveListener = saveListener;
    }

    public EOArcwayMemento(String requesterID, String type, ISaveListener saveListener) {
        this(type, saveListener);
        this.requesterID = requesterID;
    }

    public EOArcwayMemento(XMLContext xmlContext, ISaveListener saveListener) {
        super(XML_NAME, xmlContext);
        this.saveListener = saveListener;
    }

    public IArcwayMemento createChild(String childType) {
        EOArcwayMemento childMemento = new EOArcwayMemento(childType, this.saveListener);
        this.children.add((EncodableObjectBase)childMemento);
        this.saveListener.save();
        return childMemento;
    }

    public IArcwayMemento createChild(String childType, String id) {
        Iterator childrenIterator = this.children.iterator();
        while (childrenIterator.hasNext()) {
            EOArcwayMemento child = (EOArcwayMemento)((Object)childrenIterator.next());
            if (!child.type.equals(childType) || !child.getID().equals(id)) continue;
            childrenIterator.remove();
        }
        IArcwayMemento childMemento = this.createChild(childType);
        childMemento.putString("IMemento.internal.id", id);
        this.saveListener.save();
        return childMemento;
    }

    public IArcwayMemento getChild(String childType) {
        IArcwayMemento[] children_ = this.getChildren(childType);
        if (children_.length > 0) {
            return children_[0];
        }
        return null;
    }

    public IArcwayMemento getChild(String childType, String id) {
        IArcwayMemento[] children_;
        IArcwayMemento[] iArcwayMementoArray = children_ = this.getChildren(childType);
        int n = children_.length;
        int n2 = 0;
        while (n2 < n) {
            IArcwayMemento child = iArcwayMementoArray[n2];
            if (child.getID().equals(id)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public IArcwayMemento[] getChildren(String childType) {
        ArrayList<EOArcwayMemento> childrenOfType = new ArrayList<EOArcwayMemento>();
        for (EOArcwayMemento setting : this.children) {
            if (!setting.type.equals(childType)) continue;
            childrenOfType.add(setting);
        }
        IArcwayMemento[] mementos = new IArcwayMemento[childrenOfType.size()];
        int nr = 0;
        for (IArcwayMemento memento : childrenOfType) {
            mementos[nr++] = memento;
        }
        return mementos;
    }

    public IArcwayMemento[] getChildren() {
        return (IArcwayMemento[])this.children.toArray((Object[])new IArcwayMemento[this.children.size()]);
    }

    public Float getFloat(String key) {
        EOFloatWithKey fwk = (EOFloatWithKey)this.getObject(this.floats, key);
        if (fwk != null) {
            return fwk.getFloat();
        }
        return null;
    }

    public String getID() {
        return this.getString("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        EOEncodableObjectWithRole eo = this.getObject(this.integers, key);
        if (eo != null && eo instanceof EOInteger) {
            EOInteger iwk = (EOInteger)eo;
            return iwk.getInteger();
        }
        return null;
    }

    public String getString(String key) {
        EOEncodableObjectWithRole eo = this.getObject(this.strings, key);
        if (eo != null && eo instanceof EOString) {
            EOString swk = (EOString)eo;
            return swk.getString();
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        EOEncodableObjectWithRole eo = this.getObject(this.booleans, key);
        if (eo != null && eo instanceof EOBoolean) {
            EOBoolean swk = (EOBoolean)eo;
            return swk.getBoolean();
        }
        return null;
    }

    private EOEncodableObjectWithRole getObject(EOList<EOEncodableObjectWithRole> list, String role) {
        for (EOEncodableObjectWithRole owr : list) {
            if (!owr.getRole().equals(role)) continue;
            return owr;
        }
        return null;
    }

    private void addObject(EOList<EOEncodableObjectWithRole> list, EOEncodableObjectWithRole owr) {
        EOEncodableObjectWithRole existing = this.getObject(list, owr.getRole());
        if (existing != null) {
            list.remove((Object)existing);
        }
        list.add((EncodableObjectBase)owr);
    }

    public String getTextData() {
        return this.textNode;
    }

    public void putFloat(String key, float value) {
        EOFloatWithKey fwk = new EOFloatWithKey(key, new Float(value));
        this.addObject(this.floats, fwk);
        this.saveListener.save();
    }

    public void putInteger(String key, int value) {
        EOInteger iwk = new EOInteger(new Integer(value), key);
        this.addObject(this.integers, (EOEncodableObjectWithRole)iwk);
        this.saveListener.save();
    }

    public void putMemento(IArcwayMemento memento) {
        assert (false) : "not implemented";
    }

    public void putString(String key, String value) {
        EOString swk = new EOString(value, key);
        this.addObject(this.strings, (EOEncodableObjectWithRole)swk);
        this.saveListener.save();
    }

    public void putBoolean(String key, boolean value) {
        EOBoolean bwk = new EOBoolean(Boolean.valueOf(value), key);
        this.addObject(this.booleans, (EOEncodableObjectWithRole)bwk);
        this.saveListener.save();
    }

    public void putTextData(String data) {
        this.textNode = data;
        this.saveListener.save();
    }

    public String getRequesterID() {
        return this.requesterID;
    }

    public String getType() {
        return this.type;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttrToXML(writeContext, TYPE_TAG, this.type);
        super.appendAttrToXML(writeContext, TEXTNODE_TAG, this.textNode);
        super.appendAttrToXML(writeContext, REQUESTER_ID_TAG, this.requesterID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(REQUESTER_ID_TAG)) {
            this.requesterID = value;
            return true;
        }
        if (name.equals(TEXTNODE_TAG)) {
            this.textNode = value;
            return true;
        }
        if (name.equals(TYPE_TAG)) {
            this.type = value;
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        return !this.children.isEmpty() || !this.floats.isEmpty() || !this.integers.isEmpty() || !this.strings.isEmpty() || !this.booleans.isEmpty();
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        Collections.sort(this.strings, ROLE_COMPARATOR);
        this.strings.writeXMLBody(writeContext, depth);
        Collections.sort(this.floats, ROLE_COMPARATOR);
        this.floats.writeXMLBody(writeContext, depth);
        Collections.sort(this.integers, ROLE_COMPARATOR);
        this.integers.writeXMLBody(writeContext, depth);
        Collections.sort(this.booleans, ROLE_COMPARATOR);
        this.booleans.writeXMLBody(writeContext, depth);
        Collections.sort(this.children, MEMENTO_COMPARATOR);
        this.children.writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            if (list.getRole().equals(STRINGS_TAG)) {
                this.strings = list;
                return true;
            }
            if (list.getRole().equals(FLOATS_TAG)) {
                this.floats = list;
                return true;
            }
            if (list.getRole().equals(INTEGERS_TAG)) {
                this.integers = list;
                return true;
            }
            if (list.getRole().equals(BOOLEANS_TAG)) {
                this.booleans = list;
                return true;
            }
            if (list.getRole().equals(CHILDREN_TAG)) {
                this.children.addAll((Collection)list);
                return true;
            }
        } else if (newChild instanceof EOArcwayMemento) {
            this.children.add((EncodableObjectBase)((EOArcwayMemento)newChild));
        }
        return false;
    }

    public boolean writeFile(File file) {
        boolean success = false;
        try {
            BufferedOutputStream b_out = new BufferedOutputStream(new FileOutputStream(file));
            success = this.write(b_out, true);
        }
        catch (FileNotFoundException e) {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean write(OutputStream b_out, boolean formatOutput) {
        try {
            EOArcwayMemento eOArcwayMemento = this;
            synchronized (eOArcwayMemento) {
                this.writeToXMLStream(b_out, formatOutput);
            }
            b_out.close();
            return true;
        }
        catch (Exception e) {
            logger.error("could not write stakeholder modifications to file", (Throwable)e);
            return false;
        }
    }
}

