/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import java.util.Comparator;

public class StringComparatorFactory {
    private static final IgnoreCaseComparator ignoreCaseComparator = new IgnoreCaseComparator();
    private static final ObserveCaseComparator observeCaseComparator = new ObserveCaseComparator();

    public static Comparator<String> getStringComparator(boolean ignoreCase) {
        if (ignoreCase) {
            return ignoreCaseComparator;
        }
        return observeCaseComparator;
    }

    private static class IgnoreCaseComparator
    implements Comparator<String> {
        private IgnoreCaseComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class ObserveCaseComparator
    implements Comparator<String> {
        private ObserveCaseComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }
}

